/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class UpdateVirtualMachineOptions
extends BaseHttpRequestOptions {
    public static final UpdateVirtualMachineOptions NONE = new UpdateVirtualMachineOptions();

    public UpdateVirtualMachineOptions displayName(String displayName) {
        this.queryParameters.replaceValues("displayname", ImmutableSet.of(displayName));
        return this;
    }

    public UpdateVirtualMachineOptions group(String group) {
        this.queryParameters.replaceValues("group", ImmutableSet.of(group));
        return this;
    }

    public UpdateVirtualMachineOptions haEnable(boolean haEnable) {
        this.queryParameters.replaceValues("haenable", ImmutableSet.of(String.valueOf(haEnable)));
        return this;
    }

    public UpdateVirtualMachineOptions osTypeId(String osTypeId) {
        this.queryParameters.replaceValues("ostypeid", ImmutableSet.of(String.valueOf(osTypeId)));
        return this;
    }

    public UpdateVirtualMachineOptions userData(byte[] unencodedData) {
        int length = Preconditions.checkNotNull(unencodedData, "unencodedData").length;
        Preconditions.checkArgument(length > 0, "userData cannot be empty");
        Preconditions.checkArgument(length <= 2048, "userData cannot be larger than 2kb");
        this.queryParameters.replaceValues("userdata", ImmutableSet.of(BaseEncoding.base64().encode(unencodedData)));
        return this;
    }

    public static class Builder {
        public static UpdateVirtualMachineOptions displayName(String displayName) {
            UpdateVirtualMachineOptions options = new UpdateVirtualMachineOptions();
            return options.displayName(displayName);
        }

        public static UpdateVirtualMachineOptions group(String group) {
            UpdateVirtualMachineOptions options = new UpdateVirtualMachineOptions();
            return options.group(group);
        }

        public static UpdateVirtualMachineOptions haEnable(boolean haEnable) {
            UpdateVirtualMachineOptions options = new UpdateVirtualMachineOptions();
            return options.haEnable(haEnable);
        }

        public static UpdateVirtualMachineOptions osTypeId(String osTypeId) {
            UpdateVirtualMachineOptions options = new UpdateVirtualMachineOptions();
            return options.osTypeId(osTypeId);
        }

        public static UpdateVirtualMachineOptions userData(byte[] unencodedData) {
            UpdateVirtualMachineOptions options = new UpdateVirtualMachineOptions();
            return options.userData(unencodedData);
        }
    }
}

