/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindTemplateMetadataToQueryParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof TemplateMetadata, "this binder is only valid for TemplateMetadata");
        TemplateMetadata metadata = (TemplateMetadata)input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        builder.put("name", metadata.getName());
        builder.put("ostypeid", metadata.getOsTypeId());
        builder.put("displaytext", metadata.getDisplayText());
        if (metadata.getSnapshotId() != null) {
            builder.put("snapshotid", metadata.getSnapshotId());
        }
        if (metadata.getVolumeId() != null) {
            builder.put("volumeid", metadata.getVolumeId());
        }
        if (metadata.getVirtualMachineId() != null) {
            builder.put("virtualmachineid", metadata.getVirtualMachineId());
        }
        if (metadata.isPasswordEnabled() != null) {
            builder.put("passwordenabled", metadata.isPasswordEnabled().toString());
        }
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParams(builder.build())).build();
    }
}

