/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.options.AzureTemplateOptions;
import org.jclouds.azurecompute.arm.domain.AvailabilitySet;
import org.jclouds.compute.domain.Template;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;

@Singleton
public class TemplateToAvailabilitySet
implements Function<Template, AvailabilitySet> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final AzureComputeApi api;

    @Inject
    TemplateToAvailabilitySet(AzureComputeApi api) {
        this.api = api;
    }

    @Override
    @Nullable
    public AvailabilitySet apply(Template input) {
        Preconditions.checkArgument(input.getOptions() instanceof AzureTemplateOptions, "An AzureTemplateOptions object is required");
        AzureTemplateOptions options = input.getOptions().as(AzureTemplateOptions.class);
        AvailabilitySet availabilitySet = null;
        String location = input.getLocation().getId();
        String resourceGroup = options.getResourceGroup();
        if (options.getAvailabilitySetName() != null) {
            availabilitySet = this.api.getAvailabilitySetApi(resourceGroup).get(options.getAvailabilitySetName());
            Preconditions.checkArgument(availabilitySet != null, "No availability set with name '%s' was found", options.getAvailabilitySetName());
            Preconditions.checkArgument(location.equals(availabilitySet.location()), "The availability set %s does not belong to location %s", options.getAvailabilitySetName(), location);
        } else if (options.getAvailabilitySet() != null) {
            availabilitySet = this.api.getAvailabilitySetApi(resourceGroup).get(options.getAvailabilitySet().name());
            if (availabilitySet != null) {
                Preconditions.checkArgument(location.equals(availabilitySet.location()), "The availability set %s does not belong to location %s", options.getAvailabilitySet().name(), location);
            } else {
                HashMap<String, String> tags = new HashMap<String, String>();
                if (options.getAvailabilitySet().tags() != null) {
                    tags.putAll(options.getAvailabilitySet().tags());
                }
                tags.put("jclouds", options.getAvailabilitySet().name());
                this.logger.debug(">> creating availability set [%s]", options.getAvailabilitySet().name());
                availabilitySet = this.api.getAvailabilitySetApi(resourceGroup).createOrUpdate(options.getAvailabilitySet().name(), options.getAvailabilitySet().sku(), location, tags, options.getAvailabilitySet().properties());
            }
        }
        return availabilitySet;
    }
}

