/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2ByteProgressListener;
import java.io.IOException;
import java.io.InputStream;

public class B2InputStreamWithByteProgressListener
extends InputStream {
    private static final int EOF = -1;
    private final InputStream inputStream;
    private final B2ByteProgressListener listener;
    private long nBytesSoFar;

    public B2InputStreamWithByteProgressListener(InputStream inputStream, B2ByteProgressListener listener) {
        this.inputStream = inputStream;
        this.listener = listener;
    }

    @Override
    public int read() throws IOException {
        try {
            int value = this.inputStream.read();
            if (value == -1) {
                this.notifyListenerOfRead(-1L);
            } else {
                this.notifyListenerOfRead(1L);
            }
            return value;
        }
        catch (IOException | RuntimeException e) {
            this.listener.hitException(e, this.nBytesSoFar);
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int nReadOrEof = this.inputStream.read(b, off, len);
            this.notifyListenerOfRead(nReadOrEof);
            return nReadOrEof;
        }
        catch (IOException | RuntimeException e) {
            this.listener.hitException(e, this.nBytesSoFar);
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            long nReadOrEof = this.inputStream.skip(n);
            this.notifyListenerOfRead(nReadOrEof);
            return nReadOrEof;
        }
        catch (IOException | RuntimeException e) {
            this.listener.hitException(e, this.nBytesSoFar);
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.inputStream.available();
        }
        catch (IOException | RuntimeException e) {
            this.listener.hitException(e, this.nBytesSoFar);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private void notifyListenerOfRead(long nBytesOrEof) {
        if (nBytesOrEof == -1L) {
            this.listener.reachedEof(this.nBytesSoFar);
        } else {
            this.nBytesSoFar += nBytesOrEof;
            this.listener.progress(this.nBytesSoFar);
        }
    }
}

