/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class B2ByteRange {
    private static final Pattern RANGE_PATTERN = Pattern.compile("bytes=(\\d*)-(\\d*)");
    public final Long start;
    public final Long end;

    public static B2ByteRange startAt(long start) {
        return new B2ByteRange(start, null);
    }

    public static B2ByteRange between(long start, long end) {
        return new B2ByteRange(start, end);
    }

    public static B2ByteRange parse(String s) {
        if (s == null) {
            return null;
        }
        Matcher matcher = RANGE_PATTERN.matcher(s);
        if (!matcher.matches()) {
            return null;
        }
        Long start = B2ByteRange.longOrNullFromStr(matcher.group(1));
        Long end = B2ByteRange.longOrNullFromStr(matcher.group(2));
        if (start == null && end == null) {
            return null;
        }
        if (start != null && end != null && end < start) {
            return null;
        }
        return new B2ByteRange(start, end);
    }

    public B2ByteRange(Long start, Long end) {
        this.start = start;
        this.end = end;
    }

    public boolean isSatisfied(long entitySize) {
        if (this.start == null) {
            return this.end != 0L;
        }
        return this.start < entitySize;
    }

    public B2ByteRange effectiveRange(long entitySize) {
        B2Preconditions.checkArgument(this.isSatisfied(entitySize));
        if (this.start == null) {
            return new B2ByteRange(Math.max(0L, entitySize - this.end), entitySize - 1L);
        }
        if (this.end == null) {
            return new B2ByteRange(this.start, entitySize - 1L);
        }
        return new B2ByteRange(this.start, Math.min(this.end, entitySize - 1L));
    }

    public long getNumberOfBytes() {
        B2Preconditions.checkState(this.start != null && this.end != null);
        return this.end - this.start + 1L;
    }

    public String toString() {
        return "bytes=" + B2ByteRange.strFromLongOrNull(this.start) + "-" + B2ByteRange.strFromLongOrNull(this.end);
    }

    private static Long longOrNullFromStr(String s) {
        if (s.length() == 0) {
            return null;
        }
        return Long.valueOf(s);
    }

    private static String strFromLongOrNull(Long value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2ByteRange that = (B2ByteRange)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }
}

