/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonHandlerMap;
import com.backblaze.b2.json.B2JsonObjectHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonTypeHandlerWithDefaults;
import com.backblaze.b2.json.B2JsonUnionTypeMap;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import com.backblaze.b2.util.B2Preconditions;
import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class B2JsonUnionBaseHandler<T>
extends B2JsonTypeHandlerWithDefaults<T> {
    private final Class<T> clazz;
    private final String typeNameField;
    private final String defaultValueJsonOrNull;
    private Map<String, B2JsonObjectHandler<?>> typeNameToHandler;
    private Map<Class<?>, B2JsonObjectHandler<?>> classToHandler;
    private Map<String, B2JsonTypeHandler<?>> fieldNameToHandler;

    /*
     * WARNING - void declaration
     */
    B2JsonUnionBaseHandler(Class<T> clazz) throws B2JsonException {
        void var2_3;
        this.clazz = clazz;
        Class<T> clazz2 = clazz.getSuperclass();
        while (var2_3 != null) {
            if (B2JsonUnionBaseHandler.hasB2JsonAnnotation((AnnotatedElement)var2_3)) {
                throw new B2JsonException("union class " + clazz + " inherits from another class with a B2Json annotation: " + var2_3);
            }
            Class clazz3 = var2_3.getSuperclass();
        }
        for (Field field : clazz.getFields()) {
            if (!B2JsonUnionBaseHandler.hasB2JsonAnnotation(field)) continue;
            throw new B2JsonException("class " + clazz + ": field annotations not allowed in union class");
        }
        for (Constructor<?> constructor2 : clazz.getConstructors()) {
            if (!B2JsonUnionBaseHandler.hasB2JsonAnnotation(constructor2)) continue;
            throw new B2JsonException("class " + clazz + ": constructor annotations not allowed in union class");
        }
        B2Json.union union2 = clazz.getAnnotation(B2Json.union.class);
        this.typeNameField = union2.typeField();
        B2Json.defaultForUnknownType defaultForUnknownType2 = clazz.getAnnotation(B2Json.defaultForUnknownType.class);
        this.defaultValueJsonOrNull = defaultForUnknownType2 == null ? null : defaultForUnknownType2.value();
    }

    @Override
    protected void initializeImplementation(B2JsonHandlerMap b2JsonHandlerMap) throws B2JsonException {
        Map<String, Class<?>> typeNameToClass = B2JsonUnionBaseHandler.getUnionTypeMap(this.clazz).getTypeNameToClass();
        this.typeNameToHandler = new HashMap();
        this.classToHandler = new HashMap();
        for (Map.Entry<String, Class<?>> entry : typeNameToClass.entrySet()) {
            String typeName = entry.getKey();
            Class<?> typeClass = entry.getValue();
            if (!B2JsonUnionBaseHandler.hasSuperclass(typeClass, this.clazz)) {
                throw new B2JsonException(typeClass + " is not a subclass of " + this.clazz);
            }
            B2JsonTypeHandler handler = b2JsonHandlerMap.getUninitializedHandler(typeClass);
            if (handler instanceof B2JsonObjectHandler) {
                this.typeNameToHandler.put(typeName, (B2JsonObjectHandler)handler);
                this.classToHandler.put(typeClass, (B2JsonObjectHandler)handler);
                continue;
            }
            throw new B2JsonException("BUG: handler for subclass of union is not B2JsonObjectHandler");
        }
        this.fieldNameToHandler = new HashMap();
        HashMap<String, String> fieldNameToSourceClassName = new HashMap<String, String>();
        for (Class<?> subclass : typeNameToClass.values()) {
            for (Field field : B2JsonHandlerMap.getObjectFieldsForJson(subclass)) {
                String fieldName = field.getName();
                B2JsonTypeHandler handler = b2JsonHandlerMap.getUninitializedHandler(field.getGenericType());
                if (this.fieldNameToHandler.containsKey(fieldName)) {
                    if (handler == this.fieldNameToHandler.get(fieldName)) continue;
                    throw new B2JsonException("In union type " + this.clazz + ", field " + fieldName + " has two different types.  " + (String)fieldNameToSourceClassName.get(fieldName) + " has " + this.fieldNameToHandler.get(fieldName).getHandledType() + " and " + subclass.toString() + " has " + handler.getHandledType());
                }
                this.fieldNameToHandler.put(fieldName, handler);
                fieldNameToSourceClassName.put(fieldName, subclass.toString());
            }
        }
    }

    @Override
    protected void checkDefaultValues() throws B2JsonException {
        if (this.defaultValueJsonOrNull != null) {
            try {
                this.deserialize(new B2JsonReader(new StringReader(this.defaultValueJsonOrNull)), B2JsonOptions.DEFAULT);
            }
            catch (B2JsonException | IOException e) {
                throw new B2JsonException("error in default value for union " + this.clazz.getSimpleName() + ": " + e.getMessage());
            }
        }
    }

    private static boolean hasB2JsonAnnotation(AnnotatedElement element) {
        for (Class<? extends Annotation> annotationClass : B2Json.ALL_ANNOTATIONS) {
            if (element.getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSuperclass(Class<?> classA, Class<?> classB) {
        Class<?> classASuper = classA.getSuperclass();
        if (classASuper == null) {
            return false;
        }
        return classASuper == classB || B2JsonUnionBaseHandler.hasSuperclass(classASuper, classB);
    }

    static B2JsonUnionTypeMap getUnionTypeMap(Class<?> clazz) throws B2JsonException {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("getUnionTypeMap", new Class[0]);
            method.setAccessible(true);
            Object obj = method.invoke(null, new Object[0]);
            if (!(obj instanceof B2JsonUnionTypeMap)) {
                throw new B2JsonException(clazz.getSimpleName() + "." + method.getName() + "() did not return a B2JsonUnionTypeMap.  It returned a " + obj.getClass());
            }
            return (B2JsonUnionTypeMap)obj;
        }
        catch (NoSuchMethodException e) {
            throw new B2JsonException("union base class " + clazz + " does not have a method getUnionTypeMap");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof B2JsonException) {
                throw (B2JsonException)e.getCause();
            }
            throw new B2JsonException("failed to invoke " + method + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new B2JsonException("illegal access to " + method + ": " + e.getMessage(), e);
        }
    }

    @Override
    public Type getHandledType() {
        return this.clazz;
    }

    @Override
    public void serialize(T obj, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        B2Preconditions.checkState(this.isInitialized());
        this.throwIfBadDefaultValue();
        if (obj.getClass() == this.clazz) {
            throw new B2JsonException("" + this.clazz + " is a union base class, and cannot be serialized");
        }
        B2JsonObjectHandler<?> objHandler = this.classToHandler.get(obj.getClass());
        if (objHandler == null) {
            throw new B2JsonException("" + obj.getClass() + " isn't a registered part of union " + this.clazz);
        }
        objHandler.serialize(obj, options, out);
    }

    @Override
    public T deserializeUrlParam(String urlValue) throws B2JsonException {
        throw new B2JsonException("type not supported in URL parameter");
    }

    @Override
    public T deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        B2Preconditions.checkState(this.isInitialized());
        this.throwIfBadDefaultValue();
        String unknownFieldNameOrNull = null;
        String typeName = null;
        HashMap<String, Object> fieldNameToValue = new HashMap<String, Object>();
        if (in.startObjectAndCheckForContents()) {
            do {
                String fieldName;
                if (this.typeNameField.equals(fieldName = in.readObjectFieldNameAndColon())) {
                    typeName = in.readString();
                    continue;
                }
                B2JsonTypeHandler<?> handler = this.fieldNameToHandler.get(fieldName);
                if (handler == null) {
                    unknownFieldNameOrNull = fieldName;
                    in.skipValue();
                    continue;
                }
                fieldNameToValue.put(fieldName, B2JsonUtil.deserializeMaybeNull(handler, in, options));
            } while (in.objectHasMoreFields());
        }
        in.finishObject();
        if (typeName == null) {
            throw new B2JsonException("missing '" + this.typeNameField + "' in " + this.clazz.getSimpleName());
        }
        B2JsonObjectHandler<?> handler = this.typeNameToHandler.get(typeName);
        if (handler == null) {
            if (this.defaultValueJsonOrNull == null) {
                throw new B2JsonException("unknown '" + this.typeNameField + "' in " + this.clazz.getSimpleName() + ": '" + typeName + "'");
            }
            return this.deserialize(new B2JsonReader(new StringReader(this.defaultValueJsonOrNull)), B2JsonOptions.DEFAULT);
        }
        if (unknownFieldNameOrNull != null) {
            throw new B2JsonException("unknown field '" + unknownFieldNameOrNull + "' in union type " + this.clazz.getSimpleName());
        }
        return (T)handler.deserializeFromFieldNameToValueMap(fieldNameToValue, options);
    }

    @Override
    public T defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }

    @Override
    synchronized void setDefaultValueBad(String errorMessage) {
        super.setDefaultValueBad(errorMessage);
        for (B2JsonObjectHandler<?> objectHandler : this.typeNameToHandler.values()) {
            objectHandler.setDefaultValueBad(errorMessage);
        }
    }
}

