/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.webApiHttpClient;

import com.backblaze.b2.client.B2AccountAuthorizerSimpleImpl;
import com.backblaze.b2.client.B2ClientConfig;
import com.backblaze.b2.client.B2DefaultRetryPolicy;
import com.backblaze.b2.client.B2RetryPolicy;
import com.backblaze.b2.client.B2Sdk;
import com.backblaze.b2.client.B2StorageClient;
import com.backblaze.b2.client.B2StorageClientImpl;
import com.backblaze.b2.client.B2StorageClientWebifierImpl;
import com.backblaze.b2.client.credentialsSources.B2Credentials;
import com.backblaze.b2.client.credentialsSources.B2CredentialsFromEnvironmentSource;
import com.backblaze.b2.client.webApiClients.B2WebApiClient;
import com.backblaze.b2.client.webApiHttpClient.B2WebApiHttpClientImpl;
import com.backblaze.b2.client.webApiHttpClient.HttpClientFactory;
import com.backblaze.b2.util.B2Preconditions;
import java.util.function.Supplier;

public class B2StorageHttpClientBuilder {
    private static final String DEFAULT_MASTER_URL = "https://api.backblazeb2.com/";
    private final B2ClientConfig config;
    private B2WebApiClient webApiClient;
    private HttpClientFactory httpClientFactory;
    private Supplier<B2RetryPolicy> retryPolicySupplier;

    public static B2StorageHttpClientBuilder builder(B2ClientConfig config) {
        return new B2StorageHttpClientBuilder(config);
    }

    public static B2StorageHttpClientBuilder builder(String applicationKeyId, String applicationKey, String userAgent) {
        B2AccountAuthorizerSimpleImpl accountAuthorizer = B2AccountAuthorizerSimpleImpl.builder(applicationKeyId, applicationKey).build();
        B2ClientConfig config = B2ClientConfig.builder(accountAuthorizer, userAgent).build();
        return B2StorageHttpClientBuilder.builder(config);
    }

    public static B2StorageHttpClientBuilder builder(String userAgent) {
        B2Credentials credentials = B2CredentialsFromEnvironmentSource.build().getCredentials();
        return B2StorageHttpClientBuilder.builder(credentials.getApplicationKeyId(), credentials.getApplicationKey(), userAgent);
    }

    private B2StorageHttpClientBuilder(B2ClientConfig config) {
        this.config = config;
    }

    public B2StorageClient build() {
        B2WebApiClient webApiClient = this.webApiClient != null ? this.webApiClient : B2WebApiHttpClientImpl.builder().setHttpClientFactory(this.httpClientFactory).build();
        B2StorageClientWebifierImpl webifier = new B2StorageClientWebifierImpl(webApiClient, this.config.getUserAgent() + " " + B2Sdk.getName() + "/" + B2Sdk.getVersion(), this.config.getMasterUrl() == null ? DEFAULT_MASTER_URL : this.config.getMasterUrl(), this.config.getTestModeOrNull());
        Supplier<B2RetryPolicy> retryPolicySupplier = this.retryPolicySupplier != null ? this.retryPolicySupplier : B2DefaultRetryPolicy.supplier();
        return new B2StorageClientImpl(webifier, this.config, retryPolicySupplier);
    }

    public B2StorageHttpClientBuilder setHttpClientFactory(HttpClientFactory httpClientFactory) {
        B2Preconditions.checkState(this.webApiClient == null, "httpClientFactory is only used if webApiClient isn't specified, so at most one of them can be non-null!");
        this.httpClientFactory = httpClientFactory;
        return this;
    }

    public B2StorageHttpClientBuilder setWebApiClient(B2WebApiClient webApiClient) {
        B2Preconditions.checkState(this.httpClientFactory == null, "httpClientFactory is only used if webApiClient isn't specified, so at most one of them can be non-null!");
        this.webApiClient = webApiClient;
        return this;
    }

    public B2StorageHttpClientBuilder setRetryPolicySupplier(Supplier<B2RetryPolicy> retryPolicySupplier) {
        this.retryPolicySupplier = retryPolicySupplier;
        return this;
    }
}

