<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?='Dashboard'?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='restoreByDate'?></span>
	    <span class="reportProductType d-none"><?=$data['reportProductType']?></span>
            <div class="row">
                <div class="panel col-lg-12">
                    <div class="panel-heading"><h3><?=$data['crumb1']?></div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form ng-submit="updateRestoreHistory(search.from, search.to, '', '', 0,search.searchPolicyName)" data-parsley-validate>
                                    <div class="row">
<div class="col-lg-12" style="margin-bottom: 10px;">
    <label class="radio-inline">
      <input type="radio" name="userOption" value="policy" checked>Policy Name
    </label>
    <label class="radio-inline">
      <input type="radio" name="userOption" value="userNdDevice">User ID and Device name
    </label>
</div><br/>
<div class="col-lg-4" id="userNdDevice" style="display: none;">
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsername">User ID</label>
                                            <select name="searchUsername"
                                                    style="width: 100%;"
                                                    id="searchUsername"
                                                    class="pull-right form-control searchUsername"
                                                    ng-model="search.userName"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                                <option value="all" selected>all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceName">Device Name</label>
                                            <select class="searchDeviceName form-control" id="searchDeviceName" readonly>
                                                <option value="all">all</option>
                                            </select>
					</div>
</div>
</div>
<div class="col-lg-4" id="policy">
                                            <label for="searchPolicyName">Policy Name</label>
       <select class="form-control selectPicker searchPolicyName" id="searchPolicyName" name="searchPolicyName[]" multiple title='Select Backup Policy Name' data-selected-text-format="count>4">
<option value="all" selected>all</option>
                                                <?php if(!empty($data["backupPolicies"])) {?>
                                                    <?php foreach($data['backupPolicies'] as $value){ 
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>          
                                            </select>
                                        </div>
                                        <div class="col-lg-2">
                                            <div class="form-group">
                                                <label for="from">From Date</label>
                                                <input type="text" class="form-control" id="from" placeholder="From Date" data-parsley-trigger="change" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-2">
                                            <div class="form-group">
                                                <label for="to">To Date</label>
                                                <input type="text" class="form-control" id="to" placeholder="To Date" data-parsley-trigger="change" required>
                                            </div>
                                        </div>
                                        <div class="dropdown col-lg-4" style="margin-top:25px;">
                                            <button type="submit" class="btn btn-default">View</button>
                                            <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadRestoreHistoryExcel(search.from, search.to, '', '', 0,search.searchPolicyName)" style="cursor:pointer;">Excel</a></li>
                                                <li><a ng-click="downloadRestoreHistoryPdf(search.from, search.to, '', '', 0,search.searchPolicyName)" style="cursor:pointer;">PDF</a><li>
                                              </ul>
						<a title="Schedule" class="btn btn-default" data-toggle="tooltip" data-placement="top" ng-click="schedule('sendRestoreHistoryReportTimer')"><i class="fa fa-calendar"></i> Schedule</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <div class="table-responsive">
                        <table id="RestoreHistoryByDate" class="table table-bordered restoreHistory" style="display: none;">
                            <thead>
                            <tr>
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                    <th class="text-center clickAble" ng-click="restoreHistorySortType = 'userName'; sortReverseR = !sortReverseR">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="restoreHistorySortType == 'userName' && !sortReverseR" class="fa fa-caret-up"></span>
                                        <span ng-show="restoreHistorySortType == 'userName' && sortReverseR" class="fa fa-caret-down"></span>
                                    </th>
                                <?php } ?>
                                <th class="text-center clickAble" ng-click="restoreHistorySortType = 'deviceName'; sortReverseR = !sortReverseR">
                                    <?=Language::show('Source', 'keywords')?><br>
				    <span>DeviceName [Path]</span>
                                    <span ng-show="restoreHistorySortType == 'deviceName' && !sortReverseR" class="fa fa-caret-up"></span>
                                    <span ng-show="restoreHistorySortType == 'deviceName' && sortReverseR" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="restoreHistorySortType = 'restoreByUserName'; sortReverseR = !sortReverseR">
                                    <?=Language::show('Restored By', 'keywords')?>
                                    <span ng-show="restoreHistorySortType == 'restoreByUserName' && !sortReverseR" class="fa fa-caret-up"></span>
                                    <span ng-show="restoreHistorySortType == 'restoreByUserName' && sortReverseR" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="restoreHistorySortType = 'restoreByDeviceName'; sortReverseR = !sortReverseR">
                                    <?=Language::show('Destination', 'keywords')?><br>
				    <span>DeviceName [Path]</span>
                                    <span ng-show="restoreHistorySortType == 'restoreByDeviceName' && !sortReverseR" class="fa fa-caret-up"></span>
                                    <span ng-show="restoreHistorySortType == 'restoreByDeviceName' && sortReverseR" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble d-none" ng-click="restoreHistorySortType = 'restoreFolder'; sortReverseR = !sortReverseR">
                                     <?=Language::show('Path', 'keywords')?>
                                     <span ng-show="restoreHistorySortType == 'restoreFolder' && !sortReverseR" class="fa fa-caret-up"></span>
                                     <span ng-show="restoreHistorySortType == 'restoreFolder' && sortReverseR" class="fa fa-caret-down"></span>
                                 </th>
                                <th class="text-center clickAble" ng-click="restoreHistorySortType = 'restoreTimeInMillis'; sortReverseR = !sortReverseR">
                                    <?=Language::show('restoredTime', 'keywords')?>
                                    <span ng-show="restoreHistorySortType == 'restoreTimeInMillis' && !sortReverseR" class="fa fa-caret-up"></span>
                                    <span ng-show="restoreHistorySortType == 'restoreTimeInMillis' && sortReverseR" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="restoreHistorySortType = 'restoreEndTimeInMillis'; sortReverseR = !sortReverseR">
                                     <?=Language::show('restoredEndTime', 'keywords')?>
                                     <span ng-show="restoreHistorySortType == 'restoreEndTimeInMillis' && !sortReverseR" class="fa fa-caret-up"></span>
                                     <span ng-show="restoreHistorySortType == 'restoreEndTimeInMillis' && sortReverseR" class="fa fa-caret-down"></span>
                                 </th>
                                <th class="text-center clickAble" ng-click="restoreHistorySortType = 'restoredFiles'; sortReverseR = !sortReverseR">
                                    <?=Language::show('filesRestored', 'keywords')?>
                                    <span ng-show="restoreHistorySortType == 'restoredFiles' && !sortReverseR" class="fa fa-caret-up"></span>
                                    <span ng-show="restoreHistorySortType == 'restoredFiles' && sortReverseR" class="fa fa-caret-down"></span>
                                </th>
				<?php if($data['reportProductType'] != 'office'){?>
                                <th class="text-center clickAble" ng-click="restoreHistorySortType = 'restoredSizeInKB'; sortReverseR = !sortReverseR">
                                    <?=Language::show('restoredSize', 'keywords')?>
                                    <span ng-show="restoreHistorySortType == 'restoredSizeInKB' && !sortReverseR" class="fa fa-caret-up"></span>
                                    <span ng-show="restoreHistorySortType == 'restoredSizeInKB' && sortReverseR" class="fa fa-caret-down"></span>
                                </th>
				<?php } ?>
				<th class="text-center clickAble" ng-click="restoreHistorySortType = 'status'; sortReverseR = !sortReverseR">
                                    <?=Language::show('Status', 'keywords')?>
                                    <span ng-show="restoreHistorySortType == 'status' && !sortReverseR" class="fa fa-caret-up"></span>
                                    <span ng-show="restoreHistorySortType == 'status' && sortReverseR" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in restoreByDate | orderBy:restoreHistorySortType:sortReverseR" class="text-center">
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                    <td class="text-center" ng-show="value.userName != null" ng-cloak>{{ value.userName }}</td>
                                    <td class="text-center" ng-show="value.userName == null" ng-cloak> - </td>
                                <?php } ?>
                                <td class="text-center" ng-show="value.deviceName != null" ng-cloak>{{ value.deviceName }}<span ng-if="value.restoreFolder != ''"> [{{value.restoreFolder}}]</span></td>
                                <td class="text-center" ng-show="value.deviceName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.restoreByUserName != null" ng-cloak>{{ value.restoreByUserName }}</td>
                                <td class="text-center" ng-show="value.restoreByUserName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.restoreByDeviceName != null" ng-cloak>{{ value.restoreByDeviceName }}<span ng-if="value.destFolder != ''"> [{{value.destFolder}}]<span></td>
                                <td class="text-center" ng-show="value.restoreByDeviceName == null" ng-cloak> - </td>
<!--                                <td class="text-left" style="word-break: break-all;" ng-show="value.restoreFolder != null" ng-cloak>
                                    <li ng-repeat="parts in value.restoreFolder" ng-cloak>{{ parts }}</li>
                                </td>
                                <td class="text-center" style="word-break: break-all;" ng-show="value.restoreFolder == null" ng-cloak> - </td>-->
				<td class="text-center d-none" style="word-break: break-all;" ng-show="value.restoreFolder != null" ng-cloak>{{ value.restoreFolder }}</td>
                                <td class="text-center d-none" style="word-break: break-all;" ng-show="value.restoreFolder == null" ng-cloak> - </td>
                                <td class="text-center" ng-cloak>{{ value.restoreTime }}</td>
                                <td class="text-center" ng-cloak>{{ value.restoreEndTime }}</td>
                                <td class="text-center" ng-cloak>{{ value.restoredFiles }}</td>
				<?php if($data['reportProductType'] != 'office'){?>
                                	<td class="text-center" ng-show="value.restoredSize != null" ng-cloak>{{ value.restoredSize }}</td>
                                	<td class="text-center" ng-show="value.restoredSize == null" ng-cloak> - </td>
				<?php } ?>
				<td class="text-center" ng-show="value.status != null" ng-cloak>{{ value.status }}</td>
                                <td class="text-center" ng-show="value.status == null" ng-cloak> - </td>
                            </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="h4 restoreError text-center" style="display: none">No details found between the date Range</div>
                    </div>
                    <div class="row restoreHistory" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="updateRestoreHistoryNavigate(search.from, search.to, '', '',search.searchPolicyName,first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a></a>
                            <a class="btn btn-primary previous" ng-click="updateRestoreHistoryNavigate(search.from, search.to, '', '',search.searchPolicyName,previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="updateRestoreHistoryNavigate(search.from, search.to, '', '',search.searchPolicyName,next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="updateRestoreHistoryNavigate(search.from, search.to, '', '',search.searchPolicyName,last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>
                    <!--<div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'restoreHistory')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>-->
                </div>
            </div>
        </div>
    </div>
<!--modal start-->
<div class="modal fade" id="scheduleModalList" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <div class="modal-header">
                    <h4 class="modal-title"><?=Language::show('List of Schedules', 'keywords')?></h4>
                </div>
                <div class="modal-body">
                    <div class="row schedulesNotFound" style="display: none;">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h2 align="center"><?=Language::show('No Schedules found !!!!!!', 'keywords');?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row schedulesFound" style="display: none;">
                        <div class="table-responsive col-lg-12 schedulesTable">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Schedule Name</th>
                                        <th>Schedule Time</th>
                                        <th>Recipient email IDs</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in schedules">
                                        <td>{{value.scheduleName | limitTo:20}}{{value.scheduleName.length > 20 ? '...' : ''}}</td>
                                        <td>{{value.time}}</td>
                                        <td ng-if="value.allAdmins == 'false'" class="text-left" title="{{ value.emailIds }}" ng-cloak>{{ value.emailIds | limitTo:50}}{{value.emailIds.length > 50 ? '...' : ''}}</td>
                                        <td ng-if="value.allAdmins == 'true'" class="text-left" title="All admins" ng-cloak>All admins</td>
                                        <td>
                                            <a class="btn btn-small btn-success" ng-click="getSchedule(value.id)">Edit</a>
                                            <a class="btn btn-small btn-danger" ng-click="deleteScheduleConfirm(value.id, value.scheduleName)">Delete</a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" style="z-index: 10000000000;">
			<a href="" class="btn btn-success" ng-click="createSchedule()">Create New Schedule</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<!--modal ends -->
<!--modal start-->
    <div class="modal fade" id="createScheduleModal" role="dialog" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?= Form::open(array(
                            'ng-submit' => 'saveSchedule(search.userName,search.searchPolicyName)',
                            'class' => 'saveSchedule',
                            'csrf' => $data['csrf_token'],
                            'data-parsley-validate' => true,
                            'autocomplete' => 'off'
                            )); ?>
                            <div class="modal-header">
                                <h4 class="modal-title"><?=Language::show('Schedule Settings', 'keywords')?></h4>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                            <p>
                                                Any saved schedules will need at least 5 minutes to take effect
                                            </p>
                                        </div>
                                    </div>
                                </div>
<!--start-->
<div class="col-lg-12 row" style="margin-bottom:10px;">
<div class="col-lg-12 row displayinfo" style="display:none;" ng-show="displayinfo == 'yes'">
<div class="form-group col-lg-6" style="border: 1px solid grey;border-radius:5px;">
<span>User Name : </span><span id="displayusername"></span><br>
<span>Device Name : </span><span id="displaydevicename"></span>
</div>
</div>
<div class="col-lg-12" style="margin-bottom:10px;">
<div class="optionss">
    <label class="radio-inline col-lg-6">
      <input type="radio" name="userOption1" value="policy" checked>Policy Name
	    </label>
    <label class="radio-inline col-lg-6">
      <input type="radio" name="userOption1" value="userNdDevice">User ID and Device name
    </label>
</div>
<br>

				    <div class="col-lg-12" id="userNdDevice1" style="display: none;">
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsername1">User ID</label>
                                            <select name="searchUsername1"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsername1"
                                                    id="searchUsername1"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                                <option value="all">all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceName1" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceName1 form-control" id="searchDeviceName1" readonly>
                                                <!--<option value="all">all</option>-->
                                            </select>
					</div>
</div>
                                    </div>

                                        <div class="col-lg-12" id="policy1">
<label for='searchPolicyName'>Policy Name</label>
                                        <select class="form-control selectPicker" name="searchPolicyName[]" id="searchPolicyName1" title='Select Backup Policy Name' multiple data-selected-text-format="count>4">
                                            <option value="all">all</option>
						<?php if(!empty($data['backupPolicies'])){ ?>
                                                                <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                    <option value="<?=$value?>"><?=$label?></option>
                                                                <?php } ?>
                                                            <?php } ?>
                                                        </select>
                                        </div>
                                        </div><br>
                                        <div class="col-lg-12 row" style="margin-left:0;">
<div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="from">From Date</label>
                                                <input type="text" class="form-control" id="from1" placeholder="From Date" data-parsley-trigger="change" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="to">To Date</label>
                                                <input type="text" class="form-control" id="to1" placeholder="To Date" data-parsley-trigger="change" required>
                                            </div>
                                        </div>
                                         </div>
</div>
<!--end-->
                                <div class="row">
				    <div class="form-group col-lg-12 d-none">
                                        <label for="createdBy"><?=Language::show('createdBy', 'keywords')?></label>
                                            <input type="text" class="form-control" name="createdBy" id="createdBy" placeholder="" autocomplete="off">
				    </div>
                                    <div class="form-group col-lg-12">
					    <label for="scheduleName"><?=Language::show('scheduleName', 'keywords')?></label>
                                        <input type="text" class="form-control" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@', '_' and '.' Any other special characters are not allowed.">
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="scheduleType">Schedule Type :</label>
                                        <select class="form-control" name="scheduleType" id="scheduleType">
                                            <option value="choiceDays"><?=Language::show('Days', 'settings')?></option>
                                            <option value="choiceMonths"><?=Language::show('Months', 'settings')?></option>
                                            <option value="choiceTime"><?=Language::show('Run Once', 'settings')?></option>
                                        </select>
                                    </div>
                                    <br>
                                    <div class="form-group col-lg-12 choiceDays">
                                        <label  class="col-lg-12"><?=Language::show('days', 'keywords');?> -
                                        <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Every Day</a>
                                        <select class="form-control selectPickerSchedule" name="days[]" id="days" required="" multiple title='Select days'>
                                            <option value="SUN"><?=Language::show('sunday', 'keywords')?></option>
                                            <option value="MON"><?=Language::show('monday', 'keywords')?></option>
                                            <option value="TUE"><?=Language::show('tuesday', 'keywords')?></option>
                                            <option value="WED"><?=Language::show('wednesday', 'keywords')?></option>
                                            <option value="THU"><?=Language::show('thursday', 'keywords')?></option>
                                            <option value="FRI"><?=Language::show('friday', 'keywords')?></option>
                                            <option value="SAT"><?=Language::show('saturday', 'keywords')?></option>
                                        </select>
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-12 choiceMonths" style="display:none;">
                                        <label class="col-lg-12"><?=Language::show('Month', 'keywords');?> -
                                        <a href="javascript:;" class="monthDaily" ng-click="toggleSelectPickerAllMonths()">Every Month</a>
                                        <div class="col-lg-12">
                                            <div class="col-lg-6 form-group">
                                                <input type="number" min='1' max="31" class="form-control" name="dayOfMonth" id="dayOfMonth" placeholder="Enter Day of Month" disabled="disabled">
						    </div>
                                            <div class="col-lg-6 form-group">
                                                <select class="form-control selectPickerScheduleMonth" name="months[]" id="months" multiple title='Select months'>
                                                    <option value="JAN"><?=Language::show('January', 'keywords')?></option>
                                                    <option value="FEB"><?=Language::show('February', 'keywords')?></option>
                                                    <option value="MAR"><?=Language::show('March', 'keywords')?></option>
                                                    <option value="APR"><?=Language::show('April', 'keywords')?></option>
                                                    <option value="MAY"><?=Language::show('May', 'keywords')?></option>
                                                    <option value="JUN"><?=Language::show('June', 'keywords')?></option>
                                                    <option value="JUL"><?=Language::show('July', 'keywords')?></option>
                                                    <option value="AUG"><?=Language::show('August', 'keywords')?></option>
                                                    <option value="SEP"><?=Language::show('September', 'keywords')?></option>
                                                    <option value="OCT"><?=Language::show('October', 'keywords')?></option>
                                                    <option value="NOV"><?=Language::show('November', 'keywords')?></option>
                                                    <option value="DEC"><?=Language::show('December', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-12 choiceTime" style="display:none;">
                                        <label class="col-lg-8"><?=Language::show('Run once', 'keywords');?>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="The schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <input type="text" class="form-control col-lg-4" name="date" id="date" placeholder="Enter Date" disabled="disabled">
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="scheduleStartTime"><?=Language::show('Schedule Time', 'keywords')?></label>
                                        <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime" required>
                                    </div>
                                    <span class="d-none ownerFor" id="ownerFor"></span>
					</div>
                                <div class="row usersFound" id="usersFound" style="display: none;">
                                    <div class="table-responsive col-lg-4 usersTable">
                                        <table class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" class="select-all checkbox d-none" name="select-all"/>
                                                </th>
                                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                                    <?=Language::show('Administrators', 'keywords')?>
                                                    <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                                    <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody>
						<tr>
                                                    <td class="text-center">
                                                        <input type="checkbox" class="select-item checkbox" name="allAdmins" id="allAdmins" value="All admins" ng-checked="value.allAdmins == 'true'"/>
                                                    </td>
                                                    <td class="text-left" title="All admins" ng-cloak>All admins</td>
                                                </tr>
                                                <tr ng-repeat="value in users">
                                                    <td class="text-center">
                                                    	<input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value.emailId }}" ng-click="itemSelect(value.emailId)" ng-checked="value.isCheck == 'yes'"/>
                                                    </td>
                                                    <td class="text-left emailId-item" title="{{ value.emailId }}" ng-cloak>{{ value.emailId | limitTo:20}}{{value.emailId.length > 20 ? '...' : ''}}</td>
                                                </tr>
                                            </tbody>
                                        </table>
					    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group row">
                                            <label for="selectedUsers"><?=Language::show('Email reports to', 'keywords');?></label><br/>
                                            <input type="text" data-role="tagsinput" value="" class="form-control selectedUsers" name="selectedUsers[]" id="selectedUsers" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Selected Users', 'keywords');?>" required autocomplete="off">
                                        </div>
        
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success createScheduleBtn"><?=Language::show('Save', 'keywords')?></button>
                                <button type="button" id="closeScheduleModal" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>
                            </div>
                <?= Form::close(); ?>
                 </div>
        </div>
    </div>
<!--modal ends -->
<!--confirm modal start-->
<div class="modal fade confirmChange" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirm Change</h4>
                        </div>
                        <div class="modal-body">
				<h4 class="modal-title">The username and device name you’ve picked will over-write the username and device name previously selected for this schedule.  Are you sure you wish to proceed?</h4>

                        </div>
                        <div class="modal-footer">
				<button type="button" class="btn btn-default" ng-click="confirmChange()">Ok</button>
				<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--confirm modal ends-->
<!--confirm modal start-->
<div class="modal fade confirmdelete" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirm Delete</h4>
                        </div>
                        <div class="modal-body">
                                <h4 class="modal-title">Are you sure you want to delete the selected schedule?</h4>

                        </div>
                        <div class="modal-footer">
                                <button type="button" class="btn btn-default" ng-click="deleteSchedule()">Ok</button>
                                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--confirm modal ends-->	
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#from').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-1y',
        todayHighlight: true
    });
$('#to').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true
    });

$("#to").datepicker().datepicker("setDate", new Date());
$("#to").datepicker().datepicker('setEndDate', new Date());
var currentDate = new Date();
currentDate.setDate(currentDate.getDate() - 31);
$('#from').datepicker('update', currentDate);
$("#from").datepicker().datepicker('setEndDate', new Date());

$('#from1').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-1y',
        todayHighlight: true
    });
$('#to1').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true
    });
$("#to1").datepicker().datepicker("setDate", new Date());
$("#to1").datepicker().datepicker('setEndDate', new Date());
var currentDate = new Date();
currentDate.setDate(currentDate.getDate() - 31);
$('#from1').datepicker('update', currentDate);
$("#from1").datepicker().datepicker('setEndDate', new Date());
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchUsername').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDevice",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select user'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
	document.getElementById("displayusername").innerHTML = $('#searchUsername1').val();
        if(users.devices != undefined) {
            if (users.devices.length > 0){
                $('.searchDeviceName').removeAttr("readonly", "readonly");
                var options = "";
                users.devices.forEach(function (device) {
                    options += '<option value="' + device + '">' + device + '</option>'
                });
                $('.searchDeviceName').html(options);
                $('.searchDeviceName').prepend('<option value="all" selected>all</option>');
            }else {
                $('.searchDeviceName').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }else{
            if(users.text == "all"){
                $('.searchDeviceName').html("<option selected>all</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }
        return users.text;
    }
	
    $('.searchUsername1').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDevice",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                    $('#searchUsername1').empty().trigger("change");
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('#createScheduleModal'),
        templateResult: selectTemplateResult1,
        templateSelection: selectTemplateSelection1,
        placeholder: 'Select user'
        });

    function selectTemplateResult1(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection1(users){
	$("#searchDeviceName1").empty();
        if(users.devices != undefined) {
                if (users.devices.length > 0){
                $('#searchDeviceName1').removeAttr("readonly", "readonly");
                var options = "";
                users.devices.forEach(function (device) {
                    options += '<option value="' + device + '">' + device + '</option>'
                });
                $('#searchDeviceName1').html(options);
                $('#searchDeviceName1').prepend('<option value="all" selected>all</option>');
            }else {
                $('#searchDeviceName1').html("<option value='all' selected>User has no devices configured</option>");
                $('#searchDeviceName1').attr("readonly", "readonly");
            }
        }else{
                if(users.text == "all"){
                $('#searchDeviceName1').html("<option selected>all</option>");
                $('#searchDeviceName1').attr("readonly", "readonly");
            }
        }
        return users.text;
    }
</script>
<script>
    $('.select2-container').css({'margin-top': '-5px'});
    
    $("input:radio").change(function () {
        var val = $('input[name=userOption]:checked').val();
        var policyBlock = document.getElementById("policy");
        var userNdDeviceBlock = document.getElementById("userNdDevice");
        if (val == 'policy') {
        policyBlock.style.display = "block";
        userNdDeviceBlock.style.display = "none";

} else {
        $('#searchPolicyName').selectpicker('render');
        $('#searchPolicyName option:selected').removeAttr('selected');
        $('#searchPolicyName').find('option[value="all"]').attr("selected",true);
        policyBlock.style.display = "none";
        userNdDeviceBlock.style.display = "block";
    }
        });
</script>
<script>
$('.timePicker').timepicker({
        showMeridian: false,
//        defaultTime: '9:45'
    });
    $('.selectPickerSchedule').selectpicker('render');
    $('.selectPickerScheduleMonth').selectpicker('render');
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});

var currentDate = new Date();
    //$('#date').datepicker('update', currentDate);
    
$('#scheduleType').on('change', function(){
    var choice = $('#scheduleType').val();
    if(choice == 'choiceDays'){
        $('.choiceDays').show();
        $('.choiceMonths').hide();
        $('.choiceTime').hide();
        $('#days').attr('required', 'required');
        $('#date').datepicker('update', '');
        $('#date').attr('disabled', true);
        $('#days').prop('disabled', false);
        $('.selectPickerScheduleMonth').selectpicker('val', '');
        $('#months').removeAttr('required');
        document.getElementById("months").disabled=true;
        $('#dayOfMonth').attr('disabled', true);
        $('#dayOfMonth').removeAttr('required');
    } else if(choice == 'choiceTime') {
        $('.choiceTime').show();
        $('.choiceDays').hide();
        $('.choiceMonths').hide();
        $('.selectPickerSchedule').selectpicker('val', '');
        $('.selectPickerScheduleMonth').selectpicker('val', '');
        $('#date').removeAttr('disabled');
        $('#days').removeAttr('required');
        $('#date').datepicker('update', currentDate);
        $('#days').prop('disabled', 'disabled');
        $('#months').removeAttr('required');
        document.getElementById("months").disabled=true;
        $('#dayOfMonth').attr('disabled', true);
        $('#dayOfMonth').removeAttr('required');
    }else {
        $('.choiceMonths').show();
        $('.choiceDays').hide();
        $('.choiceTime').hide();
        $('.selectPickerSchedule').selectpicker('val', '');
        $('#date').datepicker('update', '');
        $('#date').attr('disabled', true);
        $('#days').removeAttr('required');
        $('#days').prop('disabled', 'disabled');
        document.getElementById("months").disabled=false;
        $('#months').attr('required','required');
        $('#dayOfMonth').removeAttr('disabled');
        $('#dayOfMonth').attr('required','required');
    }
});
$('#date').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-0m',
        //endDate: '-0d',
        todayHighlight: true
    });
    $(function(){

        //button select all or cancel
        $("#select-all").click(function () {
            var all = $("input.select-all")[0];
            all.checked = !all.checked;
            var checked = all.checked;
            $("input.select-item").each(function (index,item) {
                item.checked = checked;
            });
        });

        //button select invert
        $("#select-invert").click(function () {
            $("input.select-item").each(function (index,item) {
                item.checked = !item.checked;
            });
            checkSelected();
        });

        //button get selected info
        $("#selected").click(function () {
            var items=[];
            $("input.select-item:checked:checked").each(function (index,item) {
                items[index] = item.value;
            });
            if (items.length < 1) {
                //document.getElementById("selected_users").innerHTML = "";
            }else {
                var values = items.join();
                console.log("items"+items);
                console.log(values);
                //var html = $("<div></div>");
                //document.getElementById("selected_users").innerHTML = arr;
                //html.html("selected:"+values);
                //html.appendTo("body");
            }
        });

        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            console.log("chhhhh");
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            console.log("all clicked");
            var usersSelected;
            var arr = $('input.select-item:checkbox:checked').map(function () {
                return this.value;
            }).get();
            usersSelected = arr;
                    $('.selectedUsers').tagsinput('removeAll');
            $('.selectedUsers').tagsinput('add', usersSelected.join());
        });
        //check selected items
        $("input.select-item").click(function () {
            var checked = this.checked;
            console.log(checked);
            checkSelected();
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            console.log("total:"+total);
            console.log("len:"+len);
            all.checked = len===total;
        }


    });
    
    $("#closeScheduleModal").click(function() {
        $('#createScheduleModal').modal('hide');
    });
		
	$("input:radio[name='userOption1']").change(function () {
            var val = $('input[name=userOption1]:checked').val();
            console.log("val : "+val);
        var policyBlock = document.getElementById("policy1");
        var userNdDeviceBlock = document.getElementById("userNdDevice1");
        if (val == 'policy') {
            policyBlock.style.display = "block";
            userNdDeviceBlock.style.display = "none";
            $('.displayinfo').hide();
        } else {
            $('#searchPolicyName').selectpicker('render');
            $('#searchPolicyName option:selected').removeAttr('selected');
            $('#searchPolicyName').find('option[value="all"]').attr("selected",true);
            policyBlock.style.display = "none";
            userNdDeviceBlock.style.display = "block";
            $('.displayinfo').show();
        }
    });

    $("#searchDeviceName1").change(function () {
            console.log("inside change"+$('#searchDeviceName1').val());
            if($('#displaydevicename').html() != '' && $('#displaydevicename').html() != $('#searchDeviceName1').val()){
                    console.log("got different name");
                    $('.confirmChange').modal('show');
            }else{
            document.getElementById("displayusername").innerHTML = $('#searchUsername1').val();
	    document.getElementById("displaydevicename").innerHTML = $('#searchDeviceName1').val();
            }
/*          var user = $('#searchUsername1').val();
            var device = $('#searchDeviceName1').val();
            document.getElementById("displayusername").innerHTML = user;
            document.getElementById("displaydevicename").innerHTML = device;*/

    });
	
    (function(){
        $("#closeScheduleModal").on("hidden.bs.modal", function(){
            $(this).removeData();
        });
    });

    </script>
<style>
.modal {
  overflow-y:auto;
}
</style>
