<?php

use Core\Language;
use \Core\View;
use \Helpers\Url;
use Helpers\Auth;
use Helpers\Form;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-12"> 
<!--            <ol class="breadcrumb">
                <li><h3><?=Language::show('backup_dashboard', 'keywords')?></h3></li>
            </ol>-->
<h3>
    <!--<?=Language::show('backup_dashboard', 'keywords')?>-->
    <span style="float:right;font-size: 12px;"><?php if ($data['time']) {?>Last Login Time : <?php echo $data['time']; } ?></span>
</h3>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='dashboard'?></span>
            <?php //if($data['isAdmin'] == 'true') { ?>
            <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
                <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                    <li role="presentation" class="nav-item"><a class="nav-link <?php echo $data['activeTabB'];?>" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">BluVault</a></li>
                <?php } ?>
                <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                    <li role="presentation" class="nav-item"><a class="nav-link <?php echo $data['activeTabS'];?>" data-target="#sync" aria-controls="sync" role="tab" data-toggle="tab"><?php if(BLUDRIVE_MODE == true){?> BluDrive<?php } else { ?>BluSync <?php } ?></a></li>
                <?php } ?>
                <?php if(Auth::checkCloudPermission('office365') == true){ ?>
                    <li role="presentation" class="nav-item"><a class="nav-link <?php echo $data['activeTabO'];?>" data-target="#odb" aria-controls="odb" role="tab" data-toggle="tab">Office 365 Backup</a></li>
                <?php } ?>
                </ul>
            <?php //} ?>
</br>
<div class="tab-content">
<div role="tabpanel" class="tab-pane <?php echo $data['activeTabB'];?>" id="general">
    <?php if(Auth::checkCloudPermission('backup') == true){ ?>
            <?php if($data['isAdmin'] == 'true') { ?>
            <div class="bluvaultSection">
            <div class="row dashboard">   
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('users')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-success">
                            <div class="background">
                                <i class="fa fa-users"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Active Users</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                 <i class="fa fa-users"></i>
                                <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statistics.activeBackupUsers }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;">{{ statistics.noOfBackupUsersAllowed }}</span></a>
                            </div>
                        </div>
                    </div>    
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('devices')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-purple">
                            <div class="background">
                                <i class="fa fa-desktop"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Active Devices</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-desktop"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.devicesConnected }}</span></a>
                            </div>
                        </div>
                    </div>
		    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('restoreByDate')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-history"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <p style="color: #fff;">Completed restores<span class="pull-right" ng-cloak>{{ statistics.restoresDone }}</span></p>
                                <p style="color: #fff;">Avg. restores per user<span class="pull-right" ng-cloak>{{ statistics.avgRestorePerUser }}</span></p>
                            </div>
                            <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                <i style="font-size: 32px;" class="fa fa-history"></i>
                            </div>
                        </div>
                    </div>
                    <?php if(flipTotalCompletedBackups == false){ ?>
                    <?php if(totalCompletedBackups == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-database"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Completed Backups</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-database"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.backupsDone }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-success">
                            <div class="background">
                                <i class="fa fa-refresh"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Full Backups Completed</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-refresh"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.fullBackupsDone }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirect('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(totalCompletedBackups == true){?> front <?php }else{ ?> back <?php } ?>" onclick="flip()" >
                                <div class="panel panel-default no-box-shadow widget-primary fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Total Completed Backups</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                            <i class="fa fa-database"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.backupsDone }}</span></a>
                                    </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if(totalCompletedBackups == true){?> back <?php }else{ ?> front <?php } ?>" onclick="flipback()" >
                                <div class="panel panel-default no-box-shadow widget-success fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Full Backups Completed</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-database"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.fullBackupsDone }}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>                    
            </div>
            <div class="row">
                <?php if(flipTotalActualStorageUtilized == false){ ?>
                    <?php if(totalActualStorageUtilized == false){ ?>
                        <?php if($data['hideCompressedSize'] == true){ ?>
                            <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
                        <?php } else { ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                                <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statistics.totalStorageUtilized }}</span></p>
                                                <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statistics.totalCompressedSizeInPercentage }}</span></p>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                                <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                </div>
                                </div>
                        </div>
                        <?php } ?>
                    <?php }else{ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php }else{ ?>
                <?php if($data['hideCompressedSize'] == false){?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> frontDB <?php }else{ ?> backDB <?php } ?>" onclick="flip1()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                        <i class="fa fa-hdd-o"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> backDB <?php }else{ ?> frontDB <?php } ?>" onclick="flipback1()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                        <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statistics.totalStorageUtilized }}</span></p>
                                        <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statistics.totalCompressedSizeInPercentage }}</span></p>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                        <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } else { ?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> frontDB <?php }else{ ?> backDB <?php } ?>" onclick="flip1()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                        <i class="fa fa-hdd-o"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> backDB <?php }else{ ?> frontDB <?php } ?>" onclick="flipback1()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Data Backed up</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="totalStorageUtilized" ng-cloak>{{ statistics.totalStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } } ?>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-warning">
                        <div class="background">
                            <i class="fa fa-cog"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Currently Running Backups</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-cog"></i>
                            <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statistics.currentlyRunningBackupCount }}</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('usersWithoutDevices')" style="cursor:pointer;" <?php } ?>>
                    <div class="panel panel-default no-box-shadow widget-success">
                        <div class="background">
                            <i class="fa fa-inbox"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Users without active devices</a>
                             </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-inbox"></i>
                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="storage" ng-cloak>{{ statistics.userWithOutDevices }}</a>
                        </div>
                    </div>
                </div>
                <!-- new start-->
<?php if($data['flipNotProtectedTile'] == false){ ?>
                    <?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('systemsNotProtected')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-warning">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Systems not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfDevicesNotProtected }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirect('usersNotProtected')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-purple">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Users with systems not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfUsersProtected }}</span></a>
                                </div>
                            </div>
                    </div>
                    <?php } ?>
                <?php }else{ ?>
		    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){?> frontNP <?php }else{ ?> backNP <?php } ?>" onclick="flipNP()" ondblclick="redirect('systemsNotProtected')" >
                                <div class="panel panel-default no-box-shadow widget-warning fold">
                                        <div class="background">
                                                <i class="fa fa-exclamation-triangle"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                                <a>Systems not protected</a>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                                <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfDevicesNotProtected }}</span></a>
                                        </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if($data['tile8ReportType'] == 'usersWithSystemsNotProtected'){?> frontNP <?php }else{ ?> backNP <?php } ?>" onclick="flipbackNP()" ondblclick="redirect('usersNotProtected')" >
                                <div class="panel panel-default no-box-shadow widget-purple fold">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Users with systems not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.noOfUsersProtected }}</span></a>
                                </div>
                            </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
<!-- new end-->
            </div>
            </div>
<?php } ?>
<!--modal start-->
<div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> currentlyRunningbackups">
                <div class="modal-dialog">
                    <div class="modal-content">
			<span><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></span>
                        <div class="modal-header" style="margin-bottom: -10px;">                            
                            <div class="panel-heading col-lg-12">
                                <h4 class="currentBackup" style="display:none;">Currently Running Backups
                                    <div class="col-lg-5 pull-right">
                                    <center>
                                        <form ng-submit="searchCurrentlyRunningBackups(search.term)">
                                        <span id="search_img" class="fa fa-search fa-x" style="color: #b2b2b2;"></span>
                                                                        <input name="searchOutlook"
                                                                               type="text"
                                                                               class="pull-right form-control"
                                                                               ng-model="search.term"
                                                                               placeholder="Enter username or devicename or 'all' and hit enter to search"
                                                                                style="padding: 6px 24px !important;"
                                                                        />
                                        </form>
                                    </center>
                                    </div>
                                </h4>
                            </div>
                        </div>
                        <div class="modal-body col-lg-12">
                            <div class="table-responsive currentBackupTableExpanded">
                            </hr>
                            <table id="CurrentBackuptable" class="table table-bordered currentBackuptable" style="display: none;">
                                <thead>
                                <tr>
                                <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                <th class="active">
                                        <input type="checkbox" class="select-all checkbox" name="select-all"/>
                                </th>
                                <?php } ?>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('deviceName', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                    <th class="text-center clickAble" ng-click="currentBackupSortType = 'backupType'; sortReverse = !sortReverse">
				    	<?=Language::show('Backup Type', 'keywords')?>
					<span ng-show="currentBackupSortType == 'backupType' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'backupType' && sortReverse" class="fa fa-caret-down"></span>
					&nbsp;
                                        <select class="form-control backupType" style="width: 30% !important;display:inherit !important;">
                                            <option value="INCR">INCR</option>
                                            <option value="FULL">Full</option>
                                            <option value="" selected>All</option>
                                        </select>
                                    </th>
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <th class="text-center actionn"><?=Language::show('action', 'keywords')?></th>
                                    <?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackupE | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
                                        <input type="checkbox" class="select-item checkbox" name="select-item" onclick="newone()" value="{{ value.deviceUUID }}"/>
                                    </td>
                                    <?php } ?>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-cloak>{{ value.startTime }}</td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-show="value.backupType == 'INCR'" ng-cloak>Incremental</td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-show="value.backupType == 'FULL'" ng-cloak>Full</td>
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td class="actionn" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
                                        <a ng-if="value.status !='SCANNING'" ng-click="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip ripple" id="pause_{{$index}}" 
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                    <?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
                            <div class="row currentBackupnavigate hide" style="display: none;">
                            <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="expandViewNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="expandViewNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="expandViewNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="expandViewNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                            </div>
                            </div>
                            <div class="h4 currentBackupError text-center" style="display: none">No details found for Current Backup</div>
                            <div class="row loadMore" style="display: none;">
                                <div class="col-lg-12 text-center">
                                    <a class="loadMoreBtn btn btn-primary" ng-click="expandView(skipValue)">Load More ...</a>
                                        <br /><br />
                                </div>
                            </div>
                            
                            <?php if($data['stopPauseAccess'] == 'true'){ ?>
                            <a ng-click="saveBulkEventHubCurrentBackup('stop')" data-toggle="tooltip" data-placement="top" title="Stop Backup" id="bulkstopbackup" class="block btn btn-small btn-danger toolTip disabled">
                                <span class="fa-stack">
                                    <i class="fa fa-circle fa-stack-2x"></i>
                                    <i class="fa fa-stop fa-stack-1x" style="color:black!important;"></i>
                                </span>
                            </a>
                            <a ng-click="saveBulkEventHubCurrentBackup('pause')" data-toggle="tooltip" data-placement="top" title="Pause Backup" id="bulkpausebackup" class="block btn btn-small btn-danger toolTip disabled" style="margin-right:5px;">
                                <span class="fa-stack">
                                    <i class="fa fa-circle fa-stack-2x"></i>
                                    <i class="fa fa-pause fa-stack-1x" style="color:black!important;"></i>
                                </span>
                            </a>
                            <?php } ?>
		                </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--modal ends-->
<!--currently running restores modal start-->
<div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> currentlyRunningrestores">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
<div class="panel-heading">
                            <h4 class="currentRestore" style="display:none;">
                                Currently Running Restores
                            </h4>
</div>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive">
                            </hr>
                        <table id="CurrentRestore" class="table table-bordered currentRestoretable" style="display: none;">
                                <thead>
                                <tr>
				<th class="active">
                                        <input type="checkbox" class="select-all-restore checkbox" name="select-all-restore"/>
				</th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                            <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>DeviceName [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>DeviceName [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>
                                 <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                 <th class="text-center actionRestore"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestoreE | orderBy:currentBackupSortType:sortReverse" class="text-center">
					<td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
        					<input type="checkbox" class="select-item-restore checkbox" name="select-item-restore" onclick="newRestore()" value="{{ value.deviceUUID }}"/>
                                    	</td>
					<td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:50}}{{value.userName.length > 50 ? '...' : ''}}</td>
					<td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:50}}{{value.deviceName.length > 50 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:50}}{{value.restoreFolder.length > 50 ? '...' : ''}}]</span></td>
					<td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName  | limitTo:50 }}{{value.restoreByUserName.length > 50 ? '...' : ''}}</td>
					<td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName }}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:50}}{{value.destFolder.length > 50 ? '...' : ''}}]</span></td>
					<td ng-show="!value.restoreInitiatedBy" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-cloak> - </td>
					<td ng-show="value.restoreInitiatedBy" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-cloak>{{ value.restoreInitiatedBy }}</td>
					<td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-cloak>{{ value.startTime }}</td>
					<td ng-show="value.uploadPercent == '-'" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'"> - </td>
                                    	<td ng-show="value.uploadPercent != '-'" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
                                        	<div title="{{value.uploadPercent | number:0}}%" class="progress">
							<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        	</div>
                                    	</td>
                                    	<td class="actionRestore" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
						<a ng-click="stopRestore(value.userName, value.deviceUUID, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}"
						data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
						<span class="fa-stack">
						  <i class="fa fa-circle fa-stack-2x"></i>
						  <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
						</span>
						</a>
					</td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<div class="row currentRestorenavigate" style="display: none;">
<div class="col-lg-12 text-center">
<p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
<a class="btn btn-primary first" ng-click="expandViewRestoreNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
<a class="btn btn-primary previous" ng-click="expandViewRestoreNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
<a class="btn btn-primary next" ng-click="expandViewRestoreNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
<a class="btn btn-primary last" ng-click="expandViewRestoreNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
</div>
</div>
                <div class="h4 currentRestoreError text-center" style="display: none">No details found for Current Restore</div>
                <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
<!--                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, '')">Load More ...</a>-->
<a class="loadMoreBtn btn btn-primary" ng-click="expandView(skipValue)">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>
<a ng-click="stopBulkRestore()" id="bulkStopRestore" class="block btn btn-small btn-danger toolTip disabled" data-toggle="tooltip" data-placement="top" title="Stop Restore"><span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x" style="color:black!important;"></i>
                                        </span></a>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
 <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--currently running restores modal ends-->

            <div class="row">
<?php if($data['showCurrentlyRunningReports'] == true){?>		    
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showDeviceHeartbeatReport'] == true || $data['showUserBackupSummary'] == true || $data['showUserBackupSummary'] == true){?>
<div class="col-lg-8">
<?php } else { ?>
                <div class="col-lg-12">
<?php } ?>
<div class="col-lg-12">
                <div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="acc" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapse">
                                <h3 class="panel-title">Currently Running Backups 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentBackup(1)" class="aa glyphicon glyphicon-menu-down"></i>
                                        <i class="bb d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
                      <p class="currentBackupText" style="margin-left: 10px;">Expand to view currently running backups</p>
                      <div id="collapse" class="panel-collapse collapse">
			<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentBackup(1)" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
			<i class="glyphicon glyphicon-resize-full" ng-click="expandView(1, '', '')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
			<br>
                        <div class="table-responsive currentBackupDiv" style="overflow-y: scroll;height: 200px; display:none;">
                        <table id="CurrentBackup" class="table table-bordered currentBackup" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('deviceName', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
                                  <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
				  <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                  <th class="text-center"><?=Language::show('action', 'keywords')?></th>
				  <?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackup | orderBy:currentBackupSortType:sortReverse" class="text-center" ng-show="$index<50">
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-cloak>{{ value.startTime }}</td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
						<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
				    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
                                        <a ng-if="value.status !='SCANNING'" ng-click="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip" id="pause_{{$index}}" 
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>

                                    </td>
				    <?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandBackupStatement" style="display:none;"><a href="javascript:;" ng-click="expandView(1)" style="cursor:pointer;">Expand</a> to view complete list of currently running backups.</span><p>
                <div class="h4 currentBackupError text-center" style="display: none">No details found for Current Backup</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running restores start-->
<div class="col-lg-12">
<div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accrestore" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapserestore">
                                <h3 class="panel-title">Currently Running Restores 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentRestore(1)" class="aarestore glyphicon glyphicon-menu-down"></i>
                                        <i class="bbrestore d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
		      <p class="currentRestoreText" style="margin-left: 10px;">Expand to view currently running restores</p>
                      <div id="collapserestore" class="panel-collapse collapse">
		      <i class="glyphicon glyphicon-refresh" ng-click="updateCurrentRestore(1)" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
		      <i class="glyphicon glyphicon-resize-full" ng-click="expandViewRestore(1)" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
		      <br>
                        <div class="table-responsive currentRestoreDiv" style="overflow-y: scroll;height: 200px; display:none;">


                        <table id="CurrentRestore" class="table table-bordered currentRestore" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>DeviceName [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>DeviceName [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
				<th class="text-center clickAble d-none" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                    <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestore | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:20}}{{value.restoreFolder.length > 20 ? '...' : ''}}]</span></td>
				    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName | limitTo:20}}{{value.restoreByUserName.length > 20 ? '...' : ''}}</td>
				    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName | limitTo:20}}{{value.restoreByDeviceName.length > 20 ? '...' : ''}}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:20}}{{value.destFolder.length > 20 ? '...' : ''}}]</span></td>
				    <td class="d-none" ng-show="!value.restoreInitiatedBy" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-cloak> - </td>
				    <td class="d-none" ng-show="value.restoreInitiatedBy" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-cloak>{{ value.restoreInitiatedBy }}</td>
				    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'" ng-cloak>{{ value.startTime }}</td>
				    <td ng-show="value.uploadPercent == '-'" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'"> - </td>					
                                    <td ng-show="value.uploadPercent != '-'" ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td ng-if="value.deviceType != 'ONEDRIVE' && value.deviceType != 'OUTLOOK'">
                                        <a ng-click="stopRestore(value.userName, value.deviceUUID, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}"
                                        data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandRestoreStatement" style="display:none;"><a href="javascript:;" ng-click="expandViewRestore(1)" style="cursor:pointer;">Expand</a> to view complete list of currently running restores.</span></p>
                <div class="h4 currentRestoreError text-center" style="display: none">No details found for Current Restores</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running ends-->
                </div>
<?php } ?>	
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showDeviceHeartbeatReport'] == true || $data['showUserBackupSummary'] == true || $data['showUserBackupSummary'] == true){?>
		<?php if($data['showCurrentlyRunningReports'] == true){?>
				<div class="col-lg-4">
		<?php } else { ?>
		<div class="col-lg-12">
		<?php } ?>                
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title" style="color:black;"> Reports </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
			    <?php if($data['showUserBackupSummary'] == true){?>
				<p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupSummary/backup')?>"> Data Protection Scorecard</a></p>
			    <?php } ?>
                            <?php if($data['showBackupOverview'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/overview/backup')?>"> Backup Overview </a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <?php if($data['showBackupHistory'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupHistory/backup')?>"> Backup History </a></p>
                                <?php } ?>
                            <?php } ?>
                            <?php if($data['showFailedBackupHistory'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/failedBackup/backup')?>"> Failed Backup History</a></p>
                            <?php } ?>
                            <?php if($data['showSystemsWithoutBackups'] == true){?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/backup')?>"> Systems not protected</a></p>
				<p><a style="font-weight:600!important;" href="<?=Url::basePath('report/usersNoBackup/backup')?>"> Users without any systems protected</a>
                            <?php }else{ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/backup')?>"> Servers without backups</a></p>
                            <?php } ?>
                        <?php } ?>
                        <?php if($data['showRestoreHistory'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/restoreByDate/backup')?>"> Restore History</a></p>
                            <?php } ?>
                            <?php if($data['showStorageUtilizationReport'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/dailyUserBackupOverview/backup')?>"> Storage Utilization Report</a></p>
                            <?php } ?>
                            <?php if($data['showDeviceHeartbeatReport'] == true){?>
                            <p class="AgentHeartBeatReport"><a style="font-weight:600!important;" href="<?=Url::basePath('report/lastAgentServerConnectionDetails/backup')?>"> Device Heartbeat Report</a></p>
                            <?php } ?>			    
                        </div>
                    </div>
                </div>
            <?php } ?>
            </div>
            
            <?php } ?>
        </div>
        <!--bluvault tab end-->

        <!--odb start-->
        <div role="tabpanel" class="tab-pane <?php echo $data['activeTabO'];?>" id="odb">
            <?php if($data['isAdmin'] == 'true') { ?>
            <div class="onedriveSection">
            <div class="row dashboard">   
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectOnedrive('users')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-success">
                            <div class="background">
                                <i class="fa fa-users"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Active Users</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                 <i class="fa fa-users"></i>
                                <a class="pull-right d-none" style="font-size: 18px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.activeBackupUsers }}</span><span style="font-size: 18px;"> out of </span><span style="font-size: 18px;">{{ statisticsOneDrive.noOfOdbBackupUsersAllowed }}</span></a>
                            </div>
                        </div>
                    </div>    
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectOnedrive('devices')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-purple">
                            <div class="background">
                                <i class="fa fa-desktop"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Active Devices</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-desktop"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.devicesConnected }}</span></a>
                            </div>
                        </div>
                    </div>
		    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectOnedrive('restoreByDate')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-history"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <p style="color: #fff;">Completed restores<span class="pull-right" ng-cloak>{{ statisticsOneDrive.restoresDone }}</span></p>
                                <p style="color: #fff;">Avg. restores per user<span class="pull-right" ng-cloak>{{ statisticsOneDrive.avgRestorePerUser }}</span></p>
                            </div>
                            <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                <i style="font-size: 32px;" class="fa fa-history"></i>
                            </div>
                        </div>
                    </div>
                    <?php if(flipTotalCompletedBackups == false){ ?>
                    <?php if(totalCompletedBackups == true){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-database"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Completed Backups</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-database"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.backupsDone }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-success">
                            <div class="background">
                                <i class="fa fa-refresh"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Full Backups Completed</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-refresh"></i>
                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.fullBackupsDone }}</span></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                <?php }else{ ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectOnedrive('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if(totalCompletedBackups == true){?> front <?php }else{ ?> back <?php } ?>" onclick="flip()" >
                                <div class="panel panel-default no-box-shadow widget-primary fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Total Completed Backups</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                            <i class="fa fa-database"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.backupsDone }}</span></a>
                                    </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if(totalCompletedBackups == true){?> back <?php }else{ ?> front <?php } ?>" onclick="flipback()" >
                                <div class="panel panel-default no-box-shadow widget-success fold">
                                    <div class="background">
                                        <i class="fa fa-database"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Full Backups Completed</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-database"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.fullBackupsDone }}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>                    
            </div>
            <div class="row">
                <?php if(flipTotalActualStorageUtilized == false){ ?>
                    <?php if(totalActualStorageUtilized == false){ ?>
                        <?php if($data['hideCompressedSize'] == true){ ?>
                            <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                    <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a>Total Data Backed up</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i class="fa fa-hdd-o"></i>
                                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                        </div>
                                    </div>
                            </div>
                        <?php } else { ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                                <div class="panel panel-default no-box-shadow widget-warning">
                                        <div class="background">
                                            <i class="fa fa-hdd-o"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                                <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></p>
                                                <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalCompressedSizeInPercentage }}</span></p>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                                <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                </div>
                                </div>
                        </div>
                        <?php } ?>
                    <?php }else{ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php }else{ ?>
                <?php if($data['hideCompressedSize'] == false){?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> frontDB <?php }else{ ?> backDB <?php } ?>" onclick="flip1()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                        <i class="fa fa-hdd-o"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> backDB <?php }else{ ?> frontDB <?php } ?>" onclick="flipback1()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                        <p style="color: #fff;">Total Data Backed up<span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></p>
                                        <p style="color: #fff;">Storage Savings : <span class="pull-right" ng-cloak>{{ statisticsOneDrive.totalCompressedSizeInPercentage }}</span></p>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 0px 15px 4px 15px;">
                                        <i style="font-size: 32px;" class="fa fa-hdd-o"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } else { ?>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirectOnedrive('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> frontDB <?php }else{ ?> backDB <?php } ?>" onclick="flip1()" >
                            <div class="panel panel-default no-box-shadow widget-primary fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Actual Storage Utilized</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                        <i class="fa fa-hdd-o"></i>
                                        <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.totalActualStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace <?php if(totalActualStorageUtilized == true){?> backDB <?php }else{ ?> frontDB <?php } ?>" onclick="flipback1()" >
                            <div class="panel panel-default no-box-shadow widget-warning fold">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Data Backed up</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="totalStorageUtilized" ng-cloak>{{ statisticsOneDrive.totalStorageUtilized }}</span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } } ?>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-warning">
                        <div class="background">
                            <i class="fa fa-cog"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Currently Running Backups</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-cog"></i>
                            <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span style="font-size:23px;" ng-cloak>{{ statisticsOneDrive.currentlyRunningBackupCount }}</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirectOnedrive('usersWithoutDevices')" style="cursor:pointer;" <?php } ?>>
                    <div class="panel panel-default no-box-shadow widget-success">
                        <div class="background">
                            <i class="fa fa-inbox"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Users without active devices</a>
                             </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-inbox"></i>
                            <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span id="storage" ng-cloak>{{ statisticsOneDrive.userWithOutDevices }}</a>
                        </div>
                    </div>
                </div>
                <!-- new start-->
<?php if($data['flipNotProtectedTile'] == false){ ?>
                    <?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){ ?>
                        <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('systemsNotProtected')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-warning">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Systems not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfDevicesNotProtected }}</span></a>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  onclick="redirectOnedrive('usersNotProtected')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-purple">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Users with systems not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfUsersProtected }}</span></a>
                                </div>
                            </div>
                    </div>
                    <?php } ?>
                <?php }else{ ?>
		    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  style="cursor:pointer;" <?php } ?>>
                        <div class="card">
                            <div class="cardFace <?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){?> frontNP <?php }else{ ?> backNP <?php } ?>" onclick="flipNP()" ondblclick="redirectOnedrive('systemsNotProtected')" >
                                <div class="panel panel-default no-box-shadow widget-warning fold">
                                        <div class="background">
                                                <i class="fa fa-exclamation-triangle"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                                <a>Systems not protected</a>
                                        </div>
                                        <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                                <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                                <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfDevicesNotProtected }}</span></a>
                                        </div>
                                </div>
                            </div>
                            <div class="cardFace <?php if($data['tile8ReportType'] == 'usersWithSystemsNotProtected'){?> frontNP <?php }else{ ?> backNP <?php } ?>" onclick="flipbackNP()" ondblclick="redirectOnedrive('usersNotProtected')" >
                                <div class="panel panel-default no-box-shadow widget-purple fold">
                                <div class="background">
                                    <i class="fa fa-exclamation-triangle"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Users with systems not protected</a>
                                </div>
                                <div class="panel-body widget widget-body" style="padding: 15px 15px 24px 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 36px;"></i>
                                    <a class="pull-right d-none" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsOneDrive.noOfUsersProtected }}</span></a>
                                </div>
                            </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
<!-- new end-->
            </div>
            </div>
<?php } ?>
<!--modal start-->
<div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> currentlyRunningbackupsOnedrive">
                <div class="modal-dialog">
                    <div class="modal-content">
			<span><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></span>
                        <div class="modal-header" style="margin-bottom: -10px;">                            
                            <div class="panel-heading col-lg-12">
                                <h4 class="currentBackupOnedrive" style="display:none;">Currently Running Backups
                                    <div class="col-lg-5 pull-right">
                                    <center>
                                        <form ng-submit="searchCurrentlyRunningBackupsOnedrive(search.term)">
                                        <span id="search_img" class="fa fa-search fa-x" style="color: #b2b2b2;"></span>
                                                                        <input name="searchOutlook"
                                                                               type="text"
                                                                               class="pull-right form-control"
                                                                               ng-model="search.term"
                                                                               placeholder="Enter username or devicename or 'all' and hit enter to search"
                                                                                style="padding: 6px 24px !important;"
                                                                        />
                                        </form>
                                    </center>
                                    </div>
                                </h4>
                            </div>
                        </div>
                        <div class="modal-body col-lg-12">
                            <div class="table-responsive currentBackupOnedriveTableExpanded">
                            </hr>
                            <table id="CurrentBackupOnedrive" class="table table-bordered currentBackupOnedrivetable" style="display: none;">
                                <thead>
                                <tr>
                                <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                <th class="active">
                                        <input type="checkbox" class="select-all-onedrive checkbox" name="select-all-onedrive"/>
                                </th>
                                <?php } ?>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('deviceName', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                    <th class="text-center clickAble" ng-click="currentBackupSortType = 'backupType'; sortReverse = !sortReverse">
					 <?=Language::show('Backup Type', 'keywords')?>
					 <span ng-show="currentBackupSortType == 'backupType' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'backupType' && sortReverse" class="fa fa-caret-down"></span>
					&nbsp;
                                        <select class="form-control backupTypeOnedrive" style="width: 30% !important;display:inherit !important;">
                                            <option value="INCR">INCR</option>
                                            <option value="FULL">Full</option>
                                            <option value="" selected>All</option>
                                        </select>
                                    </th>
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <th class="text-center actionnOnedrive"><?=Language::show('action', 'keywords')?></th>
                                    <?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackupE | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
                                        <input type="checkbox" class="select-item-onedrive checkbox" name="select-item-onedrive" onclick="newoneOnedrive()" value="{{ value.deviceUUID }}"/>
                                    </td>
                                    <?php } ?>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-cloak>{{ value.startTime }}</td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-show="value.backupType == 'INCR'" ng-cloak>Incremental</td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-show="value.backupType == 'FULL'" ng-cloak>Full</td>
                                    <?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td class="actionnOnedrive" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
                                        <a ng-click="saveEventHubCurrentBackupOnedrive(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip ripple" id="pause_{{$index}}" 
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackupOnedrive(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                    <?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
                            <div class="row currentBackupOnedrivenavigate hide" style="display: none;">
                            <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="expandViewOnedriveNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="expandViewOnedriveNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="expandViewOnedriveNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="expandViewOnedriveNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                            </div>
                            </div>
                            <div class="h4 currentBackupErrorOnedrive text-center" style="display: none">No details found for Current Backup</div>
                            <div class="row loadMore" style="display: none;">
                                <div class="col-lg-12 text-center">
                                    <a class="loadMoreBtn btn btn-primary" ng-click="expandView(skipValue)">Load More ...</a>
                                        <br /><br />
                                </div>
                            </div>
                            
                            <?php if($data['stopPauseAccess'] == 'true'){ ?>
                            <a ng-click="saveBulkEventHubCurrentBackupOnedrive('stop')" id="bulkstopbackupOnedrive" class="block btn btn-small btn-danger toolTip disabled" data-toggle="tooltip" data-placement="top" title="Stop Backup">
                                <span class="fa-stack">
                                    <i class="fa fa-circle fa-stack-2x"></i>
                                    <i class="fa fa-stop fa-stack-1x" style="color:black!important;"></i>
                                </span>
                            </a>
                            <a ng-click="saveBulkEventHubCurrentBackupOnedrive('pause')" id="bulkpausebackupOnedrive" class="block btn btn-small btn-danger toolTip disabled" style="margin-right:5px;" data-toggle="tooltip" data-placement="top" title="Pause Backup">
                                <span class="fa-stack">
                                    <i class="fa fa-circle fa-stack-2x"></i>
                                    <i class="fa fa-pause fa-stack-1x" style="color:black!important;"></i>
                                </span>
                            </a>
                            <?php } ?>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--modal ends-->
<!--currently running restores modal start-->
<div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> currentlyRunningrestoresOnedrive">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
<div class="panel-heading">
                            <h4 class="currentRestoreOnedrive" style="display:none;">
                                Currently Running Restores
                            </h4>
</div>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive">
                            </hr>
                        <table id="CurrentRestoreOnedrive" class="table table-bordered currentRestoreOnedrivetable" style="display: none;">
                                <thead>
                                <tr>
				  <th class="active">
                                        <input type="checkbox" class="select-all-restore-onedrive checkbox" name="select-all-restore-onedrive"/>
				  </th>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                            <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
				  <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>DeviceName [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
				  <th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
				  <th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>DeviceName [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
				  <th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                  </th>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
				  </th>
                                  <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                  <th class="text-center actionRestoreOnedrive"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestoreE | orderBy:currentBackupSortType:sortReverse" class="text-center">
<td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
        <input type="checkbox" class="select-item-restore-onedrive checkbox" name="select-item-restore-onedrive" onclick="newRestoreOnedrive()" value="{{ value.deviceUUID }}"/>
                                    </td>
<td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:50}}{{value.userName.length > 50 ? '...' : ''}}</td>
<td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:50}}{{value.deviceName.length > 50 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:50}}{{value.restoreFolder.length > 50 ? '...' : ''}}]</span></td>
<td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName | limitTo:50}}{{value.restoreByUserName.length > 50 ? '...' : ''}}</td>
<td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName | limitTo:50}}{{value.restoreByDeviceName.length > 50 ? '...' : ''}}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:50}}{{value.destFolder.length > 50 ? '...' : ''}}]</span></td>
<td ng-show="!value.restoreInitiatedBy" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-cloak> - </td>
<td ng-show="value.restoreInitiatedBy" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-cloak>{{ value.restoreInitiatedBy }}</td>
<td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-cloak>{{ value.startTime }}</td>
<td ng-show="value.uploadPercent == '-'" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'"> - </td>					
                                    <td ng-show="value.uploadPercent != '-'" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
						<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td class="actionRestoreOnedrive" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
     					<a ng-click="stopRestoreOnedrive(value.userName, value.deviceUUID, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}"
                                        data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
</td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<div class="row currentRestoreOnedrivenavigate" style="display: none;">
<div class="col-lg-12 text-center">
<p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
<a class="btn btn-primary first" ng-click="expandViewRestoreNavigateOnedrive(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
<a class="btn btn-primary previous" ng-click="expandViewRestoreNavigateOnedrive(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
<a class="btn btn-primary next" ng-click="expandViewRestoreNavigateOnedrive(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
<a class="btn btn-primary last" ng-click="expandViewRestoreNavigateOnedrive(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
</div>
</div>
                <div class="h4 currentRestoreErrorOnedrive text-center" style="display: none">No details found for Current Restore</div>
                <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
<!--                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, '')">Load More ...</a>-->
<a class="loadMoreBtn btn btn-primary" ng-click="expandView(skipValue)">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>
<a ng-click="stopBulkRestoreOnedrive()" id="bulkStopRestoreOnedrive" class="block btn btn-small btn-danger toolTip disabled" data-toggle="tooltip" data-placement="top" title="Stop Restore"><span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x" style="color:black!important;"></i>
                                        </span></a>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
 <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--currently running restores modal ends-->

            <div class="row">
<?php if($data['showCurrentlyRunningReports'] == true){?>		    
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showUserBackupSummary'] == true){?>
<div class="col-lg-8">
<?php } else { ?>
                <div class="col-lg-12">
<?php } ?>
<div class="col-lg-12">
                <div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accOnedrive" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapseOnedrive">
                                <h3 class="panel-title">Currently Running Backups 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentBackupOnedrive(1)" class="aaOnedrive glyphicon glyphicon-menu-down"></i>
                                        <i class="bbOnedrive d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
                      <p class="currentBackupTextOnedrive" style="margin-left: 10px;">Expand to view currently running backups</p>
                      <div id="collapseOnedrive" class="panel-collapse collapse">
<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentBackupOnedrive(1)" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<i class="glyphicon glyphicon-resize-full" ng-click="expandViewOnedrive(1, '', '')" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<br>
                        <div class="table-responsive currentBackupDivOnedrive" style="overflow-y: scroll;height: 200px; display:none;">
                        <table id="CurrentBackupOnedrive" class="table table-bordered currentBackupOnedrive" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('deviceName', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
<?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <th class="text-center"><?=Language::show('action', 'keywords')?></th>
<?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackup | orderBy:currentBackupSortType:sortReverse" class="text-center" ng-show="$index<50">
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-cloak>{{ value.startTime }}</td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
						<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
<?php if($data['stopPauseAccess'] == 'true'){ ?>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
                                        <a ng-click="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'pause', $index)" class="toolTip" id="pause_{{$index}}" 
                                        data-toggle="tooltip" data-placement="top" title="Pause Backup" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-pause fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                        <a class="toolTip" id="stop_{{$index}}" data-toggle="tooltip" data-placement="top" title="Stop Backup" ng-bootbox-confirm="<h4><?=Language::show('Are you sure?', 'keywords')?></h4>" ng-bootbox-confirm-action="saveEventHubCurrentBackup(value.userName, value.deviceUUID, 'stop', $index)" ng-bootbox-confirm-action-cancel="" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>

                                    </td>
<?php } ?>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandBackupStatementOnedrive" style="display:none;"><a href="javascript:;" ng-click="expandViewOnedrive(1)" style="cursor:pointer;">Expand</a> to view complete list of currently running backups.</span><p>
                <div class="h4 currentBackupErrorOnedrive text-center" style="display: none">No details found for Current Backup</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running restores start-->
<div class="col-lg-12">
<div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accrestoreOnedrive" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapserestoreOnedrive">
                                <h3 class="panel-title">Currently Running Restores 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentRestoreOnedrive(1)" class="aarestoreOnedrive glyphicon glyphicon-menu-down"></i>
                                        <i class="bbrestoreOnedrive d-none glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>


<p class="currentRestoreTextOnedrive" style="margin-left: 10px;">Expand to view currently running restores</p>
                      <div id="collapserestoreOnedrive" class="panel-collapse collapse">
<i class="glyphicon glyphicon-refresh" ng-click="updateCurrentRestoreOnedrive(1)" title="refresh" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<i class="glyphicon glyphicon-resize-full" ng-click="expandViewRestoreOnedrive(1)" title="expand" style="margin-right: 18px;float: right;margin-bottom:10px;cursor:pointer;"></i>
<br>
                        <div class="table-responsive currentRestoreDivOnedrive" style="overflow-y: scroll;height: 200px; display:none;">


                        <table id="CurrentRestoreOnedrive" class="table table-bordered currentRestoreOnedrive" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Source', 'keywords')?><br>
				    	<span>DeviceName [Path]</span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByUserName'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore By', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByUserName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="currentBackupSortType = 'restoreByDeviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Destination', 'keywords')?><br>
				    	<span>DeviceName [Path]</span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreByDeviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble d-none" ng-click="currentBackupSortType = 'restoreInitiatedBy'; sortReverse = !sortReverse">
                                        <?=Language::show('Restore running as', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'restoreInitiatedBy' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                 </th>
                                 <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                 <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentRestore | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.userName }}" class="text-center" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.deviceName }}" class="text-center" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}<span ng-if="value.restoreFolder != null"> [{{value.restoreFolder | limitTo:20}}{{value.restoreFolder.length > 20 ? '...' : ''}}]</span></td>
				    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.restoreByUserName }}" class="text-center" ng-cloak>{{ value.restoreByUserName | limitTo:20 }}{{value.restoreByUserName.length > 20 ? '...' : ''}}</td>
				    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" title="{{ value.restoreByDeviceName }}" class="text-center" ng-cloak>{{ value.restoreByDeviceName | limitTo:20 }}{{value.restoreByDeviceName.length > 20 ? '...' : ''}}<span ng-if="value.destFolder != null"> [{{value.destFolder | limitTo:20}}{{value.destFolder.length > 20 ? '...' : ''}}]</span></td>
				    <td class="d-none" ng-show="!value.restoreInitiatedBy" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-cloak> - </td>
				    <td class="d-none" ng-show="value.restoreInitiatedBy" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-cloak>{{ value.restoreInitiatedBy | limitTo:20 }}{{value.restoreInitiatedBy.length > 20 ? '...' : ''}}</td>
				    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'" ng-cloak>{{ value.startTime }}</td>
				    <td ng-show="value.uploadPercent == '-'" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'"> - </td>					
                                    <td ng-show="value.uploadPercent != '-'" ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
                                        <div title="{{value.uploadPercent | number:0}}%" class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{value.uploadPercent}}%;width:{{value.uploadPercent}}%;">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                    <td ng-if="value.deviceType == 'ONEDRIVE' || value.deviceType == 'OUTLOOK'">
                                        <a ng-click="stopRestoreOnedrive(value.userName, value.deviceUUID, 'stop', $index)" class="toolTip" id="stopRestore_{{$index}}"
                                        data-toggle="tooltip" data-placement="top" title="Stop Restore" href="javascript:;">
                                        <span class="fa-stack">
                                          <i class="fa fa-circle fa-stack-2x"></i>
                                          <i class="fa fa-stop fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </a>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
<p class="text-center"><span id="expandRestoreStatementOnedrive" style="display:none;"><a href="javascript:;" ng-click="expandViewRestoreOnedrive(1)" style="cursor:pointer;">Expand</a> to view complete list of currently running restores.</span></p>
                <div class="h4 currentRestoreErrorOnedrive text-center" style="display: none">No details found for Current Restores</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
</div>
<!-- currently running ends-->
                </div>
	<?php } ?>
<?php if($data['showBackupOverview'] == true || $data['showBackupHistory'] == true || $data['showFailedBackupHistory'] == true || $data['showSystemsWithoutBackups'] == true || $data['showRestoreHistory'] == true || $data['showStorageUtilizationReport'] == true || $data['showUserBackupSummary'] == true){?>
		<?php if($data['showCurrentlyRunningReports'] == true){?>
		<div class="col-lg-4">
		<?php } else { ?>
		<div class="col-lg-12">
		<?php } ?>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title" style="color:black;"> Reports </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
			    <?php if($data['showUserBackupSummary'] == true){?>
                            <p class="hide"><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupSummary/office')?>"> Data Protection Scorecard</a></p>
                            <?php } ?>
                            <?php if($data['showBackupOverview'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/overview/office')?>"> Backup Overview </a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <?php if($data['showBackupHistory'] == true){?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/userBackupHistory/office')?>"> Backup History </a></p>
                                <?php } ?>
                            <?php } ?>
                            <?php if($data['showFailedBackupHistory'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/failedBackup/office')?>"> Failed Backup History</a></p>
                            <?php } ?>
                            <?php if($data['showSystemsWithoutBackups'] == true){?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/office')?>"> Systems not protected</a></p>
				<p><a style="font-weight:600!important;" href="<?=Url::basePath('report/usersNoBackup/office')?>"> Users without any systems protected</a>
                            <?php }else{ ?>
                                <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/noBackup/office')?>"> Servers without backups</a></p>
                            <?php } ?>
                        <?php } ?>
                        <?php if($data['showRestoreHistory'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/restoreByDate/office')?>"> Restore History</a></p>
                            <?php } ?>
                            <?php if($data['showStorageUtilizationReport'] == true){?>
                            <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/dailyUserBackupOverview/office')?>"> Storage Utilization Report</a></p>
                            <?php } ?>                            
                        </div>
                    </div>
                </div>
            <?php } ?>
            </div>
        </div>
        <!--odb end-->
        <!--sync start-->
        <div role="tabpanel" class="tab-pane <?php echo $data['activeTabS'];?>" id="sync">
        <?php
            /*    $percent = $data['cloudDetails']->{'space-used'}/$data['cloudDetails']->{'license'}->{'max-storage'};
                $percent_friendly = number_format( $percent * 100, 2 );
                if($percent_friendly > 25 && $percent_friendly <= 50) {
                    $color = '#10cfbd';
                    $class = 'success';
                }elseif($percent_friendly > 50 && $percent_friendly <= 75) {
                    $color = '#f8d053';
                    $class = 'warning';
                }elseif($percent_friendly > 75 && $percent_friendly <= 100) {
                    $color = '#6d5cae';
                    $class = 'danger';
                }else{
                    $color = '#2095f2';
                    $class = 'primary';
                }*/
                ?>
                <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                <div class="row">
                    <!-- start -->
                        <div class="col-lg-6" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('users')" style="cursor:pointer;" <?php } ?>>
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-users"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Users</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-users"></i>
                                    <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statisticsSync.noOfSyncUsersConnected }}</span><span style="font-size: 20px;"> active out of </span><span ng-cloak style="font-size: 20px;">{{ statisticsSync.liscenseElement.totalNoOfUsers}}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 d-none" block-ui="myBlockUI">
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-desktop"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Devices</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-desktop"></i>
                                    <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><?=$data['cloudDetails']->{'devices-connected'}?></a>
                                </div>
                            </div>
                        </div>
                    <div class="col-lg-6" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('miniClouds')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-cloud"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>MiniClouds</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-cloud"></i>
                                <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span ng-cloak style="font-size: 20px;">{{statisticsSync.noOfMyClouds}}</span><span style="font-size: 20px;"> used out of </span><span ng-cloak style="font-size: 20px;">{{statisticsSync.liscenseElement.noOfMiniCloudsAllowed}}</span></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">            
                    <!-- end -->
                    <div class="col-lg-6" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('syncCLoudUsage')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-warning">
                            <div class="background">
                                <i class="fa fa-hdd-o"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Storage Details</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-hdd-o"></i>
                                <a class="pull-right" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{statisticsSync.spaceUsed}} {{unit}}</span></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6" block-ui="myBlockUI">
                        <div class="panel panel-default no-box-shadow widget-purple">
                            <div class="background">
                                <i class="fa fa-clock-o"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Parablu Installation valid Until</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-clock-o"></i>
                                <a class="pull-right" ng-cloak style="font-size: 20px;margin-top: -20px;">{{statisticsSync.liscenseElement.validityPeriod}}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6 d-none">
                        <div class="panel">
                            <div class="panel-heading">
                                <h5 style="padding: 0px 0px 0px 15px;"><?=$data['crumb1']?>, (Parablu Installation Name: <?=$data['cloudDetails']->{'cloud-name'}?>)</h5>
                            </div>
                            <div class="panel-body">
                                <div class="row" style="padding-right: 15px; padding-left: 15px;">
                                    <table class="table table-bordered text-center d-none">
                                        <tbody>
                                        <tr>
                                            <td></td>
                                            <td><b>Allowed</b></td>
                                            <td><b>Consumed</b></td>
                                            <td><b>Remaining</b></td>
                                        </tr>
                                        <tr>
                                            <td>Storage Details</td>
                                            <td><?=$data['cloudDetails']->{'license'}->{'max-storage'}?> GB</td>
                                            <td><?=$data['cloudDetails']->{'space-used'}?> GB</td>
                                            <td><?=($data['cloudDetails']->{'license'}->{'max-storage'}-$data['cloudDetails']->{'space-used'})?> GB</td>
                                        </tr>
                                        <tr>
                                            <td>MiniClouds</td>
                                            <td><?=$data['cloudDetails']->{'license'}->{'max-mc'}?></td>
                                            <td><?=$data['cloudDetails']->{'myclouds-connected'}?></td>
                                            <td><?=($data['cloudDetails']->{'license'}->{'max-mc'}-$data['cloudDetails']->{'myclouds-connected'})?></td>
                                        </tr>
                                        <tr>
                                            <td>Users</td>
                                            <td><?=$data['cloudDetails']->{'license'}->{'max-users'}?></td>
                                            <td><?=$data['cloudDetails']->{'users-connected'}?></td>
                                            <td><?=($data['cloudDetails']->{'license'}->{'max-users'}-$data['cloudDetails']->{'users-connected'})?></td>
                                        </tr>
                                        <?php if($data['cloudDetails']->{'license'}->{'backup-enabled'} == true){ ?>
                                            <!--<tr>
                                                <td>Backup Users</td>
                                                <td><?=$data['cloudDetails']->{'license'}->{'max-backup-users'}?></td>
                                                <td><?=$data['cloudDetails']->{'backup-users-connected'}?></td>
                                                <td><?=($data['cloudDetails']->{'license'}->{'max-backup-users'}-$data['cloudDetails']->{'backup-users-connected'})?></td>
                                            </tr>-->
                                        <?php } ?>
                                        <?php if($data['cloudDetails']->{'license'}->{'sync-enabled'} == true){ ?>
                                            <tr>
                                                <td>Sync Users</td>
                                                <td><?=$data['cloudDetails']->{'license'}->{'max-sync-users'}?></td>
                                                <td><?=$data['cloudDetails']->{'sync-users-connected'}?></td>
                                                <td><?=($data['cloudDetails']->{'license'}->{'max-sync-users'}-$data['cloudDetails']->{'sync-users-connected'})?></td>
                                            </tr>
                                        <?php } ?>
                                        </tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h3 class="panel-title" style="color:black;"> Reports </h3>
                                </div>
                                <hr/>
                                <div class="panel-body">
                                    <?php if(BLUDRIVE_MODE == true){ ?>
                                    	<p><a style="font-weight:600!important;" href="<?=Url::basePath('report/syncCLoudUsage')?>"> BluDrive Overview Summary</a></p>
                                    <?php } else { ?>
                                    	<p><a style="font-weight:600!important;" href="<?=Url::basePath('report/syncCLoudUsage')?>"> Sync Overview Summary</a></p>
                                    <?php } ?>
				    <p><a style="font-weight:600!important;" href="<?=Url::basePath('report/minicloudActivity')?>"> MiniCloud Activity History</a></p>
                                    <!--<p><a href="<?=Url::basePath('report/download/syncOverviewReport')?>"> Sync User Activity History in Excel format</a></p>-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
    </div>
        <!--sync end-->
    </div> <!--tab-content ends-->
	<!--modal start-->
            <div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> userBackupSummaryModal" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <div class="panel-heading">
                                <h4>User Backup Summary</h4>
<!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            </div>
                        </div>
                        <div class="modal-body col-lg-12">
                            <div class="col-lg-12" style="border: 1px solid #F27331;padding: 20px;border-radius: 10px;">
                                <span class="reportProductType hide" id="reportProductType"></span>
                                <form ng-submit="updateUserBackupSummary(search.noOfDays,search.searchPolicyName)">
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <label for="searchPolicyName">Policy Name</label>
                                            <select name="searchPolicyName[]" id="searchPolicyName" multiple class="form-control selectPicker searchPolicyName"  title='Select Backup Policy Name' disabled>
                                            <option value="all" selected>all</option>
                                                <?php if(!empty($data['backupPolicies'])){ ?>
                                                    <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <label for="noOfDays">User Backup Summary for</label>
                                            <input type="number" id="noOfDays" value="30" min="1" placeholder="Number Of Days" data-parsley-trigger="change" disabled> <label style="margin-top:12px;">days </label>
                                        </div>					
                                    </div>
                                </form>
                            </div>
                    <br/>
                    <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                    <br/>
                    <div class="table-responsive" style="overflow-x: unset !important;">
                        <table id="NoBackup" class="table table-bordered noBackup" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('Sr. No.', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('Statistics', 'keywords')?>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'formatedTimeInMills'; sortReverse = !sortReverse">
                                    <?=Language::show('Values', 'keywords')?>
                                </th>
			    </tr>
                            </thead>
                            <tbody>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>1.</td>
                                <td class="text-left" ng-cloak>Active Users</td>
                                <td ng-cloak>{{ userBackupSummary.noOfActiveBackupUsers }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>2.</td>
                                <td class="text-left notForOffice" ng-cloak>Users with at least one device assigned</td>
				<td class="text-left forOffice" ng-cloak>Users with at least one OneDrive assigned</td>
                                <td ng-cloak>{{ userBackupSummary.userWithDevices }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>3.</td>
                                <td class="text-left" ng-cloak>No. of users for whom at least one full backup is completed</td>
                                <td ng-cloak>{{ userBackupSummary.userWithFirstBkpCompleted }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>4.</td>
                                <td class="text-left notForOffice" ng-cloak>No. of users without device registered</td>
				<td class="text-left forOffice" ng-cloak>No. of users without OneDrive registered</td>
                                <td ng-cloak>{{ userBackupSummary.userWithOutDevices }}</td>
                            </tr>
                            <tr class="text-center notForOffice">
                                <td class="text-center" ng-cloak>5.</td>
                                <td class="text-left" ng-cloak>No. of users whose devices had a heartbeat to the server in the last <span class="heartbeat"></span> days</td>
                                <td ng-cloak>{{ userBackupSummary.noOfUsersHeardCount }}</td>
                            </tr>
                            <tr class="text-center">
                                <td class="text-center notForOffice" ng-cloak>6.</td>
                                <td class="text-center forOffice" ng-cloak>5.</td>
                                <td class="text-left notForOffice" ng-cloak>No. of users whose devices have been protected in the last <span class="protected"></span> days</td>
				<td class="text-left forOffice" ng-cloak>No. of users whose OneDrive have been protected in the last <span class="protected"></span> days</td>
                                <td ng-cloak>{{ userBackupSummary.noOfUsersProtected }}</td>
                            </tr>
                            </tbody></table>
                        </div>
                        <div class="h4 noBackupError text-center" style="display: none">No details found</div>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
<!--modal ends-->
	<!--modal--><?php if($data['popup'] == 'visible') { ?>
            <div class="modal fade" id="changePasswordForFirstlogin" role="dialog" data-keyboard="false" data-backdrop="static">
                <div class="modal-dialog">
                <!-- Modal content-->
                        <div class="modal-content">
                        <?=Form::open(array(
                            		'ng-submit' => 'changePasswordForFirstlogin()',
                            		'method' => 'post',
                            		'id' => 'changePasswordForFirstlogin',
                            		'csrf' => $data['csrf_token'],
                            		'autocomplete' => 'off',
                            		'data-parsley-validate' => true
                        		));
                        ?>
        		<div class="modal-header">
          			<h4 class="modal-title">Change Password</h4>
        		</div>
        		<div class="modal-body">
	                        <div class="form-group">
	                        	<label for="passwordGuest">Password</label>
	                        	<?php if(complexPassword == true) { ?>
	                        		<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
						<span id="passwordError" style="color: #f55753;font-size: 0.9em;"></span>
	                        	<?php } else { ?>
	                        		<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-required data-parsley-minlength="6">
						<span id="passwordError" style="color: #f55753;font-size: 0.9em;"></span>
	                        	<?php } ?>
                        	</div>
                        	<div class="form-group">
                            		<label for="rePasswordGuest">Re Type Password</label>
                            		<input type="password" class="form-control" name="rePassword" id="rePassword" placeholder="<?=Language::show('rePassword', 'keywords');?>" required autocomplete="off" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
					<span id="rePasswordError" style="color: #f55753;font-size: 0.9em;"></span>
                        	</div>
				<?php if(googleAuthenticator == true){ ?>
				<!--collapse start-->
				<div class="form-group">
					<a ng-click="requestQR()" href="" style="margin-top:25px;">Request QR Code</a>
                                	<!--<a data-toggle="collapse" href="#qrCollapse" role="button" aria-expanded="false" aria-controls="qrCollapse"><span class="aa">Request QR Code</span><span class="aa hide">Request QR Code</span></a>-->
                            	</div>
				<div class="col-lg-12 collapse" id="qrCollapse" style="border: 1px solid rgb(242, 115, 49);">
					<div class="row" style="margin-bottom:10px;">
                                		<div class="col-lg-8">
                                    			<label for="mailId"><?=Language::show('Email Id', 'keywords');?></label>
                                    			<input type="text" class="form-control" name="mailId" id="mailId" value="<?=$_SESSION['emailId']?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('Email Id', 'keywords');?>" autocomplete="off" style="opacity:0.5;pointer-events:none;">
                                            	</div>
						<div class="col-lg-2">
						    <a type="button" class="btn btn-success" ng-click="requestQR()" style="margin-top:25px;"><?=Language::show('Submit', 'share');?></a>
						</div>
						<div class="col-lg-12">
						    <span id="statussuccess" style="color: #4faf50;font-size: 0.9em;"></span>
						    <span id="statuserror" style="color: #f55753;font-size: 0.9em;"></span>
						</div>
					</div>
                            	</div>
				<!--collapse end-->
				<center class="hide"><div id="img">
                                <img src='<?php echo $qrCodeUrl; ?>' />
                                </div></center>
				<?php } ?>
        		</div>
        		<div class="modal-footer">
          			<?php if(googleAuthenticator == true){ ?>
          				<p style="float: left;">Note: This user account has been enabled for multi-factor authentication.  Please use an authenticator app on your smartphone to scan the QR code sent to your Email Id and generate a one-time key.</p>
				<?php } else { ?>
        				<p style="float: left;">Note: Please change password to proceed further.</p>
				<?php } ?>
          			<?php if(googleAuthenticator == true){ ?>
                			<a id="changePasswordBtnGuest" ng-bootbox-confirm="<h4>You may use Microsoft or Google Authenticator to set up Multi-Factor Authentication (MFA) using the QR code sent to your Email Id.  If you have not requested for QR code yet, please click Cancel and get QR code from 'Request QR Code' first.</h4>"
                                       ng-bootbox-confirm-action="changePasswordForFirstlogin()"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-primary"> <?=Language::show('save', 'keywords');?></a>
          			<?php } else { ?>
                			<button type="submit" id="changePasswordBtnGuest" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
          			<?php } ?>
        		</div>
        		<?=Form::close();?>
      		</div>
      	</div>
  </div>
  <?php } ?>
            <!--modal-->
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
var nav = '<?=$data['session_cok']?>';                                                                   
localStorage.setItem("consistancy",nav);	
$(".acc").click(function(){
    	$(".aa").toggleClass("d-none");
	$(".bb").toggleClass("d-block");
	$('.currentBackupText').toggleClass('d-none');
});

$(".accOnedrive").click(function(){
    	$(".aaOnedrive").toggleClass("d-none");
	$(".bbOnedrive").toggleClass("d-block");
	$('.currentBackupTextOnedrive').toggleClass('d-none');
});

$(".accrestore").click(function(){
    	$(".aarestore").toggleClass("d-none");
	$(".bbrestore").toggleClass("d-block");
	$('.currentRestoreText').toggleClass('d-none');
});

$(".accrestoreOnedrive").click(function(){
    	$(".aarestoreOnedrive").toggleClass("d-none");
	$(".bbrestoreOnedrive").toggleClass("d-block");
	$('.currentRestoreTextOnedrive').toggleClass('d-none');
});

function redirect(type){
	switch (type) {
	    case 'users':
		window.location.href = "<?=Url::basePath('users')?>";
		break;
	    case 'devices':
		window.location.href = "<?=Url::basePath('devices')?>";
		break;
	    case 'userBackupHistory':
		window.location.href = "<?=Url::basePath('report/userBackupHistory/backup')?>";
		break;
	    case 'dailyUserBackupOverview':
		window.location.href = "<?=Url::basePath('report/dailyUserBackupOverview/backup')?>";
		break;
	    case 'restoreByDate':
		window.location.href = "<?=Url::basePath('report/restoreByDate/backup')?>";
		break;
	    case 'miniClouds':
		window.location.href = "<?=Url::basePath('miniClouds')?>";
		break;
	    case 'syncCLoudUsage':
		window.location.href = "<?=Url::basePath('report/syncCLoudUsage')?>";
		break;
	    case 'usersWithoutDevices':
		window.location.href = "<?=Url::basePath('report/usersWithoutDevices/backup')?>";
		break;
	    case 'systemsNotProtected':
		window.location.href = "<?=Url::basePath('report/noBackup/backup')?>";
		break;
	    case 'usersNotProtected':
                window.location.href = "<?=Url::basePath('report/usersNoBackup/backup')?>";
                break;
	}
}
	
function redirectOnedrive(type){
	switch (type) {
	    case 'users':
		window.location.href = "<?=Url::basePath('users')?>";
		break;
	    case 'devices':
		window.location.href = "<?=Url::basePath('devices')?>";
		break;
	    case 'userBackupHistory':
		window.location.href = "<?=Url::basePath('report/userBackupHistory/office')?>";
		break;
	    case 'dailyUserBackupOverview':
		window.location.href = "<?=Url::basePath('report/dailyUserBackupOverview/office')?>";
		break;
	    case 'restoreByDate':
		window.location.href = "<?=Url::basePath('report/restoreByDate/office')?>";
		break;
	    case 'miniClouds':
		window.location.href = "<?=Url::basePath('miniClouds')?>";
		break;
	    case 'syncCLoudUsage':
		window.location.href = "<?=Url::basePath('report/syncCLoudUsage')?>";
		break;
	    case 'usersWithoutDevices':
		window.location.href = "<?=Url::basePath('report/usersWithoutDevices/office')?>";
		break;
	    case 'systemsNotProtected':
		window.location.href = "<?=Url::basePath('report/noBackup/office')?>";
		break;
	    case 'usersNotProtected':
                window.location.href = "<?=Url::basePath('report/usersNoBackup/office')?>";
                break;
	}	
}
</script>
<style>

.cardWrapper{
/*  width:200px;*/
  height:135px;
  position:relative;
  /*background-color:#333;*/
  float:left;
/*  margin-right:10px;*/
  cursor:pointer;
  -webkit-font-smoothing:antialiased;
}

.cardFace{
/*  position:absolute;
  width:200px;
  height:200px;*/
width:100%;
  overflow:hidden;
}
/*
.front{
  background-color:#10cfbd; 
}

.back{
  background-color:#10cfbd; 
}*/


/*
.cardFace h1{
  margin:0px;
  font-size:30px;
  padding:10px 0px 10px 10px;
  border-bottom:solid 6px #aaa;
  border-top:solid 6px #aaa;
  background-color:black;
  color:white;
}


.cardFace.back h1{
 border-color:#91e600;
}
*/
.moreInfo{
  padding:10px;
  color:white;
  line-height:24px;
  
}
</style>


    <script type="text/javascript">
    //IE doesn't transform-style:preserve-3d.
// for IE try https://codepen.io/rhernando/pen/vjGxH


//using TweenLite.set() takes care of all vendor-prefixes
TweenLite.set(".cardWrapper", {perspective:800});
TweenLite.set(".card", {transformStyle:"preserve-3d"});
TweenLite.set(".back", {rotationY:-180});
TweenLite.set(".backDB", {rotationY:-180});
TweenLite.set(".backRe", {rotationY:-180});
TweenLite.set(".backNP", {rotationY:-180});	    
TweenLite.set([".back", ".front"], {backfaceVisibility:"hidden"});
TweenLite.set([".backDB", ".frontDB"], {backfaceVisibility:"hidden"});
TweenLite.set([".backRe", ".frontRe"], {backfaceVisibility:"hidden"});
TweenLite.set([".backNP", ".frontNP"], {backfaceVisibility:"hidden"});	    

setTimeout(function(){
$('.back').addClass('d-none');
$('.backDB').addClass('d-none');
$('.backRe').addClass('d-none');
$('.backNP').addClass('d-none');	
                }, 1000);

$(".cardWrapper").hover(
  function() {
    TweenLite.to($(this).find(".card"), 1.2, {rotationY:180, ease:Back.easeOut});
  },
  function() {
    TweenLite.to($(this).find(".card"), 1.2, {rotationY:0, ease:Back.easeOut});  
  }
);

//a nice little intro;)
TweenMax.staggerTo($(".card"), 1, {rotationY:-180, repeat:1, yoyo:true}, 0.1);
/* learn more about GSAP JS:
https://www.greensock.com/gsap-js/

more codepen samples:
https://codepen.io/collection/jmHAn

basics:
https://codepen.io/collection/ifybJ

*/

<?php if(totalCompletedBackups == true){?>
function flip() {
    $(".front").addClass("d-none");
    $(".back").removeClass("d-none");
    $(".back").css("transform","");
    $(".back").css("backface-visibility","");
}
function flipback() {
    $(".back").addClass("d-none");
    $(".front").removeClass("d-none");
    $(".front").css("transform","");
    $(".front").css("backface-visibility","");
    }
<?php }else{ ?>
function flip() {
    $(".back").addClass("d-none");
    $(".front").removeClass("d-none");
    $(".front").css("transform","");
    $(".front").css("backface-visibility","");
}
function flipback() {
    $(".front").addClass("d-none");
    $(".back").removeClass("d-none");
    $(".back").css("transform","");
    $(".back").css("backface-visibility","");
    }
<?php } ?>

<?php if(totalActualStorageUtilized == true){?>
function flip1() {
    $(".frontDB").addClass("d-none");
    $(".backDB").removeClass("d-none");
    $(".backDB").css("transform","");
    $(".backDB").css("backface-visibility","");
}
function flipback1() {
    $(".backDB").addClass("d-none");
    $(".frontDB").removeClass("d-none");
    $(".frontDB").css("transform","");
    $(".frontDB").css("backface-visibility","");
}

<?php }else{ ?>
function flip1() {
    $(".backDB").addClass("d-none");
    $(".frontDB").removeClass("d-none");
    $(".frontDB").css("transform","");
    $(".frontDB").css("backface-visibility","");
}
function flipback1() {
    $(".frontDB").addClass("d-none");
    $(".backDB").removeClass("d-none");
    $(".backDB").css("transform","");
    $(".backDB").css("backface-visibility","");
}
<?php } ?>
</script>
<style>
.fold:before {
content: "";
z-index: 2;
    display: block;
    position: absolute;
    /*top: 0;*/
    bottom: 0;
    right: 0;
    border-width: 25px 25px 0 0;
    border-style: solid;
    border-color: #1976D2 #f0f0f0;
    -webkit-border-top-left-radius: 8px;
    -moz-border-top-left-radius: 8px;
    border-top-left-radius: 8px;
/*    -webkit-box-shadow: 0 0 5px #555;
    -moz-box-shadow: 0 0 5px #555;
    box-shadow: 0 0 5px #555;*/
    -webkit-transition: all .5s ease-in-out;
    -moz-transition: all .5s ease-in-out;
    transition: all .5s ease-in-out
}
</style>
<style>
#search_img {
    position: absolute;
    left: 18px;
    top: 9px;
</style>
<script>
    /*endpoint backup start*/    
$(function(){
        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item:checked:checked").length > 1){
                $('.actionn').hide();
                $('#bulkstopbackup').removeClass('disabled');
                $('#bulkpausebackup').removeClass('disabled');
            }else{
                $('.actionn').show();

                $('#bulkstopbackup').addClass('disabled');
                $('#bulkpausebackup').addClass('disabled');
            }
        });
        //check selected items
        $("input.select-item").click(function () {
            var checked = this.checked;
            checkSelected();
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            all.checked = len===total;
        }
    });
/**endpoint backup end/

/*onedrive backup start*/
$(function(){
        //column checkbox select all or cancel
        $("input.select-all-onedrive").click(function () {
            var checked = this.checked;
            $("input.select-item-onedrive").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item-onedrive:checked:checked").length > 1){
                $('.actionnOnedrive').hide();
                $('#bulkstopbackupOnedrive').removeClass('disabled');
                $('#bulkpausebackupOnedrive').removeClass('disabled');
            }else{
                $('.actionnOnedrive').show();
                $('#bulkstopbackupOnedrive').addClass('disabled');
                $('#bulkpausebackupOnedrive').addClass('disabled');
            }
        });
        //check selected items
        $("input.select-item-onedrive").click(function () {
            var checked = this.checked;
            checkSelectedOnedrive();
        });

        //check is all selected
        function checkSelectedOnedrive() {
            var all = $("input.select-all-onedrive")[0];
            var total = $("input.select-item-onedrive").length;
            var len = $("input.select-item-onedrive:checked:checked").length;
            all.checked = len===total;
        }
    });
/*onedrive backup end*/

/*endpoint restore start*/
$(function(){
        //column checkbox select all or cancel
        $("input.select-all-restore").click(function () {
            var checked = this.checked;
            $("input.select-item-restore").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item-restore:checked:checked").length > 1){
                $('.actionRestore').hide();
                $('#bulkStopRestore').removeClass('disabled');
            }else{
                $('.actionRestore').show();
                $('#bulkStopRestore').addClass('disabled');
            }
        });
        //check selected items
        $("input.select-item-restore").click(function () {
            var checked = this.checked;
            checkSelectedRestore();
        });

        //check is all selected
        function checkSelectedRestore() {
            var all = $("input.select-all-restore")[0];
            var total = $("input.select-item-restore").length;
            var len = $("input.select-item-restore:checked:checked").length;
            all.checked = len===total;
        }
    });
/*endpoint restore end*/

/*onedrive restore start*/
$(function(){
        //column checkbox select all or cancel
        $("input.select-all-restore-onedrive").click(function () {
            var checked = this.checked;
            $("input.select-item-restore-onedrive").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            if($("input.select-item-restore-onedrive:checked:checked").length > 1){
                $('.actionRestoreOnedrive').hide();
                $('#bulkStopRestoreOnedrive').removeClass('disabled');
            }else{
                $('.actionRestoreOnedrive').show();
                $('#bulkStopRestoreOnedrive').addClass('disabled');
            }
        });
        //check selected items
        $("input.select-item-restore-onedrive").click(function () {
            var checked = this.checked;
            checkSelectedRestoreOnedrive();
        });

        //check is all selected
        function checkSelectedRestoreOnedrive() {
            var all = $("input.select-all-restore-onedrive")[0];
            var total = $("input.select-item-restore-onedrive").length;
            var len = $("input.select-item-restore-onedrive:checked:checked").length;
            all.checked = len===total;
        }
    });
/*onedrive restore end*/

    function newone(){
        var len = $("input.select-item:checked:checked").length;
        if(len > 1){
            $('.actionn').hide();
            $('#bulkstopbackup').removeClass('disabled');
            $('#bulkpausebackup').removeClass('disabled');
        }else{
            $('.actionn').show();
            $('#bulkstopbackup').addClass('disabled');
            $('#bulkpausebackup').addClass('disabled');
        }
    }

    function newoneOnedrive(){
        var len = $("input.select-item-onedrive:checked:checked").length;
        if(len > 1){
            $('.actionnOnedrive').hide();
            $('#bulkstopbackupOnedrive').removeClass('disabled');
            $('#bulkpausebackupOnedrive').removeClass('disabled');
        }else{
            $('.actionnOnedrive').show();
            $('#bulkstopbackupOnedrive').addClass('disabled');
            $('#bulkpausebackupOnedrive').addClass('disabled');
        }
    }

    function newRestore(){
        var len = $("input.select-item-restore:checked:checked").length;
        if(len > 1){
            $('.actionRestore').hide();
            $('#bulkStopRestore').removeClass('disabled');
        }else{
            $('.actionRestore').show();
            $('#bulkStopRestore').addClass('disabled');
        }
    }

    function newRestoreOnedrive(){
        var len = $("input.select-item-restore-onedrive:checked:checked").length;
        if(len > 1){
            $('.actionRestoreOnedrive').hide();
            $('#bulkStopRestoreOnedrive').removeClass('disabled');
        }else{
            $('.actionRestoreOnedrive').show();
            $('#bulkStopRestoreOnedrive').addClass('disabled');
        }
    }
</script>
<style>
.card{
background-color: unset;
border: unset;
}
</style>
<script type="text/javascript">
   <?php if($data['popup'] == 'visible') { ?>
        $('#changePasswordForFirstlogin').modal('show');
    <?php } ?>
</script>
<script>
<?php if($data['tile8ReportType'] == 'systemsWithoutBackup'){?>
function flipNP() {
setTimeout(function(){  
    $(".frontNP").addClass("d-none");
    $(".backNP").removeClass("d-none");
    $(".backNP").css("transform","");
    $(".backNP").css("backface-visibility","");
    }, 1000);
}
function flipbackNP() {
setTimeout(function(){  
    $(".backNP").addClass("d-none");
    $(".frontNP").removeClass("d-none");
    $(".frontNP").css("transform","");
    $(".frontNP").css("backface-visibility","");
    }, 1000);
    }
<?php }else{ ?>
function flipNP() {
setTimeout(function(){  
    $(".backNP").addClass("d-none");
    $(".frontNP").removeClass("d-none");
    $(".frontNP").css("transform","");
    $(".frontNP").css("backface-visibility","");
    }, 1000);
}
function flipbackNP() {
setTimeout(function(){
    $(".frontNP").addClass("d-none");
    $(".backNP").removeClass("d-none");
    $(".backNP").css("transform","");
    $(".backNP").css("backface-visibility","");
    }, 1000);
}
<?php } ?>
</script>
