<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <?php if($data['lastLoginTime'] != "nil"){ ?>
        <div class="col-lg-6" style="float:right;margin-top: 5px;">
            <span style="font-size: 12px;float:right;"><?php if($data['lastLoginTime']) { ?>Last Login Time : <?php echo $data['lastLoginTime']; } ?></span>
        </div>
        <?php } ?>
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
        </div>
    </div>
</div>
<div class="main" ng-controller="BackupController">
    <span class="hide currentPage"><?='devices1'?></span>
    <span class="hide userType"><?=$data['userType']?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <span class="hide selectedUser"><?=$data['selectedUser']?></span>
    <span class="hide device_OS"><?=$data['device_OS']?></span>
    <span class="hide view_enable"><?php if(view == false){echo 'false';}else{echo 'true';}?></span>
    <span class="hide disable_download"><?php if(DISABLE_DOWNLOAD == false){echo 'false';}else{echo 'true';}?></span>
    <span class="hide device_type"><?=$data['deviceType']?></span>
    <span class="hide deviceName"><?=$data['deviceName']?></span>
    <span class="hide deviceUserName"><?=$data['deviceUserName']?></span>
    <span class="hide deviceUUID"><?=$data['deviceUUID']?></span>
    <span class="hide isblocked"><?=$data['isblocked']?></span>
    <span class="hide canAdminRestore"><?=$data['canAdminRestore']?></span>
    <span class="hide allowEndUserTocontrolRestore"><?=$data['allowEndUserTocontrolRestore']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav">
                        <li class="listOfDevices"><a style="color: #000 !important;">List of All Devices</a></li>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow">
                <div class="status" style="display: none; text-align: center;">Loading ...</div>
                <div class="table-responsive devicesList" style="display: none;">
                    <table class="table table-striped table-hover files-table">
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Device
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Device Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
<!--                            <th class="clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Last Successfull Backup
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>-->
                            <th class="text-center clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Action
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <?php if(RESTORE_FROM_PORTAL){ ?>
                                    <th>Actions</th>
                                <?php }?>
                            <?php } ?>
                            </tr>
                        </thead>
                        <tbody class="clickAble">
                            <!--<tbody id="selectable"
                               selectable="tr"
                               selectable-list="devices"
                               selectable-out="selected"
                               selectable-options="{filter:'tr'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions1">-->
                        <!--<tr ng-repeat="value in devices | orderBy:sortType:sortReverse" ng-if="value.blocked == 'false'">
                            <td ng-click="openFilesPage(value.id, value.name, value.uuId)" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> {{ value.name }} </td>
                            <td ng-click="openFilesPage(value.id, value.name, value.uuId)" ng-cloak>{{ value.status }}</td>
                            <td ng-click="openFilesPage(value.id, value.name, value.uuId)" ng-cloak>{{ value.createdOn}}</td>
                            <td class="text-center">
                                <a class="hide btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}')?>" style="margin: 5px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
				<a ng-if="value.blocked == 'false' && value.deviceType != 'OUTLOOK' && value.deviceType != 'ONEDRIVE'" ng-click="initiateRestoreForDevice(value.uuId)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Initiate Restore</a>
				<a ng-if="value.blocked == 'false' && value.deviceType == 'OUTLOOK'" ng-click="initiateRestoreForDeviceOutlook(value.uuId)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Initiate Restore</a>
				<a ng-if="value.blocked == 'false' && value.deviceType == 'ONEDRIVE'" ng-click="initiateRestoreForDeviceOnedrive(value.uuId)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Initiate Restore</a>
                                <a ng-if="value.blocked == 'true'">-</a>
                            </td>
                            <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <?php if(RESTORE_FROM_PORTAL){ ?>
                                <td ng-if="value.blocked == 'false'"><a ng-click="initiateRestoreBackup(value.uuId, value.name, $index)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Initiate Restore</a></td>
                                    <td ng-if="value.blocked == 'true'">-</td>
                                <?php }?>
                            <?php } ?>
                        </tr>-->
			<tr ng-repeat="value in devices | orderBy:sortType:sortReverse">
                            <td ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> {{ value.name }} </td>
                            <td ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.status }}</td>
                            <td ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.createdOn}}</td>
                            <td class="text-center">
                                <a class="hide btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}')?>" style="margin: 5px;"><?=Language::show('backup_activity_history', 'keywords');?></a>
				<a ng-if="value.deviceType != 'OUTLOOK' && value.deviceType != 'ONEDRIVE'" ng-click="initiateRestoreForDevice(value.uuId,value.canAdminRestore)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Initiate Restore</a>
				<a ng-if="value.deviceType == 'OUTLOOK'" ng-click="initiateRestoreForDeviceOutlook(value.uuId)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Initiate Restore</a>
				<a ng-if="value.deviceType == 'ONEDRIVE'" ng-click="initiateRestoreForDeviceOnedrive(value.uuId)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Initiate Restore</a>
                            </td>
                            <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <?php if(RESTORE_FROM_PORTAL){ ?>
                                <td><a ng-click="initiateRestoreBackup(value.uuId, value.name, $index)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Initiate Restore</a></td>
                                <?php }?>
                            <?php } ?>
                        </tr>
                        </tbody>
                        </table>
                </div>
            </div>
        </div>
    </div>
<!-- restore for outlook start -->

<!-- restore for outlook device start -->

<div class="modal fade restoreBuckettOutlookDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOutlookDevice"></span>
					</div>
				<div class="settingsDivOutlookDevice">
                                    <div class="col-lg-12">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
					<?php if($data['isAdmin'] == 'true') { ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOutlookDevice">User Id</label>
                                            <select name="searchUsernameOutlookDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookDevice"
                                                    id="searchUsernameOutlookDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
					<?php }else { ?>
					<div class="col-lg-6">
                                            <label for="searchUsernameOutlookDevice">User Id</label>
                                            <select name="searchUsernameOutlookDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookDevice"
                                                    id="searchUsernameOutlookDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
						    <option value="<?=base64_decode($data['userName'])?>"><?=base64_decode($data['userName'])?></option>
                                            </select>
                                        </div>
					<?php } ?>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOutlookDevice" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOutlookDevice form-control" id="searchDeviceNameOutlookDevice" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
				    <input class="hide" type="text" id="uuuOutlookDevice" value=""/>

                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label id="destinationPathlabelOutlookDevice" for="destinationPathOutlookDevice">Enter a Destination Path</label>
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOutlookDevice" id="destinationPathOutlookDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
							<button id="browseOutlookDevice" ng-click="browseOutlookDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1OutlookDevice" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row <?php if($data['mailArchivingEnabled'] != 'true'){?> hide <?php } ?>">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreLinksOutlookDevice"><?=Language::show('Restore Links', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreLinksOutlookDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookDevice"><?=Language::show('In place Restore', 'keywords');?></label>
</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOutlookDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesOutlookDevice"><?=Language::show('Restore Deleted Mails', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesOutlookDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
<label style="margin-top:7px;" for="maxVersionsOutlookDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOutlookDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOutlookDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateOutlookDevice" id="restoreDateOutlookDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOutlookDevice"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOutlookDevice" name="restoreTimeOutlookDevice" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOutlookDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="hide" id="batchIdOutlookDevice"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current item being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
					    <td ng-if="progress.currentFolderPath == ''">-</td>
					    <td>
					    	<div class="progress">
					    		<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
						</div>
					    </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="initiateRestoreOutlookDevice()"  class="btn btn-default initiateRestoreBtnOutlookDevice">Initiate Restore</button>
			<button type="button" ng-click="restoreCancelConfirmOutlookDevice()" class="btn btn-primary cancelRestoreBtnOutlookDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOutlookDevice()" class="btn btn-default normalCancelOutlookDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOutlookDevice()"  class="btn btn-default warningCancelOutlookDevice" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<!--<div class="modal fade restoreEventsExistsOutlookDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">A restore request already exists</h4>
                        </div>
                        <div class="modal-body">
                            <p class="hide"><span id="statementForCompPathOutlook"></span><span id="statementForDesPathOutlook"></span></p>
                            
                            <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>File Path</th>
                                            <th>Destination Path</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>{{ restoreEventsExists.fileElement.fileCompletePath }}</td>
                                            <td ng-if="restoreEventsExists.destinationPath != ''">{{ restoreEventsExists.destinationPath }}</td>
                                            <td ng-if="restoreEventsExists.destinationPath == ''"> - </td>
                                            <td>{{restoreEventsExists.status}}</td>
<td>
                                                <a ng-if="restoreEventsExists.status == 'QUEUE'" ng-click="deleteRestoreOutlook()" class="btn btn-danger btn-small">Cancel Restore</a>
                                            </td>
                                        </tr>
                                        </tbody>
</table>
                                </div>
                                <p><span id="restorealreadyexistsOutlook"></span></p>
                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default closeBtnRestoreBtnForFilesOutlook" data-dismiss="modal" style="display:none;">Close</button>
      <button type="button" ng-click="deleteRestoreOutlook()" class="btn btn-primary cancelRestoreBtnForFilesOutlook" style="display:none;">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>-->
<div class="modal fade restoreWindowConfirmCloseOutlookDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOutlookDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOutlookDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="deleteRestoreOutlookDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOutlookDevice">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="pathOutlookDevice == ''" ng-cloak>/</span><span ng-if="pathOutlookDevice != ''" ng-cloak>{{pathOutlookDevice}}</span>
<div class="col-lg-12">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="backOutlookDevice(pathOutlookDevice)" style="margin:5px;" ng-if="pathOutlookDevice != ''"><i class="fa fa-arrow-left"></i>Back</a>
</br>
                        <div class="table-responsive browsePathDivOutlookDevice">
<span class="noPathOutlookDevice" style="display:none;"> No path available</span>
			<span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOutlookDevice" class="table table-hover table-bordered browsePathOutlookDevice" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOutlookDevice(value, $index)" ng-dblclick="getChildsOutlookDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderOutlookDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOutlookDevice" id="newFolderOutlookDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOutlookDevice()" class="btn btn-default addNewFolderBtnOutlookDevice" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOutlookDevice" ng-click="usePathOutlookDevice(pathOutlookDevice)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for outlook device end -->

<!-- restore for outlook end -->

<!-- restore for onedrive device start -->

<div class="modal fade restoreBuckettOnedriveDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOnedriveDevice"></span>
					</div>
				<div class="settingsDivOnedriveDevice">
                                    <div class="col-lg-12">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
					<?php if($data['isAdmin'] == 'true') { ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOnedriveDevice">User Id</label>
                                            <select name="searchUsernameOnedriveDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOnedriveDevice"
                                                    id="searchUsernameOnedriveDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
					<?php }else { ?>
					<div class="col-lg-6">
                                            <label for="searchUsernameOnedriveDevice">User Id</label>
                                            <select name="searchUsernameOnedriveDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOnedriveDevice"
                                                    id="searchUsernameOnedriveDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
					    	    <option value="<?=base64_decode($data['userName'])?>"><?=base64_decode($data['userName'])?></option>
                                            </select>
                                        </div>
					<?php } ?>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOnedriveDevice" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOnedriveDevice form-control" id="searchDeviceNameOnedriveDevice" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
				    <input class="hide" type="text" id="uuuOnedriveDevice" value=""/>

                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label id="destinationPathlabelOnedriveDevice" for="destinationPathOnedriveDevice">Select a Destination Path</label>
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOnedriveDevice" id="destinationPathOnedriveDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
							<button id="browseOnedriveDevice" ng-click="browseOnedriveDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
<div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1OnedriveDevice" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                        <label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsOnedriveDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row <?php if($data['oneDriveArchivingEnabled'] != 'true'){?> hide <?php } ?>">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreLinksOnedriveDevice"><?=Language::show('Restore Links', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreLinksOnedriveDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('In place Restore', 'keywords');?></label>
</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOnedriveDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
<label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
</div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOnedriveDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOnedriveDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateOnedriveDevice" id="restoreDateOnedriveDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOnedriveDevice"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOnedriveDevice" name="restoreTimeOnedriveDevice" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOnedriveDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="hide" id="batchIdOnedriveDevice"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current file being processed</th>
                                            <th>Overall Progress</th>
					</tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
					    <td ng-if="progress.currentFolderPath == ''">-</td>
					    <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
					    <div class="progress">
					    	<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
						</div>
					     </td>
					     <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="initiateRestoreOnedriveDevice()"  class="btn btn-default initiateRestoreBtnOnedriveDevice">Initiate Restore</button>
			<button type="button" ng-click="restoreCancelConfirmOnedriveDevice()" class="btn btn-primary cancelRestoreBtnOnedriveDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOnedriveDevice()" class="btn btn-default normalCancelOnedriveDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOnedriveDevice()"  class="btn btn-default warningCancelOnedriveDevice" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmCloseOnedriveDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOnedriveDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOnedriveDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>
</div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="deleteRestoreOnedriveDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOnedriveDevice">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="pathOnedriveDevice == ''" ng-cloak>/</span><span ng-if="pathOnedriveDevice != ''" ng-cloak>{{pathOnedriveDevice}}</span>
<div class="col-lg-12">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="backOnedriveDevice(pathOnedriveDevice)" style="margin:5px;" ng-if="pathOnedriveDevice != ''"><i class="fa fa-arrow-left"></i>Back</a>
</br>
                        <div class="table-responsive browsePathDivOnedriveDevice">
<span class="noPathOnedriveDevice" style="display:none;"> No path available</span>
			<span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOnedriveDevice" class="table table-hover table-bordered browsePathOnedriveDevice" style="display: none;">
                                <tbody>
<tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOnedriveDevice(value, $index)" ng-dblclick="getChildsOnedriveDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderOnedriveDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOnedriveDevice" id="newFolderOnedriveDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOnedriveDevice()" class="btn btn-default addNewFolderBtnOnedriveDevice" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOnedriveDevice" ng-click="usePathOnedriveDevice(pathOnedriveDevice)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for Onedrive device end -->
<!-- restore for EndPointDevice start -->
<div class="modal fade restoreBuckettEndPointDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
<!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathEndPointDevice"></span>
					</div>
				<div class="settingsDivEndPointDevice">
                                    <div class="col-lg-12">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
					<?php if($data['isAdmin'] == 'true') { ?>
                                        <div class="col-lg-6">
                                            <label for="searchUsernameEndPointDevice">User Id</label>
                                            <select name="searchUsernameEndPointDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameEndPointDevice"
                                                    id="searchUsernameEndPointDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
					<?php }else { ?>
					<div class="col-lg-6">
                                            <label for="searchUsernameEndPointDevice">User Id</label>
                                            <select name="searchUsernameEndPointDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameEndPointDevice"
                                                    id="searchUsernameEndPointDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! " disabled>
                                                    <option value="<?=base64_decode($data['userName'])?>"><?=base64_decode($data['userName'])?></option>
                                            </select>
                                        </div>
					<?php } ?>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameEndPointDevice" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameEndPointDevice form-control" id="searchDeviceNameEndPointDevice" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
                                    <input class="hide" type="text" id="uuu" value=""/>
				    <input class="hide" type="text" id="uuuOS" value=""/>
                                    <div class="form-group col-lg-12" id="destinationPathEndPointDeviceRow">
                                        <br/>
                                        <label id="destinationPathlabelEndPointDevice" for="destinationPathEndPointDevice">Enter a Destination Path</label>
<input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPathEndPointDevice" id="destinationPathEndPointDevice" placeholder="Enter Destination Path" required/>
                                        <span class="help-block hide">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
				    <!--browse for endpoint start-->
                                    <div class="form-group col-lg-12" id="destinationPathEndPointOnedriveDeviceRow" style="margin-bottom:10px;display:none;">
                                        <br/>
                                        <label for="destinationPathEndPointOnedriveDevice">Select a Destination Path</label>
                                        <div class="col-lg-12 row">
                                                <div class="col-lg-10">
                                                        <input type="text" class="" name="destinationPathEndPointOnedriveDevice" id="destinationPathEndPointOnedriveDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
                                                </div>
                                                <div class="col-lg-2">
                                                        <span class="input-group-btn">
                                                        <button id="browseEndPointOnedriveDevice" ng-click="browseEndPointOnedriveDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
                                                        </span>
                                                </div>
                                        </div>
                                    </div>
                                    <!--browse for endpoint ends-->
                                    <div class="form-group col-lg-12">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
					<div class="form-group col-lg-12 row" id="noOfThreadsRow">
						<label for="noOfThreads">Number of Threads</label>
						<input type="number" class="form-control" style="width: 100%;" id="noOfThreads" min="1" max="6" value="1" placeholder="Enter number of Threads" required/>
					</div>
                                        <div class="col-lg-12 row" id="suspendbackupEndPointDeviceRow">
                                            <div class="col-lg-8">
<label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
						    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackupEndPointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                        <label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsEndPointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row" id="inPlaceRestoreEndPointDeviceRow">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('In place Restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceEndPointDevice" type="checkbox">
                                                <div class="slider round"></div>
						</label>
                                            </div>
                                        </div>
					    <div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesEndPoint"><?=Language::show('Restore Deleted Files', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row" id="overwriteNewerFilesEndPointDeviceRow">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="overwriteNewerFilesEndPoint"><?=Language::show('Overwrite Newer Files', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchoverwriteNewerFilesEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					    <div class="col-lg-12" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
                                                    <label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateEndPointDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateEndPointDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateEndPointDevice" id="restoreDateEndPointDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
</div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTime"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeEndPointDevice" name="restoreTimeEndPointDevice" disabled>
</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressEndPointDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="hide" id="batchIdEndPointDevice"></span>
				    </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
						<tr>
						    <th>Source Path</th>
						    <th>Overall Progress</th>
						    <th>Status</th>
						</tr>
                                        </thead>
                                        <tbody>
                                        <tr>
						<td ng-if="progress.currentFolderPath">{{ progress.currentFolderPath | limitTo:40 }}{{progress.currentFolderPath.length > 40 ? '...' : ''}}</td>
						<td ng-if="!progress.currentFolderPath">-</td>
						<td ng-if="progress.totalRestorePct != ''">
							<div class="progress">
								<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
							</div>
						</td>
						<td ng-if="progress.totalRestorePct == ''">-</td>
					    	<td><span id="statusEndPointDevice"></span></td>
                                        </tr>
                                        </tbody>
                                    </table>
				    <table class="table table-bordered table-striped currentProgressEndPointOneDriveDeviceTable" style="display:none;">
                                        <thead>
                                        <tr>
                                            <th>Current file being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
                                                    <span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
                                                <div class="progress">
                                                        <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
                                                </div>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
			    <button type="submit" ng-click="initiateRestoreEndPointDevice()"  class="btn btn-default initiateRestoreBtnEndPointDevice">Initiate Restore</button>
                        <button type="button" ng-click="restoreCancelConfirmEndPointDevice()" class="btn btn-primary cancelRestoreBtnEndPointDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshEndPointDevice()" class="btn btn-default normalCancelEndPointDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreEndPointDevice()"  class="btn btn-default warningCancelEndPointDevice" style="display:none;">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmCloseEndPointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
<div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
<!--                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnEndPointDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
				</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmEndPointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
    <!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
<button type="button" class="btn btn-default" ng-click="deleteRestoreEndPointDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<!-- restore for EndPointDevice end -->
    <div class="modal fade restoreBucket">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Restore Bucket</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <label for="searchDeviceName">Select a Device to restore on:</label>
                                        <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="restoreAllVersions">Do you want to restore all versions</label>
                                        <select class="form-control selectPicker" name="restoreAllVersions" id="restoreAllVersions" required="">
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="destinationPath">Enter a Destination Path(optional)</label>
                                        <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                        <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)"  class="btn btn-default">Initiate Restore</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/BackupController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchUsernameEndPointDevice').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettEndPointDevice'),
        templateResult: selectTemplateResultEndPointDevice,
        templateSelection: selectTemplateSelectionEndPointDevice,
        placeholder: 'Select user'
    });

    function selectTemplateResultEndPointDevice(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionEndPointDevice(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceEndPoint",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1.length > 0){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID +","+device.osType+ '">' + device.deviceName + '</option>'
});
options += '<option value="OneDrive">My OneDrive</option>';		    
$('.searchDeviceNameEndPointDevice').html(options);
/*xx start*/
if (jData.newone1.length > 0){
$("#uuu").val(jData.newone1[0].deviceUUID);
$("#uuuOS").val(jData.newone1[0].osType);
 var src = $('.device_type').html();
        if(src == 'apple'){
        src = 'mac';
        }
        src = src.substring(0, 3);
	src = src.toLowerCase();
        if(jData.newone1[0].osType){
            var dest = jData.newone1[0].osType;
            dest = dest.substring(0, 3);
            dest = dest.toLowerCase();
                if(src != dest)
                {
                        $('#switchinplaceEndPointDevice').attr('disabled', 'disabled');
                }else{
                        $('#switchinplaceEndPointDevice').removeAttr('disabled');
                }
	}
	$('#destinationPathEndPointDevice').val('');
                $('#destinationPathEndPointDevice').removeAttr('disabled');
                $('#destinationPathlabelEndPointDevice').addClass('star');
                $('#destinationPathEndPointDevice').attr('required', 'required');
                $('#noOfThreads').val('');
                $('#noOfThreads').removeAttr('disabled');
                $('#noOfThreads').addClass('star');
                $('#noOfThreads').attr('required', 'required');
                $('#switchinplaceEndPointDevice').removeAttr('disabled');
                $('#switchoverwriteNewerFilesEndPointDevice').removeAttr('disabled');
                $('#switchsuspendbackupEndPointDevice').removeAttr('disabled');
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style.opacity = "1";
                document.getElementById("suspendbackupEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("suspendbackupEndPointDeviceRow").style.opacity = "1";
                document.getElementById("noOfThreadsRow").style['pointer-events'] = 'unset';
                document.getElementById("noOfThreadsRow").style.opacity = "1";
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style.opacity = "1";
                document.getElementById("destinationPathEndPointDeviceRow").style.display = "block";
                document.getElementById("destinationPathEndPointOnedriveDeviceRow").style.display = "none";
}
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameEndPointDevice').html("<option value='all' selected>User has no devices configured</option>");
		var options = "";
		options += '<option value="OneDrive">My OneDrive</option>'
		$('.searchDeviceNameEndPointDevice').html(options);
                //$('.searchDeviceNameEndPointDevice').attr("readonly", "readonly");
		$("#uuu").val('');
		$("#uuu").val($('.deviceUUID').html());
                $('#destinationPathEndPointDevice').val('');
                $('#destinationPathEndPointDevice').removeAttr('required', 'required');
                $('#destinationPathlabelEndPointDevice').removeClass('star');
                $('#destinationPathEndPointDevice').attr('disabled', true);
                $('#noOfThreads').val('');
                $('#noOfThreads').removeAttr('required', 'required');
                $('#noOfThreads').removeClass('star');
                $('#noOfThreads').attr('disabled', true);
                $('#switchinplaceEndPointDevice').attr('disabled', true);
                $('#switchoverwriteNewerFilesEndPointDevice').attr('disabled', true);
                $('#switchsuspendbackupEndPointDevice').attr('disabled', true);        
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("suspendbackupEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("suspendbackupEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("noOfThreadsRow").style['pointer-events'] = 'none';
                document.getElementById("noOfThreadsRow").style.opacity = "0.5";
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("destinationPathEndPointDeviceRow").style.display = "none";
                document.getElementById("destinationPathEndPointOnedriveDeviceRow").style.display = "block";
	    }
}).fail(function(data){
	    $('.searchDeviceNameEndPointDevice').html("<option value='all' selected>User has no devices configured</option>");
            $('.searchDeviceNameEndPointDevice').attr("readonly", "readonly");
	    $("#uuu").val('');
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameEndPointDevice").change(function () {
	    console.log("inside change"+$('#searchDeviceNameEndPointDevice').val());
	    var ghr = $('#searchDeviceNameEndPointDevice').val();
	    if($('#searchDeviceNameEndPointDevice').val() != 'OneDrive'){
	    var uuid = ghr.split(",")[0];
	    var os = ghr.split(",")[1];
	    console.log("uuid : "+uuid);
	    console.log("os : "+os);
	    $("#uuu").val(uuid);
        $("#uuuOS").val(os);
        var src = $('.device_type').html();
        if(src == 'apple'){
        src = 'mac';
        }
        src = src.substring(0, 3);
	src = src.toLowerCase();
        if(os){
            var dest = os;
            dest = dest.substring(0, 3);
            dest = dest.toLowerCase();
                if(src != dest)
                {
                        $('#switchinplaceEndPointDevice').attr('disabled', 'disabled');
                }else{
                        $('#switchinplaceEndPointDevice').removeAttr('disabled');
                }
        }
	$('#destinationPathEndPointDevice').val('');
                $('#destinationPathEndPointDevice').removeAttr('disabled');
                $('#destinationPathlabelEndPointDevice').addClass('star');
                $('#destinationPathEndPointDevice').attr('required', 'required');
                $('#noOfThreads').val('');
                $('#noOfThreads').removeAttr('disabled');
                $('#noOfThreads').addClass('star');
                $('#noOfThreads').attr('required', 'required');
                $('#switchinplaceEndPointDevice').removeAttr('disabled');
                $('#switchoverwriteNewerFilesEndPointDevice').removeAttr('disabled');
                $('#switchsuspendbackupEndPointDevice').removeAttr('disabled');
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style.opacity = "1";
                document.getElementById("suspendbackupEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("suspendbackupEndPointDeviceRow").style.opacity = "1";
                document.getElementById("noOfThreadsRow").style['pointer-events'] = 'unset';
                document.getElementById("noOfThreadsRow").style.opacity = "1";
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style.opacity = "1";
                document.getElementById("destinationPathEndPointDeviceRow").style.display = "block";
                document.getElementById("destinationPathEndPointOnedriveDeviceRow").style.display = "none";
            }else{
		$("#uuu").val($('.deviceUUID').html());
                $('#destinationPathEndPointDevice').val('');
                $('#destinationPathEndPointDevice').removeAttr('required', 'required');
                $('#destinationPathlabelEndPointDevice').removeClass('star');
                $('#destinationPathEndPointDevice').attr('disabled', true);
                $('#noOfThreads').val('');
                $('#noOfThreads').removeAttr('required', 'required');
                $('#noOfThreads').removeClass('star');
                $('#noOfThreads').attr('disabled', true);
                $('#switchinplaceEndPointDevice').attr('disabled', true);
                $('#switchoverwriteNewerFilesEndPointDevice').attr('disabled', true);
                $('#switchsuspendbackupEndPointDevice').attr('disabled', true);        
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("suspendbackupEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("suspendbackupEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("noOfThreadsRow").style['pointer-events'] = 'none';
                document.getElementById("noOfThreadsRow").style.opacity = "0.5";
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("destinationPathEndPointDeviceRow").style.display = "none";
                document.getElementById("destinationPathEndPointOnedriveDeviceRow").style.display = "block";            
            }

    });
</script>
<script>
    $('.searchUsernameOutlookDevice').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOutlookDevice'),
        templateResult: selectTemplateResultOutlookDevice,
        templateSelection: selectTemplateSelectionOutlookDevice,
        placeholder: 'Select user'
    });

    function selectTemplateResultOutlookDevice(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOutlookDevice(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOutlook",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOutlookDevice').html(options);
/*xx start*/
$("#uuuOutlookDevice").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOutlookDevice').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOutlookDevice').attr("readonly", "readonly");
		$("#uuuOutlookDevice").val('');
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOutlookDevice").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOutlookDevice').val());
	    var uuid = $('#searchDeviceNameOutlookDevice').val();	    
	    $("#uuuOutlookDevice").val(uuid);        

    });
</script>
<script>
    $('.searchUsernameOnedriveDevice').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOnedriveDevice'),
        templateResult: selectTemplateResultOnedriveDevice,
        templateSelection: selectTemplateSelectionOnedriveDevice,
        placeholder: 'Select user'
    });

    function selectTemplateResultOnedriveDevice(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOnedriveDevice(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOnedrive",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOnedriveDevice').html(options);
/*xx start*/
$("#uuuOnedriveDevice").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOnedriveDevice').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOnedriveDevice').attr("readonly", "readonly");
		$("#uuuOnedriveDevice").val('');
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOnedriveDevice").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOnedriveDevice').val());
	    var uuid = $('#searchDeviceNameOnedriveDevice').val();	    
	    $("#uuuOnedriveDevice").val(uuid);        

    });
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}
.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
$("#switchDate").click(function(){
        if ($(this).is(':checked')) {
$('#restoreDate').removeAttr('disabled');
$('#restoreTime').removeAttr('disabled');

    } else {

        $('#restoreDate').attr('disabled', true); //disable input
$('#restoreTime').attr('disabled', true);
    }
        });


$("#switchinplace").click(function(){
        if ($(this).is(':checked')) {
$('#destinationPath').val('');
$('#destinationPath').removeAttr('required', 'required');
$('#destinationPathlabel').removeClass('star');
$('#destinationPath').attr('disabled', true);        
    } else {
    $('#destinationPath').val('');
$('#destinationPath').removeAttr('disabled');
$('#destinationPathlabel').addClass('star');
$('#destinationPath').attr('required', 'required');
    }
        });

$('.timePicker').timepicker({
        showMeridian: false,
        //defaultTime: '12:00'
    });

$('.restoreDate').datepicker({
//        format: 'dd-mm-yyyy',
//dateFormat: "d M,y",
format: 'dd-M-yyyy',
        autoclose: true,
        // defaultDate: new Date() ,
//        startDate: '-0d',
  //      endDate: '+1y',
        todayHighlight: true
    }).attr('readonly', 'readonly');

$(".restoreDate").datepicker().datepicker("setDate", new Date());
</script>

<script>
$('.restoreDateOutlookDevice').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
	container:'.restoreBuckettOutlookDevice'
    }).attr('readonly', 'readonly');

$(".restoreDateOutlookDevice").datepicker().datepicker("setDate", new Date());

$("#switchDateOutlookDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateOutlookDevice').removeAttr('disabled');
        $('#restoreTimeOutlookDevice').removeAttr('disabled');
    } else {
        $('#restoreDateOutlookDevice').attr('disabled', true); //disable input
        $('#restoreTimeOutlookDevice').attr('disabled', true);
    }
});


$("#switchinplaceOutlookDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathOutlookDevice').val('');
        $('#destinationPathOutlookDevice').removeAttr('required', 'required');
        $('#destinationPathlabelOutlookDevice').removeClass('star');
        $('#destinationPathOutlookDevice').attr('disabled', true);
	$('#browseOutlookDevice').attr('disabled', true);
    } else {
        $('#destinationPathOutlookDevice').val('');
        $('#destinationPathOutlookDevice').removeAttr('disabled');
        $('#destinationPathlabelOutlookDevice').addClass('star');
        $('#destinationPathOutlookDevice').attr('required', 'required');
	$('#browseOutlookDevice').removeAttr('disabled');
    }
});
</script>

<script>
$('.restoreDateOnedriveDevice').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
	container:'.restoreBuckettOnedriveDevice'
    }).attr('readonly', 'readonly');

$(".restoreDateOnedriveDevice").datepicker().datepicker("setDate", new Date());

$("#switchDateOnedriveDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateOnedriveDevice').removeAttr('disabled');
        $('#restoreTimeOnedriveDevice').removeAttr('disabled');
    } else {
        $('#restoreDateOnedriveDevice').attr('disabled', true); //disable input
        $('#restoreTimeOnedriveDevice').attr('disabled', true);
    }
});


$("#switchinplaceOnedriveDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathOnedriveDevice').val('');
        $('#destinationPathOnedriveDevice').removeAttr('required', 'required');
        $('#destinationPathlabelOnedriveDevice').removeClass('star');
        $('#destinationPathOnedriveDevice').attr('disabled', true);
	$('#browseOnedriveDevice').attr('disabled', true);
    } else {
        $('#destinationPathOnedriveDevice').val('');
        $('#destinationPathOnedriveDevice').removeAttr('disabled');
        $('#destinationPathlabelOnedriveDevice').addClass('star');
        $('#destinationPathOnedriveDevice').attr('required', 'required');
	$('#browseOnedriveDevice').removeAttr('disabled');
    }
});
</script>
<style>
.selected td{
background: #f27331 !important;
/*    background-color:black;
    color:white;
    font-weight:bold;*/
}
td:nth-child(2) {
white-space: unset !important;
}	
</style>
<script>
$('.restoreDateEndPointDevice').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
	container:'.restoreBuckettEndPointDevice'
    }).attr('readonly', 'readonly');

$(".restoreDateEndPointDevice").datepicker().datepicker("setDate", new Date());

$("#switchDateEndPointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateEndPointDevice').removeAttr('disabled');
        $('#restoreTimeEndPointDevice').removeAttr('disabled');
    } else {
        $('#restoreDateEndPointDevice').attr('disabled', true); //disable input
        $('#restoreTimeEndPointDevice').attr('disabled', true);
    }
});


$("#switchinplaceEndPointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathEndPointDevice').val('');
        $('#destinationPathEndPointDevice').removeAttr('required', 'required');
        $('#destinationPathlabelEndPointDevice').removeClass('star');
        $('#destinationPathEndPointDevice').attr('disabled', true);
    } else {
        $('#destinationPathEndPointDevice').val('');
        $('#destinationPathEndPointDevice').removeAttr('disabled');
        $('#destinationPathlabelEndPointDevice').addClass('star');
        $('#destinationPathEndPointDevice').attr('required', 'required');
    }
});
</script>
