<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use DOMDocument;
use Helpers\Url;
use Models\Index;
use Helpers\Auth;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class IndexController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->auth->tokenCheck();
        $this->language->load('index');
        $this->_model = new Index();
        if(Auth::checkUserPermission('readOnlyAdmin') == false){
            Url::redirect('myAccount');
        }
    }

    /**
     * Define Index page title and load template files
     */
    public function index() {
        /*if(Auth::checkCloudPermission('sync') == false && (Auth::checkCloudPermission('backup') == false && Auth::checkCloudPermission('serverBackup') == true)){
            Url::redirect('server/dashboard');
        }elseif(Auth::checkCloudPermission('sync') == true && (Auth::checkCloudPermission('backup') == false && Auth::checkCloudPermission('serverBackup') == false)){
            Url::redirect('sync/files');
        }*/
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }
        $data = array(
            'csrf_token' => $this->setCSRFToken(),
            'onedriveBkpEnabled' => $onedriveBkpEnabled,
            'loggedInUser' => $this->session->all()
        );
        $data['title'] = $this->language->get('indexPageName');
        $data['subPageName'] = $this->language->get('indexPage_message');
        $data['active'] = 'home';
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );
        $data['showBackupOverview'] = true;
        $data['showBackupHistory'] = true;
        $data['showFailedBackupHistory'] = true;
        $data['showSystemsWithoutBackups'] = true;
        $data['showRestoreHistory'] = true;
        $data['showStorageUtilizationReport'] = true;
        $data['showDeviceHeartbeatReport'] = true;
        $data['showUserBackupSummary'] = true;
	$data['tile8ReportType'] = 'systemsWithoutBackup';
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $data['hideCompressedSize'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'hideCompressedSize'};
        $data['showBackupOverview'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showBackupOverview'};
        $data['showBackupHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showBackupHistory'};
        $data['showFailedBackupHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showFailedBackupHistory'};
        $data['showSystemsWithoutBackups'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showSystemsWithoutBackups'};
        $data['showRestoreHistory'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showRestoreHistory'};
        $data['showStorageUtilizationReport'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showStorageUtilizationReport'};
        $data['showDeviceHeartbeatReport'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showDeviceHeartbeatReport'};
        $data['showUserBackupSummary'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showUserBackupSummary'};
        $data['showCurrentlyRunningReports'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showCurrentlyRunningReports'};
	$data['showSupportPage'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'showSupportPage'};
	$this->session->put('showSupportPage',$data['showSupportPage']);
	$showAuditHistory = $cloudProperties['body']->{'cloudPropertyElement'}->{'showAuditHistory'};
        $this->session->put('showAuditHistory',$showAuditHistory);
	$data['tile8ReportType'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'tile8ReportType'};
        $data['flipNotProtectedTile'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'flipNotProtectedTile'};
	    
	if($this->session->get('admin') == true){
        	$this->session->put('showAuditHistory',true);
        }else if($this->session->get('readOnlyAdmin') == true){
		$this->session->put('showAuditHistory',$showAuditHistory);
        }else{
                $this->session->put('showAuditHistory',true);
        }	    
	    
        if($this->session->get('lastLoggedInTime') != ""){
	    $data['time'] = date('d-M-Y H:i:s', ((int)$this->session->get('lastLoggedInTime')/1000));
        }
        if($this->session->get('admin') == true){
        $data['isAdmin'] = 'true';
        }
        
        $data['stopPauseAccess'] = 'true';
        if($this->session->get('readOnlyAdmin') == true){
            if($cloudProperties['body']->{'cloudPropertyElement'}->{'stopPauseAccess'} == true){
                $data['stopPauseAccess'] = 'true';
            }else{
                $data['stopPauseAccess'] = 'false';
            }
            $this->log("inside read only admin true","info");
            if($cloudProperties['body']->{'cloudPropertyElement'}->{'hideDashboard'} == true){
                $this->log("inside hide dash true","info");
                $data['isAdmin'] = 'false';
            }else{
                $this->log("inside hide dash false","info");
                $data['isAdmin'] = 'true';
            }
        }
        
        if($this->session->get('downloadAgent') == 'true'){
            $data['downloadAgent'] = 'true';
        }else{
            $data['downloadAgent'] = 'false';
        }
	if($this->session->get('firstLogin1') == "true" && $this->session->get('localUser') == '1'){
                $visible = 'visible';
	}
	$data['popup'] = $visible;
	$data['activeTabB'] = '';
	$data['activeTabS'] = '';
	$data['activeTabO'] = '';
	$data['session_cok'] = $_COOKIE['PARABLU_INC'];
	if(Auth::checkCloudPermission('backup') == true){
        	$data['activeTabB'] = 'active';
	}else if(Auth::checkCloudPermission('backup') == false){
        	if(Auth::checkCloudPermission('sync') == true){
                	$data['activeTabS'] = 'active';
        	}else{
                	$data['activeTabO'] = 'active';
        	}
	}
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('index/index', $data);
        View::renderTemplate('footer', $data);
    }

    /**
     * Define Index page title and load template files
     */
    public function serverBackup() {
        $data = array(
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        $data['title'] = $this->language->get('indexPageName');
        $data['subPageName'] = $this->language->get('indexPage_message');
        $data['active'] = 'home';

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('index/serverBackup', $data);
        View::renderTemplate('footer', $data);
    }
}
