#!/bin/bash
# DEVELOPER: Vaibhav K
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
PARABLU_COMPONENT_CONFIG_SCRIPT_PATH=../config/parablu_component_config.sh
source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_CONFIG_SCRIPT_PATH
export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"

BACKBLAZE_ID="43fee37666d9"
APPLICATION_KEY="0000ff2f122c153ff3c564ee8d1d8f604f03b44412"
BACKBLAZE_BUCKET="CUST-Mongodbbackups"
dbport=$(grep port: /etc/mongod.conf)
MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
MONGO_ENCRYPTED_FILE="nightlyrestart"


function get_cust_name ()
{
#        custname=$(grep "CUSTOMER_NAME=" /var/lib/parablusys/bin/scripts/mongo_full_backup.sh)
 #       CUSTOMER_NAME=$(echo $custname | tr -d ' ' | sed -e 's/CUSTOMER_NAME=//' | sed 's/"//g')

        echo 'use parablu001

db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_CUSTNAME=" +e.customer_name)})' >plog_mongoproperties.js

        cp plog_mongoproperties.js plog_mongoproperties_install.js
        sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < plog_mongoproperties_install.js > plog_mongo_properties

        CUSTOMER_NAME_VAL=$(grep "P_CUSTNAME" plog_mongo_properties | sed -e 's/P_CUSTNAME=//')

        if [ "$CUSTOMER_NAME_VAL" == "undefined" ]; then

                CUSTOMER_NAME=$CLOUD_NAME

        elif [ ! -z "$CUSTOMER_NAME_VAL" ]; then

                CUSTOMER_NAME=$CUSTOMER_NAME_VAL

        else

                CUSTOMER_NAME=$CLOUD_NAME

        fi



        backblaze-b2 ls $BACKBLAZE_BUCKET $CUSTOMER_NAME | grep -oh $MONGO_ENCRYPTED_FILE
        if [ $? -eq 0 ]; then
                echo "File exists"
                #GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $CUSTOMER_NAME  | grep nightlyrestart | awk '{print $1}' | head -1`
                GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $CUSTOMER_NAME  | grep $MONGO_ENCRYPTED_FILE | awk '{print $1}' | head -1`
                 backblaze-b2 delete-file-version $MONGO_ENCRYPTED_FILEw  $GET_FILE_VERSION
                   #backblaze-b2 delete-file-version $BACKBLAZE_BUCKET $MONGO_ENCRYPTED_FILE $CLOUD_NAME/$MONGO_ENCRYPTED_FILE
        fi

        backblaze-b2 authorize-account 43fee37666d9 0000ff2f122c153ff3c564ee8d1d8f604f03b44412
        touch nightlyrestart
        backblaze-b2 upload-file  $BACKBLAZE_BUCKET $MONGO_ENCRYPTED_FILE $CLOUD_NAME/$MONGO_ENCRYPTED_FILE

				TIMESTAMP=`date`
                                	echo 'use parablu001
                                        	db.MONGO_PROPERTIES.update({},{$set:{"lastsucessfulnightlyrestarttime":"TIME_STAMP"}})' > lastbackup.js
                                        	sed -i "s|TIME_STAMP|$TIMESTAMP|" lastbackup.js

                                 if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "3" ]] || [[ "$SERVER_TYPE" == "3 1" ]]; then
                                         dbport=$(grep port: /etc/mongod.conf)
                                        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
                                         sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < lastbackup.js
                                fi
}

function service_stop_status ()
{

if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] || [[ "$SERVER_TYPE" == "2" ]];then 
	dbport=$(grep port: /etc/mongod.conf)
        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
        echo 'use parablu001

db.PRIVACY_GATEWAY.find({"gatewayName" : "GATEWAY_NAME"}).forEach(function(e) {print("SERVICESTOP=" +e.isActive)})' >capture_servicestop.js

        sed -i "s|GATEWAY_NAME|$BLUKRYPT_IP|g" capture_servicestop.js

        sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < capture_servicestop.js > capture_servicestop

        SERVICESTOP=`grep "SERVICESTOP" capture_servicestop`
        BK_ACTIVE=$( echo $SERVICESTOP | sed -e 's/SERVICESTOP=//')

else
        BK_ACTIVE=true
fi

} 

function get_support_mail ()
{

unset MAILARRAY
echo 'use parablu
db.CLOUD_PROPERTIES.find({}).forEach(function(e){print("SUPPORT_MAIL=" +e.supportMail)})' > supportmailids.js

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < supportmailids.js >supportmailid.log

        WATCHDOG_MAIL_ADDRESS=`grep "SUPPORT_MAIL" supportmailid.log | sed -e 's/SUPPORT_MAIL=//' | sed -e 's/,/\ /g'`

        if [[ -z $WATCHDOG_MAIL_ADDRESS ]]; then

                WATCHDOG_MAIL_ADDRESS="support@parablu.com"
        fi
for mail_id in ${WATCHDOG_MAIL_ADDRESS[@]}
                do
                        MAILARRAY+=({\"email\":\"$mail_id\"},)
        done


        tempids=$(echo -e "${MAILARRAY[*]}")
        get_mail_id=$(echo $tempids | sed -e 's/.$//')


}

function send_backupsuceed_alert ()
{

        ##Get mail ids
        get_support_mail
        #get_adminmail_id

        MSG_SUBJECT="ALERT: NIGHTLY RESTART SUCCEDED  [$CLOUD_NAME] Machine `hostname` at `date`"
        MSG_BODY="NIGHTLY RESTART"
        if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3 1" ]; then

                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/

        fi


}

service_stop_status

echo "-------------------BEGIN `date`-------------------"

if [ "$BK_ACTIVE" == "true" ]; then

echo 'y' | bash service-parablu.sh stop
sleep 45s
echo 'y' | bash service-parablu.sh stop
sleep 15s
if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] ;then
        get_cust_name
fi
sync; echo 3 > /proc/sys/vm/drop_caches
sleep 10s
echo 'y' | bash service-parablu.sh start
get_support_mail
sleep 2s
send_backupsuceed_alert

sleep 3m

        count=1
        until [ $count -ge 3 ]
        do
		if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] || [[ "$SERVER_TYPE" == "2" ]];then
			echo "TRYING TO  PING BLUKRYPTBUILDER...............[`date`]"
        		call_bkapi=`curl -k /dev/null --max-time 300 --silent --get --write-out '%{http_code}\n'  https://$BLUKRYPT_IP/BluKryptBuilder/ping/`
	        	echo "$call_bkapi" | grep 200
	        	if [ $? -ne 0 ]; then
        	        	restartflag=true
	        	        echo "BLUKRYPTBUILDER IS NOT PINGING..!!!"
	        	else
		            echo "BLUKRYPTBUILDER IS PINGING..!!!"
        		fi
		fi

		if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] || [[ "$SERVER_TYPE" == "1" ]] || [[ "$SERVER_TYPE" == "3 1" ]];then

			echo "TRYING TO  PING PARACLOUD...............[`date`]"
        		call_paracloudPing=`curl -k /dev/null --max-time 120 --silent --get --write-out '%{http_code}\n'  https://$BLUVAULT_IP/paracloud/ping/`
	        	echo "$call_paracloudPing" | grep 400
	        	if [ $? -ne 0 ]; then
		              restartflag=true
        		      echo "PARACLOUD IS NOT PINGING"
		        else
        		      echo "PARACLOUD IS PINGING"
	        	fi
		fi

	#        echo "RESTART FLAG IS:$restartflag"


        	if [ "$restartflag" == "true" ]; then
			sleep 3s
			echo "RETRYING.......[$count] [`date`]"
        	        echo 'y' | bash service-parablu.sh stop
                	sleep 10s
	                sync; echo 3 > /proc/sys/vm/drop_caches
        	        sleep 10s
                	echo 'y' | bash service-parablu.sh start
	        else
        	        break
	        fi
        	count=$[$count+1]
	        sleep 5s
		restartflag=''
        done

else

        echo "BLUKRYPT DISABLED. NOT RUNNING RESTART SCRIPT"    
fi
echo "-----------------------------------END `date`--------------------------"
