/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query.validation;

import java.util.List;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.validation.CollectionTypeValidator;
import org.mongodb.morphia.query.validation.OperationValidator;
import org.mongodb.morphia.query.validation.ValidationFailure;

public final class InOperationValidator
extends OperationValidator {
    private static final InOperationValidator INSTANCE = new InOperationValidator();

    private InOperationValidator() {
    }

    public static InOperationValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.IN;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (value == null) {
            validationFailures.add(new ValidationFailure(String.format("For an $in operation, value cannot be null.", new Object[0])));
        } else if (!CollectionTypeValidator.typeIsIterableOrArrayOrMap(value.getClass())) {
            validationFailures.add(new ValidationFailure(String.format("For a $in operation, value '%s' should be a List or array or Map. Instead it was a: %s", value, value.getClass())));
        }
    }
}

