/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query.validation;

import java.util.List;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.query.validation.ValidationFailure;
import org.mongodb.morphia.query.validation.Validator;

public final class EntityTypeAndIdValueValidator
implements Validator {
    private static final EntityTypeAndIdValueValidator INSTANCE = new EntityTypeAndIdValueValidator();

    private EntityTypeAndIdValueValidator() {
    }

    public static EntityTypeAndIdValueValidator getInstance() {
        return INSTANCE;
    }

    public boolean apply(MappedClass mappedClass, MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (this.appliesTo(mappedClass, mappedField)) {
            Class<?> classOfValue = value.getClass();
            Class classOfIdFieldForType = mappedClass.getMappedIdField().getConcreteType();
            if (!mappedField.getType().equals(classOfValue) && !classOfValue.equals(classOfIdFieldForType)) {
                validationFailures.add(new ValidationFailure(String.format("The value class needs to match the type of ID for the field. Value was %s and was a %s and the ID of the type was %s", value, classOfValue, classOfIdFieldForType)));
            }
            return true;
        }
        return false;
    }

    private boolean appliesTo(MappedClass mappedClass, MappedField mappedField) {
        return mappedField != null && mappedField.equals(mappedClass.getMappedIdField());
    }
}

