/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.mongodb.morphia.geo.CoordinateReferenceSystem;
import org.mongodb.morphia.geo.Geometry;
import org.mongodb.morphia.geo.MultiPolygon;
import org.mongodb.morphia.geo.Point;
import org.mongodb.morphia.geo.Polygon;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.query.CriteriaContainerImpl;
import org.mongodb.morphia.query.FieldCriteria;
import org.mongodb.morphia.query.FieldEnd;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.GeoFieldCriteria;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryException;
import org.mongodb.morphia.query.QueryImpl;
import org.mongodb.morphia.query.Shape;
import org.mongodb.morphia.query.StandardGeoFieldCriteria;
import org.mongodb.morphia.query.Type;
import org.mongodb.morphia.utils.Assert;

public class FieldEndImpl<T extends CriteriaContainerImpl>
implements FieldEnd<T> {
    private static final Logger LOG = MorphiaLoggerFactory.get(FieldEndImpl.class);
    private final QueryImpl<?> query;
    private final String field;
    private final T target;
    private boolean not = false;

    public FieldEndImpl(QueryImpl<?> query, String field, T target) {
        this.query = query;
        this.field = field;
        this.target = target;
    }

    @Override
    public T contains(String string) {
        Assert.parametersNotNull("val", string);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile(string));
    }

    @Override
    public T containsIgnoreCase(String string) {
        Assert.parametersNotNull("val", string);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile(string, 2));
    }

    @Override
    public T doesNotExist() {
        return this.addCriteria(FilterOperator.EXISTS, false);
    }

    @Override
    public T endsWith(String suffix) {
        Assert.parametersNotNull("val", suffix);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile(suffix + "$"));
    }

    @Override
    public T endsWithIgnoreCase(String suffix) {
        Assert.parametersNotNull("val", suffix);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile(suffix + "$", 2));
    }

    @Override
    public T equal(Object val) {
        return this.addCriteria(FilterOperator.EQUAL, val);
    }

    @Override
    public T equalIgnoreCase(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile("^" + val + "$", 2));
    }

    @Override
    public T exists() {
        return this.addCriteria(FilterOperator.EXISTS, true);
    }

    @Override
    public T greaterThan(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.GREATER_THAN, val);
    }

    @Override
    public T greaterThanOrEq(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.GREATER_THAN_OR_EQUAL, val);
    }

    @Override
    public T hasAllOf(Iterable<?> values) {
        Assert.parametersNotNull("values", values);
        Assert.parameterNotEmpty("values", values);
        return this.addCriteria(FilterOperator.ALL, values);
    }

    @Override
    public T hasAnyOf(Iterable<?> values) {
        Assert.parametersNotNull("values", values);
        if (LOG.isWarningEnabled() && !values.iterator().hasNext()) {
            LOG.warning("Specified an empty list/collection with the '" + this.field + "' criteria");
        }
        return this.addCriteria(FilterOperator.IN, values);
    }

    @Override
    public T hasNoneOf(Iterable<?> values) {
        Assert.parametersNotNull("values", values);
        Assert.parameterNotEmpty("values", values);
        return this.addCriteria(FilterOperator.NOT_IN, values);
    }

    @Override
    @Deprecated
    public T doesNotHaveThisElement(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.ELEMENT_MATCH, val, true);
    }

    @Override
    @Deprecated
    public T hasThisElement(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.ELEMENT_MATCH, val, this.not);
    }

    @Override
    public T elemMatch(Query query) {
        Assert.parametersNotNull("query", query);
        return this.addCriteria(FilterOperator.ELEMENT_MATCH, query, this.not);
    }

    @Override
    public T hasThisOne(Object val) {
        return this.addCriteria(FilterOperator.EQUAL, val);
    }

    @Override
    public T in(Iterable<?> values) {
        return (T)this.hasAnyOf((Iterable)values);
    }

    @Override
    public T intersects(Geometry geometry) {
        ((CriteriaContainerImpl)this.target).add(new StandardGeoFieldCriteria(this.query, this.field, FilterOperator.INTERSECTS, geometry, null));
        return this.target;
    }

    @Override
    public T intersects(Geometry geometry, CoordinateReferenceSystem crs) {
        ((CriteriaContainerImpl)this.target).add(new StandardGeoFieldCriteria(this.query, this.field, FilterOperator.INTERSECTS, geometry, null, crs));
        return this.target;
    }

    @Override
    public T lessThan(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.LESS_THAN, val);
    }

    @Override
    public T lessThanOrEq(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.LESS_THAN_OR_EQUAL, val);
    }

    @Override
    public T mod(long divisor, long remainder) {
        return this.addCriteria(FilterOperator.MOD, new long[]{divisor, remainder});
    }

    @Override
    public T near(double longitude, double latitude) {
        return (T)this.near(longitude, latitude, false);
    }

    @Override
    public T near(double longitude, double latitude, boolean spherical) {
        return this.addGeoCriteria(spherical ? FilterOperator.NEAR_SPHERE : FilterOperator.NEAR, new double[]{longitude, latitude}, null);
    }

    @Override
    public T near(double longitude, double latitude, double radius) {
        return (T)this.near(longitude, latitude, radius, false);
    }

    @Override
    public T near(double longitude, double latitude, double radius, boolean spherical) {
        return this.addGeoCriteria(spherical ? FilterOperator.NEAR_SPHERE : FilterOperator.NEAR, new double[]{longitude, latitude}, this.opts("$maxDistance", radius));
    }

    @Override
    public T near(Point point, int maxDistance) {
        ((CriteriaContainerImpl)this.target).add(new StandardGeoFieldCriteria(this.query, this.field, FilterOperator.NEAR, point, maxDistance));
        return this.target;
    }

    @Override
    public T near(Point point) {
        ((CriteriaContainerImpl)this.target).add(new StandardGeoFieldCriteria(this.query, this.field, FilterOperator.NEAR, point, null));
        return this.target;
    }

    @Override
    public FieldEnd<T> not() {
        this.not = !this.not;
        return this;
    }

    @Override
    public T notEqual(Object val) {
        return this.addCriteria(FilterOperator.NOT_EQUAL, val);
    }

    @Override
    public T notIn(Iterable<?> values) {
        return (T)this.hasNoneOf((Iterable)values);
    }

    @Override
    public T sizeEq(int val) {
        return this.addCriteria(FilterOperator.SIZE, val);
    }

    @Override
    public T startsWith(String prefix) {
        Assert.parametersNotNull("val", prefix);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile("^" + prefix));
    }

    @Override
    public T startsWithIgnoreCase(String prefix) {
        Assert.parametersNotNull("val", prefix);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile("^" + prefix, 2));
    }

    @Override
    public T type(Type type) {
        return this.addCriteria(FilterOperator.TYPE, type.val());
    }

    @Override
    public T within(Shape shape) {
        Assert.parametersNotNull("shape", shape);
        return this.addCriteria(FilterOperator.GEO_WITHIN, shape.toDBObject());
    }

    @Override
    public T within(Polygon boundary) {
        ((CriteriaContainerImpl)this.target).add(new StandardGeoFieldCriteria(this.query, this.field, FilterOperator.GEO_WITHIN, boundary, null));
        return this.target;
    }

    @Override
    public T within(MultiPolygon boundaries) {
        ((CriteriaContainerImpl)this.target).add(new StandardGeoFieldCriteria(this.query, this.field, FilterOperator.GEO_WITHIN, boundaries, null));
        return this.target;
    }

    @Override
    public T within(Polygon boundary, CoordinateReferenceSystem crs) {
        ((CriteriaContainerImpl)this.target).add(new StandardGeoFieldCriteria(this.query, this.field, FilterOperator.GEO_WITHIN, boundary, null, crs));
        return this.target;
    }

    @Override
    public T within(MultiPolygon boundaries, CoordinateReferenceSystem crs) {
        ((CriteriaContainerImpl)this.target).add(new StandardGeoFieldCriteria(this.query, this.field, FilterOperator.GEO_WITHIN, boundaries, null, crs));
        return this.target;
    }

    private T addCriteria(FilterOperator op, Object val) {
        return this.addCriteria(op, val, this.not);
    }

    private T addCriteria(FilterOperator op, Object val, boolean not) {
        ((CriteriaContainerImpl)this.target).add(new FieldCriteria(this.query, this.field, op, val, not));
        return this.target;
    }

    private T addGeoCriteria(FilterOperator op, Object val, Map<String, Object> opts) {
        if (this.not) {
            throw new QueryException("Geospatial queries cannot be negated with 'not'.");
        }
        ((CriteriaContainerImpl)this.target).add(new GeoFieldCriteria(this.query, this.field, op, val, opts));
        return this.target;
    }

    private Map<String, Object> opts(String s, Object v) {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put(s, v);
        return opts;
    }
}

