/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.fieldrules;

import java.util.Set;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Serialized;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.mapping.validation.fieldrules.FieldConstraint;
import org.mongodb.morphia.utils.ReflectionUtils;

public class MapKeyDifferentFromString
extends FieldConstraint {
    private static final String SUPPORTED = "(Map<String/Enum/Long/ObjectId/..., ?>)";

    @Override
    protected void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.isMap() && !mf.hasAnnotation(Serialized.class)) {
            Class aClass = ReflectionUtils.getParameterizedClass(mf.getField(), 0);
            if (aClass == null || Object.class.equals((Object)aClass)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.WARNING, mc, mf, this.getClass(), "Maps cannot be keyed by Object (Map<Object,?>); Use a parametrized type that is supported (Map<String/Enum/Long/ObjectId/..., ?>)"));
            } else if (!(aClass.equals(String.class) || aClass.equals(ObjectId.class) || ReflectionUtils.isPrimitiveLike(aClass))) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "Maps must be keyed by a simple type (Map<String/Enum/Long/ObjectId/..., ?>); " + aClass + " is not supported as a map key type."));
            }
        }
    }
}

