/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping;

import com.mongodb.DBObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mongodb.morphia.EntityInterceptor;
import org.mongodb.morphia.annotations.Converters;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.EntityListeners;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.IndexOptions;
import org.mongodb.morphia.annotations.Indexes;
import org.mongodb.morphia.annotations.PostLoad;
import org.mongodb.morphia.annotations.PostPersist;
import org.mongodb.morphia.annotations.PreLoad;
import org.mongodb.morphia.annotations.PrePersist;
import org.mongodb.morphia.annotations.PreSave;
import org.mongodb.morphia.annotations.Property;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.annotations.Serialized;
import org.mongodb.morphia.annotations.Transient;
import org.mongodb.morphia.annotations.Validation;
import org.mongodb.morphia.annotations.Version;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MapperOptions;
import org.mongodb.morphia.mapping.MappingException;
import org.mongodb.morphia.mapping.validation.MappingValidator;
import org.mongodb.morphia.utils.ReflectionUtils;

public class MappedClass {
    private static final Logger LOG = MorphiaLoggerFactory.get(MappedClass.class);
    private static final List<Class<? extends Annotation>> INTERESTING_ANNOTATIONS = new ArrayList<Class<? extends Annotation>>();
    private static final List<Class<? extends Annotation>> LIFECYCLE_ANNOTATIONS = Arrays.asList(PrePersist.class, PreSave.class, PreLoad.class, PostPersist.class, PostLoad.class);
    private final Map<Class<? extends Annotation>, List<Annotation>> foundAnnotations = new HashMap<Class<? extends Annotation>, List<Annotation>>();
    private final Map<Class<? extends Annotation>, List<ClassMethodPair>> lifecycleMethods = new HashMap<Class<? extends Annotation>, List<ClassMethodPair>>();
    private final List<MappedField> persistenceFields = new ArrayList<MappedField>();
    private final Class<?> clazz;
    private Field idField;
    private Entity entityAn;
    private Embedded embeddedAn;
    private MapperOptions mapperOptions;
    private MappedClass superClass;
    private List<MappedClass> interfaces = new ArrayList<MappedClass>();

    public MappedClass(Class<?> clazz, Mapper mapper) {
        this.clazz = clazz;
        this.mapperOptions = mapper.getOptions();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating MappedClass for " + clazz);
        }
        this.basicValidate();
        this.discover(mapper);
        if (LOG.isDebugEnabled()) {
            LOG.debug("MappedClass done: " + this.toString());
        }
    }

    public MappedClass getSuperClass() {
        return this.superClass;
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.clazz.getModifiers());
    }

    public static boolean isSupportedType(Class<?> clazz) {
        if (ReflectionUtils.isPropertyType(clazz)) {
            return true;
        }
        if (clazz.isArray() || Map.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz)) {
            Class subType = clazz.isArray() ? clazz.getComponentType() : ReflectionUtils.getParameterizedClass(clazz);
            return subType == null || subType == Object.class || ReflectionUtils.isPropertyType(subType);
        }
        return false;
    }

    public static void addInterestingAnnotation(Class<? extends Annotation> annotation) {
        INTERESTING_ANNOTATIONS.add(annotation);
    }

    public void addAnnotation(Class<? extends Annotation> clazz, Annotation ann) {
        if (ann == null || clazz == null) {
            return;
        }
        if (!this.foundAnnotations.containsKey(clazz)) {
            this.foundAnnotations.put(clazz, new ArrayList());
        }
        this.foundAnnotations.get(clazz).add(ann);
    }

    public DBObject callLifecycleMethods(Class<? extends Annotation> event, Object entity, DBObject dbObj, Mapper mapper) {
        List<ClassMethodPair> methodPairs = this.getLifecycleMethods(event);
        DBObject retDbObj = dbObj;
        try {
            if (methodPairs != null) {
                HashMap<Class, Object> toCall = new HashMap<Class, Object>((int)((double)methodPairs.size() * 1.3));
                for (ClassMethodPair cm : methodPairs) {
                    toCall.put(cm.clazz, null);
                }
                for (Class c : toCall.keySet()) {
                    if (c == null) continue;
                    toCall.put(c, this.getOrCreateInstance(c, mapper));
                }
                for (ClassMethodPair cm : methodPairs) {
                    Method method = cm.method;
                    Object inst = toCall.get(cm.clazz);
                    method.setAccessible(true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Calling lifecycle method(@%s %s) on %s", event.getSimpleName(), method, inst));
                    }
                    Object tempObj = inst == null ? (method.getParameterTypes().length == 0 ? method.invoke(entity, new Object[0]) : method.invoke(entity, retDbObj)) : (method.getParameterTypes().length == 0 ? method.invoke(inst, new Object[0]) : (method.getParameterTypes().length == 1 ? method.invoke(inst, entity) : method.invoke(inst, entity, retDbObj)));
                    if (tempObj == null) continue;
                    retDbObj = (DBObject)tempObj;
                }
            }
            this.callGlobalInterceptors(event, entity, dbObj, mapper);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return retDbObj;
    }

    public boolean containsJavaFieldName(String name) {
        return this.getMappedField(name) != null;
    }

    public Annotation getAnnotation(Class<? extends Annotation> clazz) {
        List<Annotation> found = this.foundAnnotations.get(clazz);
        return found == null || found.isEmpty() ? null : found.get(found.size() - 1);
    }

    public <T> List<T> getAnnotations(Class<? extends Annotation> clazz) {
        return this.foundAnnotations.get(clazz);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getCollectionName() {
        if (this.entityAn == null || this.entityAn.value().equals(".")) {
            return this.mapperOptions.isUseLowerCaseCollectionNames() ? this.clazz.getSimpleName().toLowerCase() : this.clazz.getSimpleName();
        }
        return this.entityAn.value();
    }

    public Embedded getEmbeddedAnnotation() {
        return this.embeddedAn;
    }

    public Entity getEntityAnnotation() {
        return this.entityAn;
    }

    public List<MappedField> getFieldsAnnotatedWith(Class<? extends Annotation> clazz) {
        ArrayList<MappedField> results = new ArrayList<MappedField>();
        for (MappedField mf : this.persistenceFields) {
            if (!mf.getAnnotations().containsKey(clazz)) continue;
            results.add(mf);
        }
        return results;
    }

    public Annotation getFirstAnnotation(Class<? extends Annotation> clazz) {
        List<Annotation> found = this.foundAnnotations.get(clazz);
        return found == null || found.isEmpty() ? null : found.get(0);
    }

    public Field getIdField() {
        return this.idField;
    }

    public List<ClassMethodPair> getLifecycleMethods(Class<Annotation> clazz) {
        return this.lifecycleMethods.get(clazz);
    }

    public MappedField getMappedField(String storedName) {
        for (MappedField mf : this.persistenceFields) {
            for (String n : mf.getLoadNames()) {
                if (!storedName.equals(n)) continue;
                return mf;
            }
        }
        return null;
    }

    public MappedField getMappedFieldByJavaField(String name) {
        for (MappedField mf : this.persistenceFields) {
            if (!name.equals(mf.getJavaFieldName())) continue;
            return mf;
        }
        return null;
    }

    public MappedField getMappedIdField() {
        List<MappedField> fields = this.getFieldsAnnotatedWith(Id.class);
        return fields.isEmpty() ? null : fields.get(0);
    }

    public MappedField getMappedVersionField() {
        List<MappedField> fields = this.getFieldsAnnotatedWith(Version.class);
        return fields.isEmpty() ? null : fields.get(0);
    }

    public List<MappedField> getPersistenceFields() {
        return this.persistenceFields;
    }

    public Map<Class<? extends Annotation>, List<Annotation>> getRelevantAnnotations() {
        return this.foundAnnotations;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedClass that = (MappedClass)o;
        return this.clazz.equals(that.clazz);
    }

    boolean isSubType(MappedClass mc) {
        return mc.equals(this.superClass) || this.interfaces.contains(mc);
    }

    public String toString() {
        return "MappedClass - kind:" + this.getCollectionName() + " for " + this.getClazz().getName() + " fields:" + this.persistenceFields;
    }

    public void update() {
        this.embeddedAn = (Embedded)this.getAnnotation(Embedded.class);
        this.entityAn = (Entity)this.getFirstAnnotation(Entity.class);
        List<MappedField> fields = this.getFieldsAnnotatedWith(Id.class);
        if (fields != null && !fields.isEmpty()) {
            this.idField = fields.get(0).getField();
        }
    }

    public void validate(Mapper mapper) {
        new MappingValidator(mapper.getOptions().getObjectFactory()).validate(mapper, this);
    }

    protected void basicValidate() {
        boolean isStatic = Modifier.isStatic(this.clazz.getModifiers());
        if (!isStatic && this.clazz.isMemberClass()) {
            throw new MappingException("Cannot use non-static inner class: " + this.clazz + ". Please make static.");
        }
    }

    protected void discover(Mapper mapper) {
        for (Class<? extends Annotation> clazz : INTERESTING_ANNOTATIONS) {
            this.addAnnotation(clazz);
        }
        Class<?> superclass = this.clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.superClass = mapper.getMappedClass(superclass);
        }
        for (Class<?> clazz : this.clazz.getInterfaces()) {
            this.interfaces.add(mapper.getMappedClass(clazz));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.clazz);
        EntityListeners entityLisAnn = (EntityListeners)this.getAnnotation(EntityListeners.class);
        if (entityLisAnn != null && entityLisAnn.value().length != 0) {
            Collections.addAll(arrayList, entityLisAnn.value());
        }
        for (Class clazz : arrayList) {
            for (Method m : ReflectionUtils.getDeclaredAndInheritedMethods(clazz)) {
                for (Class<? extends Annotation> c : LIFECYCLE_ANNOTATIONS) {
                    if (!m.isAnnotationPresent(c)) continue;
                    this.addLifecycleEventMethod(c, m, clazz.equals(this.clazz) ? null : clazz);
                }
            }
        }
        this.update();
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(this.clazz, true)) {
            field.setAccessible(true);
            int fieldMods = field.getModifiers();
            if (this.isIgnorable(field, fieldMods, mapper)) continue;
            if (field.isAnnotationPresent(Id.class)) {
                this.persistenceFields.add(new MappedField(field, this.clazz, mapper));
                this.update();
                continue;
            }
            if (field.isAnnotationPresent(Property.class) || field.isAnnotationPresent(Reference.class) || field.isAnnotationPresent(Embedded.class) || field.isAnnotationPresent(Serialized.class) || MappedClass.isSupportedType(field.getType()) || ReflectionUtils.implementsInterface(field.getType(), Serializable.class)) {
                this.persistenceFields.add(new MappedField(field, this.clazz, mapper));
                continue;
            }
            if (mapper.getOptions().getDefaultMapper() != null) {
                this.persistenceFields.add(new MappedField(field, this.clazz, mapper));
                continue;
            }
            if (!LOG.isWarningEnabled()) continue;
            LOG.warning(String.format("Ignoring (will not persist) field: %s.%s [type:%s]", this.clazz.getName(), field.getName(), field.getType().getName()));
        }
    }

    private void addAnnotation(Class<? extends Annotation> clazz) {
        List<? extends Annotation> annotations = ReflectionUtils.getAnnotations(this.getClazz(), clazz);
        for (Annotation annotation : annotations) {
            this.addAnnotation(clazz, annotation);
        }
    }

    private void addLifecycleEventMethod(Class<? extends Annotation> lceClazz, Method m, Class<?> clazz) {
        ClassMethodPair cm = new ClassMethodPair(clazz, m);
        if (this.lifecycleMethods.containsKey(lceClazz)) {
            this.lifecycleMethods.get(lceClazz).add(cm);
        } else {
            ArrayList<ClassMethodPair> methods = new ArrayList<ClassMethodPair>();
            methods.add(cm);
            this.lifecycleMethods.put(lceClazz, methods);
        }
    }

    private void callGlobalInterceptors(Class<? extends Annotation> event, Object entity, DBObject dbObj, Mapper mapper) {
        for (EntityInterceptor ei : mapper.getInterceptors()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Calling interceptor method " + event.getSimpleName() + " on " + ei);
            }
            if (event.equals(PreLoad.class)) {
                ei.preLoad(entity, dbObj, mapper);
                continue;
            }
            if (event.equals(PostLoad.class)) {
                ei.postLoad(entity, dbObj, mapper);
                continue;
            }
            if (event.equals(PrePersist.class)) {
                ei.prePersist(entity, dbObj, mapper);
                continue;
            }
            if (event.equals(PreSave.class)) {
                ei.preSave(entity, dbObj, mapper);
                continue;
            }
            if (!event.equals(PostPersist.class)) continue;
            ei.postPersist(entity, dbObj, mapper);
        }
    }

    private Object getOrCreateInstance(Class<?> clazz, Mapper mapper) {
        if (mapper.getInstanceCache().containsKey(clazz)) {
            return mapper.getInstanceCache().get(clazz);
        }
        Object o = mapper.getOptions().getObjectFactory().createInstance(clazz);
        Object nullO = mapper.getInstanceCache().put(clazz, o);
        if (nullO != null && LOG.isErrorEnabled()) {
            LOG.error("Race-condition, created duplicate class: " + clazz);
        }
        return o;
    }

    private boolean isIgnorable(Field field, int fieldMods, Mapper mapper) {
        return field.isAnnotationPresent(Transient.class) || Modifier.isTransient(fieldMods) || field.isSynthetic() && Modifier.isTransient(fieldMods) || mapper.getOptions().isIgnoreFinals() && Modifier.isFinal(fieldMods);
    }

    static {
        INTERESTING_ANNOTATIONS.add(Embedded.class);
        INTERESTING_ANNOTATIONS.add(Entity.class);
        INTERESTING_ANNOTATIONS.add(EntityListeners.class);
        INTERESTING_ANNOTATIONS.add(Version.class);
        INTERESTING_ANNOTATIONS.add(Converters.class);
        INTERESTING_ANNOTATIONS.add(Indexes.class);
        INTERESTING_ANNOTATIONS.add(Validation.class);
        INTERESTING_ANNOTATIONS.add(org.mongodb.morphia.annotations.Field.class);
        INTERESTING_ANNOTATIONS.add(IndexOptions.class);
    }

    private static class ClassMethodPair {
        private final Class<?> clazz;
        private final Method method;

        ClassMethodPair(Class<?> c, Method m) {
            this.clazz = c;
            this.method = m;
        }
    }
}

