/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.MapReduceCommand;
import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.DBCollectionUpdateOptions;
import com.mongodb.client.model.ValidationOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mongodb.morphia.AdvancedDatastore;
import org.mongodb.morphia.DeleteOptions;
import org.mongodb.morphia.FindAndModifyOptions;
import org.mongodb.morphia.IndexBuilder;
import org.mongodb.morphia.IndexHelper;
import org.mongodb.morphia.InsertOptions;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.MapReduceOptions;
import org.mongodb.morphia.MapreduceResults;
import org.mongodb.morphia.MapreduceType;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.UpdateOptions;
import org.mongodb.morphia.aggregation.AggregationPipeline;
import org.mongodb.morphia.aggregation.AggregationPipelineImpl;
import org.mongodb.morphia.annotations.CappedAt;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.NotSaved;
import org.mongodb.morphia.annotations.PostPersist;
import org.mongodb.morphia.annotations.Validation;
import org.mongodb.morphia.annotations.Version;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MappingException;
import org.mongodb.morphia.mapping.cache.EntityCache;
import org.mongodb.morphia.mapping.lazy.proxy.ProxyHelper;
import org.mongodb.morphia.query.CountOptions;
import org.mongodb.morphia.query.DefaultQueryFactory;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryException;
import org.mongodb.morphia.query.QueryFactory;
import org.mongodb.morphia.query.UpdateException;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateOpsImpl;
import org.mongodb.morphia.query.UpdateResults;
import org.mongodb.morphia.utils.Assert;

@Deprecated
public class DatastoreImpl
implements AdvancedDatastore {
    private static final Logger LOG = MorphiaLoggerFactory.get(DatastoreImpl.class);
    private final Morphia morphia;
    private final MongoClient mongoClient;
    private final MongoDatabase database;
    private final IndexHelper indexHelper;
    private DB db;
    private Mapper mapper;
    private WriteConcern defConcern;
    private DBDecoderFactory decoderFactory;
    private volatile QueryFactory queryFactory = new DefaultQueryFactory();

    @Deprecated
    public DatastoreImpl(Morphia morphia, MongoClient mongoClient, String dbName) {
        this(morphia, morphia.getMapper(), mongoClient, dbName);
    }

    @Deprecated
    public DatastoreImpl(Morphia morphia, Mapper mapper, MongoClient mongoClient, String dbName) {
        this(morphia, mapper, mongoClient, mongoClient.getDatabase(dbName));
    }

    private DatastoreImpl(Morphia morphia, Mapper mapper, MongoClient mongoClient, MongoDatabase database) {
        this.morphia = morphia;
        this.mapper = mapper;
        this.mongoClient = mongoClient;
        this.database = database;
        this.db = mongoClient.getDB(database.getName());
        this.defConcern = mongoClient.getWriteConcern();
        this.indexHelper = new IndexHelper(mapper, database);
    }

    @Deprecated
    public DatastoreImpl copy(String database) {
        return new DatastoreImpl(this.morphia, this.mapper, this.mongoClient, database);
    }

    @Override
    public AggregationPipeline createAggregation(Class source) {
        return new AggregationPipelineImpl(this, this.getCollection(source), source);
    }

    @Override
    public AggregationPipeline createAggregation(String collection, Class<?> clazz) {
        return new AggregationPipelineImpl(this, this.getDB().getCollection(collection), clazz);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> collection) {
        return this.newQuery(collection, this.getCollection((Class)collection));
    }

    @Override
    public <T> UpdateOperations<T> createUpdateOperations(Class<T> clazz) {
        return new UpdateOpsImpl<T>(clazz, this.getMapper());
    }

    @Override
    public <T> WriteResult delete(Query<T> query, DeleteOptions options) {
        DBCollection dbColl = query.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection((Class)query.getEntityClass());
        }
        if (query.getSortObject() != null || query.getOffset() != 0 || query.getLimit() > 0) {
            throw new QueryException("Delete does not allow sort/offset/limit query options.");
        }
        return dbColl.remove(query.getQueryObject(), this.enforceWriteConcern(options, query.getEntityClass()).getOptions());
    }

    @Override
    public <T, V> WriteResult delete(Class<T> clazz, V id) {
        return this.delete(clazz, id, new DeleteOptions().writeConcern(this.getWriteConcern(clazz)));
    }

    @Override
    public <T, V> WriteResult delete(Class<T> clazz, V id, DeleteOptions options) {
        return this.delete((T)this.createQuery(clazz).filter("_id", id), options);
    }

    @Override
    public <T, V> WriteResult delete(Class<T> clazz, Iterable<V> ids) {
        return this.delete((T)this.find(clazz).filter("_id in", ids));
    }

    @Override
    public <T, V> WriteResult delete(Class<T> clazz, Iterable<V> ids, DeleteOptions options) {
        return this.delete((T)this.find(clazz).filter("_id in", ids), options);
    }

    @Override
    public <T> WriteResult delete(Query<T> query) {
        return this.delete((T)query, new DeleteOptions().writeConcern(this.getWriteConcern(query.getEntityClass())));
    }

    @Override
    @Deprecated
    public <T> WriteResult delete(Query<T> query, WriteConcern wc) {
        return this.delete((T)query, new DeleteOptions().writeConcern(wc));
    }

    @Override
    public <T> WriteResult delete(T entity) {
        return this.delete(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> WriteResult delete(T entity, DeleteOptions options) {
        T wrapped = ProxyHelper.unwrap(entity);
        if (wrapped instanceof Class) {
            throw new MappingException("Did you mean to delete all documents? -- delete(ds.createQuery(???.class))");
        }
        try {
            return this.delete(wrapped.getClass(), this.mapper.getId(wrapped), options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public <T> WriteResult delete(T entity, WriteConcern wc) {
        return this.delete(entity, new DeleteOptions().writeConcern(wc));
    }

    @Override
    public void ensureCaps() {
        for (MappedClass mc : this.mapper.getMappedClasses()) {
            DB database;
            if (mc.getEntityAnnotation() == null || mc.getEntityAnnotation().cap().value() <= 0L) continue;
            CappedAt cap = mc.getEntityAnnotation().cap();
            String collName = this.mapper.getCollectionName(mc.getClazz());
            BasicDBObjectBuilder dbCapOpts = BasicDBObjectBuilder.start("capped", true);
            if (cap.value() > 0L) {
                dbCapOpts.add("size", cap.value());
            }
            if (cap.count() > 0L) {
                dbCapOpts.add("max", cap.count());
            }
            if ((database = this.getDB()).getCollectionNames().contains(collName)) {
                CommandResult dbResult = database.command(BasicDBObjectBuilder.start("collstats", collName).get());
                if (dbResult.containsField("capped")) {
                    LOG.debug("DBCollection already exists and is capped already; doing nothing. " + dbResult);
                    continue;
                }
                LOG.warning("DBCollection already exists with same name(" + collName + ") and is not capped; not creating capped version!");
                continue;
            }
            this.getDB().createCollection(collName, dbCapOpts.get());
            LOG.debug("Created capped DBCollection (" + collName + ") with opts " + dbCapOpts);
        }
    }

    @Override
    public void enableDocumentValidation() {
        for (MappedClass mc : this.mapper.getMappedClasses()) {
            this.process(mc, (Validation)mc.getAnnotation(Validation.class));
        }
    }

    void process(MappedClass mc, Validation validation) {
        if (validation != null) {
            String collectionName = mc.getCollectionName();
            CommandResult result = this.getDB().command(new BasicDBObject("collMod", collectionName).append("validator", BasicDBObject.parse(validation.value())).append("validationLevel", validation.level().getValue()).append("validationAction", validation.action().getValue()));
            if (!result.ok()) {
                if (result.getInt("code") == 26) {
                    ValidationOptions options = new ValidationOptions().validator(BasicDBObject.parse(validation.value())).validationLevel(validation.level()).validationAction(validation.action());
                    this.getDatabase().createCollection(collectionName, new CreateCollectionOptions().validationOptions(options));
                } else {
                    result.throwOnError();
                }
            }
        }
    }

    @Override
    public Key<?> exists(Object entityOrKey) {
        Query<?> query = this.buildExistsQuery(entityOrKey);
        return query.getKey();
    }

    @Override
    public <T> Query<T> find(Class<T> clazz) {
        return this.createQuery(clazz);
    }

    @Override
    @Deprecated
    public <T, V> Query<T> find(Class<T> clazz, String property, V value) {
        Query<T> query = this.createQuery(clazz);
        return query.filter(property, value);
    }

    @Override
    @Deprecated
    public <T, V> Query<T> find(Class<T> clazz, String property, V value, int offset, int size) {
        Query<T> query = this.createQuery(clazz);
        query.offset(offset);
        query.limit(size);
        return query.filter(property, value);
    }

    @Override
    public <T> T findAndDelete(Query<T> query) {
        return this.findAndDelete(query, new FindAndModifyOptions());
    }

    @Override
    public <T> T findAndDelete(Query<T> query, FindAndModifyOptions options) {
        DBCollection dbColl = query.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection((Class)query.getEntityClass());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing findAndModify(" + dbColl.getName() + ") with delete ...");
        }
        FindAndModifyOptions copy = this.enforceWriteConcern(options, query.getEntityClass()).copy().projection(query.getFieldsObject()).sort(query.getSortObject()).returnNew(false).upsert(false).remove(true);
        DBObject result = dbColl.findAndModify(query.getQueryObject(), copy.getOptions());
        return result == null ? null : (T)this.mapper.fromDBObject(this, query.getEntityClass(), result, this.createCache());
    }

    @Override
    public <T> T findAndModify(Query<T> query, UpdateOperations<T> operations, FindAndModifyOptions options) {
        DBCollection dbColl = query.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection((Class)query.getEntityClass());
        }
        if (LOG.isTraceEnabled()) {
            LOG.info("Executing findAndModify(" + dbColl.getName() + ") with update ");
        }
        this.updateForVersioning(query, operations);
        DBObject res = dbColl.findAndModify(query.getQueryObject(), options.copy().sort(query.getSortObject()).projection(query.getFieldsObject()).update(((UpdateOpsImpl)operations).getOps()).getOptions());
        return res == null ? null : (T)this.mapper.fromDBObject(this, query.getEntityClass(), res, this.createCache());
    }

    @Override
    public <T> T findAndModify(Query<T> query, UpdateOperations<T> operations) {
        return this.findAndModify(query, operations, new FindAndModifyOptions().returnNew(true));
    }

    @Override
    @Deprecated
    public <T> T findAndModify(Query<T> query, UpdateOperations<T> operations, boolean oldVersion) {
        return this.findAndModify(query, operations, new FindAndModifyOptions().returnNew(!oldVersion).upsert(false));
    }

    @Override
    @Deprecated
    public <T> T findAndModify(Query<T> query, UpdateOperations<T> operations, boolean oldVersion, boolean createIfMissing) {
        return this.findAndModify(query, operations, new FindAndModifyOptions().returnNew(!oldVersion).upsert(createIfMissing));
    }

    private <T> void updateForVersioning(Query<T> query, UpdateOperations<T> operations) {
        MappedClass mc = this.mapper.getMappedClass(query.getEntityClass());
        if (!mc.getFieldsAnnotatedWith(Version.class).isEmpty()) {
            operations.inc(mc.getMappedVersionField().getNameToStore());
        }
    }

    @Override
    public <T, V> Query<T> get(Class<T> clazz, Iterable<V> ids) {
        return this.find(clazz).disableValidation().filter("_id in", ids).enableValidation();
    }

    @Override
    public <T, V> T get(Class<T> clazz, V id) {
        return this.find(this.getCollection((Class)clazz).getName(), clazz, "_id", id, 0, 1, true).get();
    }

    @Override
    public <T> T get(T entity) {
        T unwrapped = ProxyHelper.unwrap(entity);
        Object id = this.mapper.getId(unwrapped);
        if (id == null) {
            throw new MappingException("Could not get id for " + unwrapped.getClass().getName());
        }
        return (T)this.get(unwrapped.getClass(), id);
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Key<T> key) {
        String keyCollection;
        String collectionName = this.mapper.getCollectionName(clazz);
        if (!collectionName.equals(keyCollection = this.mapper.updateCollection(key))) {
            throw new RuntimeException("collection names don't match for key and class: " + collectionName + " != " + keyCollection);
        }
        Object id = key.getId();
        if (id instanceof DBObject) {
            ((DBObject)id).removeField("className");
        }
        return this.get(clazz, id);
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<Key<T>> keys) {
        HashMap<String, ArrayList<Key<T>>> kindMap = new HashMap<String, ArrayList<Key<T>>>();
        ArrayList entities = new ArrayList();
        for (Key<T> key : keys) {
            this.mapper.updateCollection(key);
            if (kindMap.containsKey(key.getCollection())) {
                ((List)kindMap.get(key.getCollection())).add(key);
                continue;
            }
            kindMap.put(key.getCollection(), new ArrayList<Key<T>>(Collections.singletonList(key)));
        }
        for (Map.Entry entry : kindMap.entrySet()) {
            List kindKeys = (List)entry.getValue();
            ArrayList<Object> objIds = new ArrayList<Object>();
            for (Key key : kindKeys) {
                objIds.add(key.getId());
            }
            List kindResults = this.find((String)entry.getKey(), null).disableValidation().filter("_id in", objIds).asList();
            entities.addAll(kindResults);
        }
        return entities;
    }

    @Override
    public <T> List<T> getByKeys(Iterable<Key<T>> keys) {
        return this.getByKeys(null, keys);
    }

    @Deprecated
    public DBCollection getCollection(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.getCollection((Class)(obj instanceof Class ? (Class<?>)obj : obj.getClass()));
    }

    public DBCollection getCollection(Class clazz) {
        String collName = this.mapper.getCollectionName(clazz);
        return this.getDB().getCollection(collName);
    }

    private <T> MongoCollection<T> getMongoCollection(Class<T> clazz) {
        return this.getMongoCollection(this.mapper.getCollectionName(clazz), clazz);
    }

    private <T> MongoCollection<T> getMongoCollection(String name, Class<T> clazz) {
        return this.database.getCollection(name, clazz);
    }

    @Override
    public <T> long getCount(T entity) {
        return this.getCollection(ProxyHelper.unwrap(entity)).count();
    }

    @Override
    public <T> long getCount(Class<T> clazz) {
        return this.getCollection((Class)clazz).count();
    }

    @Override
    public <T> long getCount(Query<T> query) {
        return query.count();
    }

    @Override
    public <T> long getCount(Query<T> query, CountOptions options) {
        return query.count(options);
    }

    @Override
    public DB getDB() {
        return this.db;
    }

    private MongoDatabase getDatabase() {
        return this.mongoClient.getDatabase(this.db.getName());
    }

    @Override
    public WriteConcern getDefaultWriteConcern() {
        return this.defConcern;
    }

    @Override
    public void setDefaultWriteConcern(WriteConcern wc) {
        this.defConcern = wc;
    }

    @Override
    @Deprecated
    public <T> Key<T> getKey(T entity) {
        return this.mapper.getKey(entity);
    }

    @Override
    public MongoClient getMongo() {
        return this.mongoClient;
    }

    @Override
    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    @Override
    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Override
    public <T> MapreduceResults<T> mapReduce(MapReduceOptions<T> options) {
        DBCollection collection = options.getQuery().getCollection();
        EntityCache cache = this.createCache();
        MapreduceResults<T> results = new MapreduceResults<T>(collection.mapReduce(options.toCommand(this.getMapper())));
        results.setOutputType(options.getOutputType());
        if (MapReduceCommand.OutputType.INLINE.equals((Object)options.getOutputType())) {
            results.setInlineRequiredOptions(this, options.getResultType(), this.getMapper(), cache);
        } else {
            results.setQuery(this.newQuery(options.getResultType(), this.getDB().getCollection(results.getOutputCollectionName())));
        }
        return results;
    }

    @Override
    @Deprecated
    public <T> MapreduceResults<T> mapReduce(MapreduceType type, Query query, String map, String reduce, String finalize, Map<String, Object> scopeFields, Class<T> outputType) {
        DBCollection dbColl = query.getCollection();
        String outColl = this.mapper.getCollectionName(outputType);
        MapReduceCommand cmd = new MapReduceCommand(dbColl, map, reduce, outColl, type.toOutputType(), query.getQueryObject());
        if (query.getLimit() > 0) {
            cmd.setLimit(query.getLimit());
        }
        if (query.getSortObject() != null) {
            cmd.setSort(query.getSortObject());
        }
        if (finalize != null && finalize.length() != 0) {
            cmd.setFinalize(finalize);
        }
        if (scopeFields != null && !scopeFields.isEmpty()) {
            cmd.setScope(scopeFields);
        }
        return this.mapReduce(type, query, outputType, cmd);
    }

    @Override
    @Deprecated
    public <T> MapreduceResults<T> mapReduce(MapreduceType type, Query query, Class<T> outputType, MapReduceCommand baseCommand) {
        Assert.parametersNotNull("map", baseCommand.getMap());
        Assert.parameterNotEmpty("map", baseCommand.getMap());
        Assert.parametersNotNull("reduce", baseCommand.getReduce());
        Assert.parameterNotEmpty("reduce", baseCommand.getReduce());
        if (query.getOffset() != 0 || query.getFieldsObject() != null) {
            throw new QueryException("mapReduce does not allow the offset/retrievedFields query options.");
        }
        MapReduceCommand.OutputType outType = type.toOutputType();
        DBCollection dbColl = query.getCollection();
        MapReduceCommand cmd = new MapReduceCommand(dbColl, baseCommand.getMap(), baseCommand.getReduce(), baseCommand.getOutputTarget(), outType, query.getQueryObject());
        cmd.setFinalize(baseCommand.getFinalize());
        cmd.setScope(baseCommand.getScope());
        if (query.getLimit() > 0) {
            cmd.setLimit(query.getLimit());
        }
        if (query.getSortObject() != null) {
            cmd.setSort(query.getSortObject());
        }
        if (LOG.isTraceEnabled()) {
            LOG.info("Executing " + cmd.toString());
        }
        EntityCache cache = this.createCache();
        MapreduceResults<T> results = new MapreduceResults<T>(dbColl.mapReduce(baseCommand));
        results.setType(type);
        if (MapreduceType.INLINE.equals((Object)type)) {
            results.setInlineRequiredOptions(this, outputType, this.getMapper(), cache);
        } else {
            results.setQuery(this.newQuery(outputType, this.getDB().getCollection(results.getOutputCollectionName())));
        }
        return results;
    }

    @Override
    public <T> Key<T> merge(T entity) {
        return this.merge(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> Key<T> merge(T entity, WriteConcern wc) {
        UpdateResults res;
        T unwrapped = entity;
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.mapper.toDBObject(unwrapped, involvedObjects);
        Key<T> key = this.mapper.getKey(unwrapped);
        Object id = this.mapper.getId(unwrapped = ProxyHelper.unwrap(unwrapped));
        if (id == null) {
            throw new MappingException("Could not get id for " + unwrapped.getClass().getName());
        }
        Object idValue = dbObj.get("_id");
        dbObj.removeField("_id");
        MappedClass mc = this.mapper.getMappedClass(unwrapped);
        DBCollection dbColl = this.getCollection(unwrapped);
        WriteResult wr = this.tryVersionedUpdate(dbColl, unwrapped, dbObj, idValue, new InsertOptions().writeConcern(wc), mc);
        if (wr == null) {
            Query<?> query = this.createQuery(unwrapped.getClass()).filter("_id", id);
            wr = this.update(query, new BasicDBObject("$set", dbObj), false, false, wc).getWriteResult();
        }
        if ((res = new UpdateResults(wr)).getUpdatedCount() == 0) {
            throw new UpdateException("Nothing updated");
        }
        dbObj.put("_id", idValue);
        this.postSaveOperations(Collections.singletonList(entity), involvedObjects, dbColl, false);
        return key;
    }

    @Override
    public <T> Query<T> queryByExample(T ex) {
        return this.queryByExample(this.getCollection(ex), ex);
    }

    @Override
    public <T> Iterable<Key<T>> save(Iterable<T> entities) {
        Iterator<T> iterator = entities.iterator();
        return !iterator.hasNext() ? Collections.emptyList() : this.save(entities, this.getWriteConcern(iterator.next()));
    }

    @Override
    public <T> Iterable<Key<T>> save(Iterable<T> entities, WriteConcern wc) {
        return this.save(entities, new InsertOptions().writeConcern(wc));
    }

    @Override
    public <T> Iterable<Key<T>> save(Iterable<T> entities, InsertOptions options) {
        ArrayList<Key<T>> savedKeys = new ArrayList<Key<T>>();
        for (T ent : entities) {
            savedKeys.add(this.save(ent, options));
        }
        return savedKeys;
    }

    @Override
    @Deprecated
    public <T> Iterable<Key<T>> save(T ... entities) {
        return this.save((Iterable<T>)Arrays.asList(entities), new InsertOptions());
    }

    @Override
    public <T> Key<T> save(T entity) {
        return this.save(entity, new InsertOptions());
    }

    @Override
    @Deprecated
    public <T> Key<T> save(T entity, WriteConcern wc) {
        return this.save(entity, new InsertOptions().writeConcern(wc));
    }

    @Override
    public <T> Key<T> save(T entity, InsertOptions options) {
        if (entity == null) {
            throw new UpdateException("Can not persist a null entity");
        }
        T unwrapped = ProxyHelper.unwrap(entity);
        return this.save(this.getCollection(unwrapped), unwrapped, this.enforceWriteConcern(options, entity.getClass()));
    }

    @Override
    public <T> UpdateResults update(T entity, UpdateOperations<T> operations) {
        if (entity instanceof Query) {
            return this.update((Query)entity, operations);
        }
        MappedClass mc = this.mapper.getMappedClass(entity);
        Query<?> query = this.createQuery(this.mapper.getMappedClass(entity).getClazz()).disableValidation().filter("_id", this.mapper.getId(entity));
        if (!mc.getFieldsAnnotatedWith(Version.class).isEmpty()) {
            MappedField field = mc.getFieldsAnnotatedWith(Version.class).get(0);
            query.field(field.getNameToStore()).equal(field.getFieldValue(entity));
        }
        return this.update(query, operations);
    }

    @Override
    public <T> UpdateResults update(Key<T> key, UpdateOperations<T> operations) {
        Class<Object> clazz = key.getType();
        if (clazz == null) {
            clazz = this.mapper.getClassFromCollection(key.getCollection());
        }
        return this.updateFirst(this.createQuery(clazz).disableValidation().filter("_id", key.getId()), operations);
    }

    @Override
    public <T> UpdateResults update(Query<T> query, UpdateOperations<T> operations) {
        return this.update(query, operations, new UpdateOptions().upsert(false).multi(true).writeConcern(this.getWriteConcern(query.getEntityClass())));
    }

    @Override
    public <T> UpdateResults update(Query<T> query, UpdateOperations<T> operations, boolean createIfMissing) {
        return this.update(query, operations, new UpdateOptions().upsert(createIfMissing).writeConcern(this.getWriteConcern(query.getEntityClass())));
    }

    @Override
    public <T> UpdateResults update(Query<T> query, UpdateOperations<T> operations, boolean createIfMissing, WriteConcern wc) {
        return this.update(query, operations, new UpdateOptions().upsert(createIfMissing).multi(true).writeConcern(wc));
    }

    @Override
    public <T> UpdateResults updateFirst(Query<T> query, UpdateOperations<T> operations) {
        return this.update(query, operations, new UpdateOptions());
    }

    @Override
    public <T> UpdateResults updateFirst(Query<T> query, UpdateOperations<T> operations, boolean createIfMissing) {
        return this.update(query, operations, new UpdateOptions().upsert(createIfMissing));
    }

    @Override
    public <T> UpdateResults updateFirst(Query<T> query, UpdateOperations<T> operations, boolean createIfMissing, WriteConcern wc) {
        return this.update(query, operations, new UpdateOptions().upsert(createIfMissing).writeConcern(wc));
    }

    @Override
    public <T> UpdateResults updateFirst(Query<T> query, T entity, boolean createIfMissing) {
        if (this.getMapper().getMappedClass(entity).getMappedVersionField() != null) {
            throw new UnsupportedOperationException("updateFirst() is not supported with versioned entities");
        }
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.mapper.toDBObject(entity, involvedObjects);
        UpdateResults res = this.update(query, dbObj, createIfMissing, false, this.getWriteConcern(entity));
        if (res.getInsertedCount() > 0) {
            dbObj.put("_id", res.getNewId());
        }
        this.postSaveOperations(Collections.singletonList(entity), involvedObjects, this.getCollection(entity), false);
        return res;
    }

    @Override
    public <T> Query<T> createQuery(String collection, Class<T> type) {
        return this.newQuery(type, this.getDB().getCollection(collection));
    }

    @Override
    public <T> Query<T> createQuery(Class<T> clazz, DBObject q) {
        return this.newQuery(clazz, this.getCollection((Class)clazz), q);
    }

    @Override
    public <T> Query<T> createQuery(String collection, Class<T> type, DBObject q) {
        return this.newQuery(type, this.getCollection(collection), q);
    }

    @Override
    public <T, V> DBRef createRef(Class<T> clazz, V id) {
        if (id == null) {
            throw new MappingException("Could not get id for " + clazz.getName());
        }
        return new DBRef(this.getCollection((Class)clazz).getName(), id);
    }

    @Override
    public <T> DBRef createRef(T entity) {
        T wrapped = ProxyHelper.unwrap(entity);
        Object id = this.mapper.getId(wrapped);
        if (id == null) {
            throw new MappingException("Could not get id for " + wrapped.getClass().getName());
        }
        return this.createRef(wrapped.getClass(), id);
    }

    @Override
    public <T> UpdateOperations<T> createUpdateOperations(Class<T> type, DBObject ops) {
        UpdateOpsImpl upOps = (UpdateOpsImpl)this.createUpdateOperations(type);
        upOps.setOps(ops);
        return upOps;
    }

    @Override
    public <T, V> WriteResult delete(String kind, Class<T> clazz, V id) {
        return this.delete((T)this.find(kind, clazz).filter("_id", id));
    }

    @Override
    public <T, V> WriteResult delete(String kind, Class<T> clazz, V id, DeleteOptions options) {
        return this.delete((T)this.find(kind, clazz).filter("_id", id), options);
    }

    @Override
    @Deprecated
    public <T, V> WriteResult delete(String kind, Class<T> clazz, V id, WriteConcern wc) {
        return this.delete((T)this.find(kind, clazz).filter("_id", id), new DeleteOptions().writeConcern(wc));
    }

    @Override
    @Deprecated
    public <T> void ensureIndex(Class<T> type, String fields) {
        this.ensureIndex(type, null, fields, false, false);
    }

    @Override
    @Deprecated
    public <T> void ensureIndex(Class<T> clazz, String name, String fields, boolean unique, boolean dropDupsOnCreate) {
        MappedClass mappedClass = this.getMapper().getMappedClass(clazz);
        this.ensureIndex(mappedClass.getCollectionName(), clazz, name, fields, unique, dropDupsOnCreate);
    }

    @Override
    public void ensureIndexes() {
        this.ensureIndexes(false);
    }

    @Override
    public void ensureIndexes(boolean background) {
        for (MappedClass mc : this.mapper.getMappedClasses()) {
            this.indexHelper.createIndex(this.getMongoCollection(mc.getClazz()), mc, background);
        }
    }

    @Override
    public <T> void ensureIndexes(Class<T> clazz) {
        this.ensureIndexes(clazz, false);
    }

    @Override
    public <T> void ensureIndexes(Class<T> clazz, boolean background) {
        this.indexHelper.createIndex(this.getMongoCollection(clazz), this.mapper.getMappedClass(clazz), background);
    }

    @Override
    @Deprecated
    public <T> void ensureIndex(String collection, Class<T> type, String fields) {
        this.ensureIndex(collection, type, null, fields, false, false);
    }

    @Override
    @Deprecated
    public <T> void ensureIndex(String collection, Class<T> clazz, String name, String fields, boolean unique, boolean dropDupsOnCreate) {
        if (dropDupsOnCreate) {
            LOG.warning("Support for dropDups has been removed from the server.  Please remove this setting.");
        }
        this.indexHelper.createIndex(this.getMongoCollection(collection, clazz), this.getMapper().getMappedClass(clazz), new IndexBuilder().fields(fields).name(name).unique(unique), false);
    }

    @Override
    public <T> void ensureIndexes(String collection, Class<T> clazz) {
        this.ensureIndexes(collection, clazz, false);
    }

    @Override
    public <T> void ensureIndexes(String collection, Class<T> clazz, boolean background) {
        this.indexHelper.createIndex(this.getMongoCollection(collection, clazz), this.mapper.getMappedClass(clazz), background);
    }

    @Override
    public Key<?> exists(Object entityOrKey, ReadPreference readPreference) {
        Query<?> query = this.buildExistsQuery(entityOrKey);
        if (readPreference != null) {
            query.useReadPreference(readPreference);
        }
        return query.getKey();
    }

    @Override
    public <T> Query<T> find(String collection, Class<T> clazz) {
        return this.createQuery(collection, clazz);
    }

    @Override
    public <T, V> Query<T> find(String collection, Class<T> clazz, String property, V value, int offset, int size) {
        return this.find(collection, clazz, property, value, offset, size, true);
    }

    @Override
    public <T> T get(Class<T> clazz, DBRef ref) {
        DBObject object = this.getDB().getCollection(ref.getCollectionName()).findOne(new BasicDBObject("_id", ref.getId()));
        return this.mapper.fromDBObject(this, clazz, object, this.createCache());
    }

    @Override
    public <T, V> T get(String collection, Class<T> clazz, V id) {
        List results = this.find(collection, clazz, "_id", id, 0, 1).asList();
        if (results == null || results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    @Override
    public long getCount(String collection) {
        return this.getCollection(collection).count();
    }

    @Override
    public DBDecoderFactory getDecoderFact() {
        return this.decoderFactory != null ? this.decoderFactory : DefaultDBDecoder.FACTORY;
    }

    @Override
    public void setDecoderFact(DBDecoderFactory fact) {
        this.decoderFactory = fact;
    }

    @Override
    public <T> Key<T> insert(String collection, T entity) {
        T unwrapped = ProxyHelper.unwrap(entity);
        return this.insert(this.getCollection(collection), unwrapped, new InsertOptions().writeConcern(this.getWriteConcern(unwrapped)));
    }

    @Override
    public <T> Key<T> insert(String collection, T entity, InsertOptions options) {
        return this.insert(this.getCollection(collection), ProxyHelper.unwrap(entity), options);
    }

    @Override
    public <T> Key<T> insert(T entity) {
        return this.insert(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> Key<T> insert(T entity, WriteConcern wc) {
        return this.insert(entity, new InsertOptions().writeConcern(wc));
    }

    @Override
    public <T> Key<T> insert(T entity, InsertOptions options) {
        T unwrapped = ProxyHelper.unwrap(entity);
        return this.insert(this.getCollection(unwrapped), unwrapped, options);
    }

    @Override
    @Deprecated
    public <T> Iterable<Key<T>> insert(T ... entities) {
        return this.insert((Iterable<T>)Arrays.asList(entities));
    }

    @Override
    public <T> Iterable<Key<T>> insert(Iterable<T> entities, WriteConcern wc) {
        return this.insert(entities, new InsertOptions().writeConcern(wc));
    }

    @Override
    public <T> Iterable<Key<T>> insert(Iterable<T> entities, InsertOptions options) {
        Iterator<T> iterator = entities.iterator();
        return !iterator.hasNext() ? Collections.emptyList() : this.insert(this.getCollection(iterator.next()), entities, options);
    }

    @Override
    public <T> Iterable<Key<T>> insert(String collection, Iterable<T> entities) {
        return this.insert(collection, entities, new InsertOptions());
    }

    @Override
    @Deprecated
    public <T> Iterable<Key<T>> insert(String collection, Iterable<T> entities, WriteConcern wc) {
        return this.insert(this.getDB().getCollection(collection), entities, new InsertOptions().writeConcern(wc));
    }

    @Override
    @Deprecated
    public <T> Iterable<Key<T>> insert(String collection, Iterable<T> entities, InsertOptions options) {
        return this.insert(this.getDB().getCollection(collection), entities, options);
    }

    @Override
    public <T> Query<T> queryByExample(String collection, T ex) {
        return this.queryByExample(this.getDB().getCollection(collection), ex);
    }

    @Override
    public <T> Key<T> save(String collection, T entity) {
        T unwrapped = ProxyHelper.unwrap(entity);
        return this.save(collection, entity, this.getWriteConcern(unwrapped));
    }

    @Override
    public <T> Key<T> save(String collection, T entity, WriteConcern wc) {
        return this.save(this.getCollection(collection), ProxyHelper.unwrap(entity), new InsertOptions().writeConcern(wc));
    }

    @Override
    public <T> Key<T> save(String collection, T entity, InsertOptions options) {
        return this.save(this.getCollection(collection), ProxyHelper.unwrap(entity), options);
    }

    @Deprecated
    public <T, V> WriteResult delete(Class<T> clazz, V id, WriteConcern wc) {
        return this.delete((T)this.createQuery(clazz).filter("_id", id), new DeleteOptions().writeConcern(wc));
    }

    public <T, V> Query<T> find(String collection, Class<T> clazz, String property, V value, int offset, int size, boolean validate) {
        Query<T> query = this.find(collection, clazz);
        if (!validate) {
            query.disableValidation();
        }
        query.offset(offset);
        query.limit(size);
        return query.filter(property, value).enableValidation();
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> Iterable<Key<T>> insert(Iterable<T> entities) {
        return this.insert(entities, new InsertOptions().writeConcern(this.defConcern));
    }

    public <T> Key<T> insert(String collection, T entity, WriteConcern wc) {
        return this.insert(this.getCollection(collection), ProxyHelper.unwrap(entity), new InsertOptions().writeConcern(wc));
    }

    protected DBCollection getCollection(String kind) {
        if (kind == null) {
            return null;
        }
        return this.getDB().getCollection(kind);
    }

    @Deprecated
    protected Object getId(Object entity) {
        return this.mapper.getId(entity);
    }

    protected <T> Key<T> insert(DBCollection dbColl, T entity, InsertOptions options) {
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        dbColl.insert(Collections.singletonList(this.entityToDBObj(entity, involvedObjects)), this.enforceWriteConcern(options, entity.getClass()).getOptions());
        return this.postSaveOperations(Collections.singletonList(entity), involvedObjects, dbColl).get(0);
    }

    <T> FindAndModifyOptions enforceWriteConcern(FindAndModifyOptions options, Class<T> klass) {
        if (options.getWriteConcern() == null) {
            return options.copy().writeConcern(this.getWriteConcern(klass));
        }
        return options;
    }

    <T> InsertOptions enforceWriteConcern(InsertOptions options, Class<T> klass) {
        if (options.getWriteConcern() == null) {
            return options.copy().writeConcern(this.getWriteConcern(klass));
        }
        return options;
    }

    <T> UpdateOptions enforceWriteConcern(UpdateOptions options, Class<T> klass) {
        if (options.getWriteConcern() == null) {
            return options.copy().writeConcern(this.getWriteConcern(klass));
        }
        return options;
    }

    <T> DeleteOptions enforceWriteConcern(DeleteOptions options, Class<T> klass) {
        if (options.getWriteConcern() == null) {
            return options.copy().writeConcern(this.getWriteConcern(klass));
        }
        return options;
    }

    protected <T> Key<T> save(DBCollection dbColl, T entity, InsertOptions options) {
        Object idValue;
        if (entity == null) {
            throw new UpdateException("Can not persist a null entity");
        }
        MappedClass mc = this.mapper.getMappedClass(entity);
        if (mc.getAnnotation(NotSaved.class) != null) {
            throw new MappingException(String.format("Entity type: %s is marked as NotSaved which means you should not try to save it!", mc.getClazz().getName()));
        }
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject document = this.entityToDBObj(entity, involvedObjects);
        WriteResult wr = this.tryVersionedUpdate(dbColl, entity, document, idValue = document.get("_id"), this.enforceWriteConcern(options, entity.getClass()), mc);
        if (wr == null) {
            this.saveDocument(dbColl, document, options);
        }
        return this.postSaveOperations(Collections.singletonList(entity), involvedObjects, dbColl).get(0);
    }

    private WriteResult saveDocument(DBCollection dbColl, DBObject document, InsertOptions options) {
        if (document.get("_id") == null) {
            return dbColl.insert(Collections.singletonList(document), options.getOptions());
        }
        return dbColl.update(new BasicDBObject("_id", document.get("_id")), document, new DBCollectionUpdateOptions().bypassDocumentValidation(options.getBypassDocumentValidation()).writeConcern(options.getWriteConcern()).upsert(true));
    }

    private <T> WriteResult tryVersionedUpdate(DBCollection dbColl, T entity, DBObject dbObj, Object idValue, InsertOptions options, MappedClass mc) {
        WriteResult wr;
        if (mc.getFieldsAnnotatedWith(Version.class).isEmpty()) {
            return null;
        }
        MappedField mfVersion = mc.getMappedVersionField();
        String versionKeyName = mfVersion.getNameToStore();
        Long oldVersion = (Long)mfVersion.getFieldValue(entity);
        long newVersion = this.nextValue(oldVersion);
        dbObj.put(versionKeyName, newVersion);
        if (idValue != null && newVersion != 1L) {
            Query<?> query = this.find(dbColl.getName(), entity.getClass()).disableValidation().filter("_id", idValue).enableValidation().filter(versionKeyName, oldVersion);
            UpdateResults res = this.update(query, dbObj, new UpdateOptions().bypassDocumentValidation(options.getBypassDocumentValidation()).writeConcern(options.getWriteConcern()));
            wr = res.getWriteResult();
            if (res.getUpdatedCount() != 1) {
                throw new ConcurrentModificationException(String.format("Entity of class %s (id='%s',version='%d') was concurrently updated.", entity.getClass().getName(), idValue, oldVersion));
            }
        } else {
            wr = this.saveDocument(dbColl, dbObj, options);
        }
        return wr;
    }

    private Query<?> buildExistsQuery(Object entityOrKey) {
        Object unwrapped = ProxyHelper.unwrap(entityOrKey);
        Key<Object> key = this.mapper.getKey(unwrapped);
        Object id = key.getId();
        if (id == null) {
            throw new MappingException("Could not get id for " + unwrapped.getClass().getName());
        }
        return this.find(key.getCollection(), key.getType()).filter("_id", key.getId());
    }

    private EntityCache createCache() {
        return this.mapper.createEntityCache();
    }

    private DBObject entityToDBObj(Object entity, Map<Object, DBObject> involvedObjects) {
        return this.mapper.toDBObject(ProxyHelper.unwrap(entity), involvedObjects);
    }

    private <T> Iterable<Key<T>> insert(DBCollection dbColl, Iterable<T> entities, InsertOptions options) {
        if (!entities.iterator().hasNext()) {
            return Collections.emptyList();
        }
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        com.mongodb.InsertOptions insertOptions = options.getOptions();
        for (T entity : entities) {
            if (options.getWriteConcern() == null) {
                insertOptions = this.enforceWriteConcern(options, entity.getClass()).getOptions();
            }
            list.add(this.toDbObject(entity, involvedObjects));
        }
        dbColl.insert(list, insertOptions);
        return this.postSaveOperations(entities, involvedObjects, dbColl);
    }

    private <T> Query<T> newQuery(Class<T> type, DBCollection collection, DBObject query) {
        return this.getQueryFactory().createQuery(this, collection, type, query);
    }

    private <T> Query<T> newQuery(Class<T> type, DBCollection collection) {
        return this.getQueryFactory().createQuery(this, collection, type);
    }

    private long nextValue(Long oldVersion) {
        return oldVersion == null ? 1L : oldVersion + 1L;
    }

    private <T> List<Key<T>> postSaveOperations(Iterable<T> entities, Map<Object, DBObject> involvedObjects, DBCollection collection) {
        return this.postSaveOperations(entities, involvedObjects, collection, true);
    }

    private <T> List<Key<T>> postSaveOperations(Iterable<T> entities, Map<Object, DBObject> involvedObjects, DBCollection collection, boolean fetchKeys) {
        ArrayList<Key<T>> keys = new ArrayList<Key<T>>();
        for (T t : entities) {
            DBObject dbObj = involvedObjects.remove(t);
            if (fetchKeys) {
                if (dbObj.get("_id") == null) {
                    throw new MappingException(String.format("Missing _id after save on %s", t.getClass().getName()));
                }
                this.mapper.updateKeyAndVersionInfo(this, dbObj, this.createCache(), t);
                keys.add(new Key(t.getClass(), collection.getName(), this.mapper.getId(t)));
            }
            this.mapper.getMappedClass(t).callLifecycleMethods(PostPersist.class, t, dbObj, this.mapper);
        }
        for (Map.Entry entry : involvedObjects.entrySet()) {
            Object key = entry.getKey();
            this.mapper.getMappedClass(key).callLifecycleMethods(PostPersist.class, key, (DBObject)entry.getValue(), this.mapper);
        }
        return keys;
    }

    private <T> Query<T> queryByExample(DBCollection coll, T example) {
        Class<?> type = example.getClass();
        DBObject query = this.entityToDBObj(example, new HashMap<Object, DBObject>());
        return this.newQuery(type, coll, query);
    }

    private <T> DBObject toDbObject(T ent, Map<Object, DBObject> involvedObjects) {
        MappedClass mc = this.mapper.getMappedClass(ent);
        if (mc.getAnnotation(NotSaved.class) != null) {
            throw new MappingException(String.format("Entity type: %s is marked as NotSaved which means you should not try to save it!", mc.getClazz().getName()));
        }
        DBObject dbObject = this.entityToDBObj(ent, involvedObjects);
        List<MappedField> versionFields = mc.getFieldsAnnotatedWith(Version.class);
        for (MappedField mappedField : versionFields) {
            String name = mappedField.getNameToStore();
            if (dbObject.get(name) != null) continue;
            dbObject.put(name, 1);
            mappedField.setFieldValue(ent, 1L);
        }
        return dbObject;
    }

    @Override
    public <T> UpdateResults update(Query<T> query, UpdateOperations<T> operations, UpdateOptions options) {
        DBCollection dbColl = query.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection((Class)query.getEntityClass());
        }
        MappedClass mc = this.getMapper().getMappedClass(query.getEntityClass());
        List<MappedField> fields = mc.getFieldsAnnotatedWith(Version.class);
        DBObject queryObject = query.getQueryObject();
        if (operations.isIsolated()) {
            queryObject.put("$isolated", true);
        }
        if (!fields.isEmpty()) {
            operations.inc(fields.get(0).getNameToStore(), 1);
        }
        BasicDBObject update = (BasicDBObject)((UpdateOpsImpl)operations).getOps();
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Executing update(%s) for query: %s, ops: %s, multi: %s, upsert: %s", dbColl.getName(), queryObject, update, options.isMulti(), options.isUpsert()));
        }
        return new UpdateResults(dbColl.update(queryObject, update, this.enforceWriteConcern(options, query.getEntityClass()).getOptions()));
    }

    private <T> UpdateResults update(Query<T> query, DBObject update, boolean createIfMissing, boolean multi, WriteConcern wc) {
        return this.update(query, update, new UpdateOptions().upsert(createIfMissing).multi(multi).writeConcern(wc));
    }

    private <T> UpdateResults update(Query<T> query, DBObject update, UpdateOptions options) {
        MappedField versionMF;
        DBCollection dbColl = query.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection((Class)query.getEntityClass());
        }
        if (query.getSortObject() != null && query.getSortObject().keySet() != null && !query.getSortObject().keySet().isEmpty()) {
            throw new QueryException("sorting is not allowed for updates.");
        }
        if (query.getOffset() > 0) {
            throw new QueryException("a query offset is not allowed for updates.");
        }
        if (query.getLimit() > 0) {
            throw new QueryException("a query limit is not allowed for updates.");
        }
        DBObject queryObject = query.getQueryObject();
        MappedClass mc = this.getMapper().getMappedClass(query.getEntityClass());
        List<MappedField> fields = mc.getFieldsAnnotatedWith(Version.class);
        if (!fields.isEmpty() && update.get((versionMF = fields.get(0)).getNameToStore()) == null) {
            if (!update.containsField("$inc")) {
                update.put("$inc", new BasicDBObject(versionMF.getNameToStore(), (Object)1));
            } else {
                ((Map)update.get("$inc")).put(versionMF.getNameToStore(), 1);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Executing update(%s) for query: %s, ops: %s, multi: %s, upsert: %s", dbColl.getName(), queryObject, update, options.isMulti(), options.isUpsert()));
        }
        return new UpdateResults(dbColl.update(queryObject, update, this.enforceWriteConcern(options, query.getEntityClass()).getOptions()));
    }

    private WriteConcern getWriteConcern(Object clazzOrEntity) {
        Entity entityAnn;
        WriteConcern wc = this.defConcern;
        if (clazzOrEntity != null && (entityAnn = this.getMapper().getMappedClass(clazzOrEntity).getEntityAnnotation()) != null && entityAnn.concern().length() != 0) {
            wc = WriteConcern.valueOf(entityAnn.concern());
        }
        return wc;
    }
}

