/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.mongodb.morphia.mapping.MappingException;

abstract class AnnotationBuilder<T extends Annotation>
implements Annotation {
    private final Map<String, Object> values = new HashMap<String, Object>();

    AnnotationBuilder() {
        for (Method method : this.annotationType().getDeclaredMethods()) {
            this.values.put(method.getName(), method.getDefaultValue());
        }
    }

    AnnotationBuilder(T original) {
        try {
            for (Method method : this.annotationType().getDeclaredMethods()) {
                this.values.put(method.getName(), method.invoke(original, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    <V> V get(String key) {
        return (V)this.values.get(key);
    }

    void put(String key, Object value) {
        if (value != null) {
            this.values.put(key, value);
        }
    }

    void putAll(Map<String, Object> map) {
        this.values.putAll(map);
    }

    @Override
    public String toString() {
        return String.format("@%s %s", this.annotationType().getName(), this.values.toString());
    }

    public abstract Class<T> annotationType();

    static <A extends Annotation> Map<String, Object> toMap(A annotation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            for (Method method : annotationType.getDeclaredMethods()) {
                Object value = method.invoke(annotation, new Object[0]);
                if (method.getDefaultValue().equals(value)) continue;
                map.put(method.getName(), value);
            }
        }
        catch (Exception e) {
            throw new MappingException(e.getMessage(), e);
        }
        return map;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationBuilder)) {
            return false;
        }
        return this.values.equals(((AnnotationBuilder)o).values);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }
}

