/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.factory;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.AbstractProxyFactory;
import com.thoughtworks.proxy.factory.InvokerReference;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.toys.nullobject.Null;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CglibProxyFactory
extends AbstractProxyFactory {
    private static final long serialVersionUID = -5615928639194345818L;
    private static final ThreadLocal<List<Class<?>>> cycleGuard = new ThreadLocal();
    private static final ProxyFactory standardProxyFactory = new StandardProxyFactory();
    private transient ForeignPackageNamingPolicy namingPolicy = new ForeignPackageNamingPolicy();

    @Override
    public <T> T createProxy(Invoker invoker, Class<?> ... types) {
        Class<?> type = this.getSingleClass(types);
        if (type == null) {
            return standardProxyFactory.createProxy(invoker, types);
        }
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot subclass primitive type");
        }
        Class[] interfaces = this.getInterfaces(types);
        Enhancer enhancer = new Enhancer();
        while (true) {
            enhancer.setSuperclass(type);
            enhancer.setInterfaces(interfaces);
            enhancer.setCallback(new CGLIBInvocationHandlerAdapter(invoker));
            try {
                Object proxy = enhancer.create();
                return (T)proxy;
            }
            catch (CodeGenerationException e) {
                Throwable wrapper = e.getCause();
                if (wrapper == null || !(wrapper.getCause() instanceof SecurityException) || enhancer.getNamingPolicy() == this.namingPolicy) break;
                enhancer.setNamingPolicy(this.namingPolicy);
                continue;
            }
            catch (IllegalArgumentException e) {
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            break;
        }
        Object proxy = this.createWithConstructor(type, enhancer);
        return (T)proxy;
    }

    private Class<?>[] getInterfaces(Class<?>[] types) {
        ArrayList interfaces = new ArrayList(Arrays.asList(types));
        Iterator iterator = interfaces.iterator();
        while (iterator.hasNext()) {
            Class type = (Class)iterator.next();
            if (type.isInterface()) continue;
            iterator.remove();
        }
        interfaces.add(InvokerReference.class);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private Class<?> getSingleClass(Class<?>[] types) {
        for (Class<?> type : types) {
            if (type.isInterface()) continue;
            return type;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createWithConstructor(Class<?> type, Enhancer enhancer) {
        Constructor<?> constructor = this.getConstructor(type);
        Class[] params = constructor.getParameterTypes();
        Object[] args = new Object[params.length];
        if (cycleGuard.get() == null) {
            cycleGuard.set(new ArrayList());
        }
        List<Class<?>> creating = cycleGuard.get();
        for (int i = 0; i < args.length; ++i) {
            if (!creating.contains(params[i])) {
                creating.add(params[i]);
                try {
                    args[i] = Null.proxy(params[i]).build(this);
                    continue;
                }
                finally {
                    creating.remove(params[i]);
                }
            }
            args[i] = null;
        }
        return enhancer.create(params, args);
    }

    private Constructor<?> getConstructor(Class<?> type) {
        try {
            return type.getConstructor((Class[])Class[].class.cast(null));
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] constructors = type.getConstructors();
            if (constructors.length == 0) {
                constructors = type.getDeclaredConstructors();
            }
            if (constructors.length == 0) {
                throw new IllegalArgumentException("Cannot create proxy for this type without declared constructor.");
            }
            return constructors[0];
        }
    }

    @Override
    public boolean canProxy(Class<?> type) {
        return !Modifier.isFinal(type.getModifiers());
    }

    @Override
    public boolean isProxyClass(Class<?> type) {
        return Factory.class.isAssignableFrom(type) || !type.equals(Object.class) && Proxy.isProxyClass(type) || standardProxyFactory.isProxyClass(type);
    }

    private Object readResolve() {
        this.namingPolicy = new ForeignPackageNamingPolicy();
        return this;
    }

    private static class ForeignPackageNamingPolicy
    extends DefaultNamingPolicy {
        private ForeignPackageNamingPolicy() {
        }

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return this.getClass().getPackage().getName() + ".proxy." + super.getClassName(prefix, source, key, names);
        }
    }

    static class CGLIBInvocationHandlerAdapter
    extends AbstractProxyFactory.CoincidentalInvocationHandlerAdapter
    implements InvocationHandler {
        private static final long serialVersionUID = 418834172207536454L;

        public CGLIBInvocationHandlerAdapter(Invoker invoker) {
            super(invoker);
        }
    }
}

