/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MD5Generator {
    private static Logger logger = LoggerFactory.getLogger(MD5Generator.class);

    private MD5Generator() {
    }

    public static String generateMD5OfFile(File file) {
        String md5 = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
                md5 = new String(Hex.encodeHex(DigestUtils.md5(input)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            logger.trace("Exception Trace : " + exception);
            logger.error(exception.getMessage());
        }
        return md5;
    }

    public static String generateMD5OfString(String convertTo) {
        return new String(Hex.encodeHex(DigestUtils.md5(convertTo)));
    }

    public static String getChunkNewCollectionName(String md5) {
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % 101);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }
}

