#!/bin/bash
#

PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh

PARABLU_WATCHDOG_CONFIG=./watchdog_config.sh
PARABLU_WATCHDOG_FUNCTIONS=./watchdog_common_functions.sh

source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_WATCHDOG_CONFIG
source $PARABLU_WATCHDOG_FUNCTIONS

export PATH=$PATH:/sbin
export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"

function service_stop_status ()
{

if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] || [[ "$SERVER_TYPE" == "2" ]];then
        echo 'use parablu001

db.PRIVACY_GATEWAY.find({"gatewayName" : "GATEWAY_NAME"}).forEach(function(e) {print("SERVICESTOP=" +e.isActive)})' >capture_servicestop.js

        sed -i "s|GATEWAY_NAME|$BLUKRYPT_IP|g" capture_servicestop.js

        sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < capture_servicestop.js > capture_servicestop

        SERVICESTOP=`grep "SERVICESTOP" capture_servicestop`
        BK_ACTIVE=$( echo $SERVICESTOP | sed -e 's/SERVICESTOP=//')
else

        ###OTHER SERVERS
        #BK_ACTIVE=true
        echo "NOT BLUKRYPT SERVER"
fi

}
function disk_check ()
{

        ## START CHECKING DISK
	service_stop_status
  if [ "$BK_ACTIVE" != "false" ]; then
        for wc_disc in ${WATCHDOG_DISK[@]}
        do
                MEMORY_USED_INSLASH=$(df -h $wc_disc | tail -1 | awk '{print $5}')
                WARN_MEMORY_LIMIT="75%"
                MAX_MEMORY_LIMIT="90%"
                if [[ ${MEMORY_USED_INSLASH%?} -ge ${WARN_MEMORY_LIMIT%?} ]] && [[ ${MEMORY_USED_INSLASH%?} -lt ${MAX_MEMORY_LIMIT%?} ]];then
                        ###### Send Disk Alert
                        Enable_incoming+=("no")
                        df -h $wc_disc | grep "$wc_disc"
                        if [ $? -eq 0 ]; then
                                INITIAL_DISK_STATUS+=([ $wc_disc is ${MEMORY_USED_INSLASH%?} ])
                        fi

                        if [  -f incoming_stopped ];then
                                echo "Already stopped"
                        else
                                touch INITIAL_ALERT_START
                        fi

                elif [[ ${MEMORY_USED_INSLASH%?} -ge ${MAX_MEMORY_LIMIT%?} ]];then
                        ######Stop All Incoming
                        touch incoming_stopped
                        Enable_incoming+=("no")
                        df -h $wc_disc | grep "$wc_disc"
                        if [ $? -eq 0 ]; then
                                FINAL_DISK_STATUS+=([ $wc_disc is ${MEMORY_USED_INSLASH%?} ])
                        fi

                elif [[ ${MEMORY_USED_INSLASH%?} -lt ${WARN_MEMORY_LIMIT%?} ]];then
                        Enable_incoming+=("yes")
                        DISK_STATUS+=([ $wc_disc is ${MEMORY_USED_INSLASH%?} ])

                fi
        done
        ####### END OF DISK CHECK
        ##### INITIAL ALERT FLAG CHECK
        if [  -f INITIAL_ALERT_START ];then

                cat alertmailcontent.txt >$INITIAL_ALERT
                sed -i "s|WARN_ALERT|${INITIAL_DISK_STATUS[*]}|" $INITIAL_ALERT
                sed -i "s|MAX_LIMIT|$MAX_MEMORY_LIMIT|" $INITIAL_ALERT
                echo "DISK ALERT in [$CUSTOMER_NAME] Machine `hostname` at `date`" >$INITIAL_ALERT_SUBJECT
                rm INITIAL_ALERT_START

        fi

        #### DISABLING INCOMINING
        DISK_MSG_SUBJECT="DISK ALERT in [$CUSTOMER_NAME] Machine `hostname` at `date`"
        DISK_MSG_BODY="DISK STATUS: ${FINAL_DISK_STATUS[*]}   ${INITIAL_DISK_STATUS[*]} "
        if [  -f incoming_stopped ];then
                get_supportmail
                if [  ! -f last_pgOverloadLimit ]; then
                        if [[ "$SERVER_TYPE" == "3" ]] || [[ "$SERVER_TYPE" == "1" ]] || [[ "$SERVER_TYPE" == "3 1" ]] || [[ "$SERVER_TYPE" == "6" ]];then
                                echo "NO CHANGES MADE.... ONLY TRIGGERING ALERT"
                                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${DISK_MSG_BODY}"'","subjectData":"'"${DISK_MSG_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/

                        else
                                cat finalalertmailcontent.txt >$FINAL_ALERT
                                sed -i "s|WARN_LIMIT|$WARN_MEMORY_LIMIT|" $FINAL_ALERT
                                sed -i "s|MAX_ALERT|${FINAL_DISK_STATUS[*]}|" $FINAL_ALERT
                                echo "DISK EXCEEDED in [$CUSTOMER_NAME] Machine `hostname` at `date`" >$FINAL_ALERT_SUBJECT
                                ####Make PG OVERLOAD LIMIT zero
                                touch last_pgOverloadLimit
                                cp disable_pgoverloadlimit.js disable_pgoverloadlimit_install.js
                                sleep 1s
                                sed -i "s|GATEWAY_NAME|$BLUKRYPT_IP|g" disable_pgoverloadlimit_install.js
                                sleep 2s
                                sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < disable_pgoverloadlimit_install.js > last_pgOverloadLimit
                                PGOVERLOADLIMIT=`grep "PGOVERLOADLIMIT" last_pgOverloadLimit`
                                PGOVERLOADLIMIT_VAL=$( echo $PGOVERLOADLIMIT | sed -e 's/PGOVERLOADLIMIT=//')
                                sed -i "s|PGOVERLOADLIMIT=.*|PGOVERLOADLIMIT="$PGOVERLOADLIMIT_VAL"|" $PARABLU_COMPONENT_SCRIPT_PATH
                                #service tomcat-pcb1 restart
                                curl -k -X POST https://$BLUKRYPT_IP/BluKryptBuilder/cloud/$CLOUD_NAME/updateProperties/
                        fi

                else
                          if [[ "$SERVER_TYPE" == "3" ]] || [[ "$SERVER_TYPE" == "1" ]] || [[ "$SERVER_TYPE" == "3 1" ]] || [[ "$SERVER_TYPE" == "6" ]];then
                                echo "DO NOTHING"
                                echo "NO CHANGES MADE.... ONLY TRIGGERING ALERT"
                                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${DISK_MSG_BODY}"'","subjectData":"'"${DISK_MSG_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                           else
                                echo "Incoming already stopped"
                                cat afterfinalalertmailcontent.txt >$AFTER_FINAL_ALERT
                                sed -i "s|WARN_LIMIT|$WARN_MEMORY_LIMIT|" $AFTER_FINAL_ALERT
                                echo "SERVICE STOPPED in [$CUSTOMER_NAME] Machine `hostname` at `date`" >$AFTER_FINAL_ALERT_SUBJECT
                           fi
                fi
        fi


        ### Enabling Incoming
        if [  -f incoming_stopped ];then

                echo "${Enable_incoming[*]}" | grep "no"

                if [ $? -eq 0 ]; then

                        echo "DONT ENABLE INCOMING"

                else
                        rm -rf *.tmp
                        sleep 2s
                        echo "ENABLE INCOMING"
                        cat restartalert.txt >$RESTART_ALERT
                        echo "SERVICE RESTARTED in [$CUSTOMER_NAME] Machine `hostname` at `date`" >$RESTART_ALERT_SUBJECT

                        if [[ "$SERVER_TYPE" == "3" ]] || [[ "$SERVER_TYPE" == "1" ]] || [[ "$SERVER_TYPE" == "3 1" ]] || [[ "$SERVER_TYPE" == "6" ]];then

                                echo "NO Changes made to Server"
                        else
                                cp enable_pgoverloadlimit.js enable_pgoverloadlimit_install.js
                                sleep 1s
                                sed -i "s|GATEWAY_NAME|$BLUKRYPT_IP|" enable_pgoverloadlimit_install.js
                                sed -i "s|PGOVERLOADLIMIT|$PGOVERLOADLIMIT|" enable_pgoverloadlimit_install.js
                                sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < enable_pgoverloadlimit_install.js
                                #service tomcat-pcb1 restart
                                curl -k -X POST https://$BLUKRYPT_IP/BluKryptBuilder/cloud/$CLOUD_NAME/updateProperties/
                                mv last_pgOverloadLimit old_info/last_pgOverloadLimit-$date_time
                        fi

                                mv incoming_stopped old_info/incoming_stopped-$date_time
                fi

        fi
fi

 }
 disk_check

