<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Helpers\Auth;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='adCredentials'?></span>
            <div class="row">
                <div class="panel adPanel col-lg-12">
                    <div class="panel-heading">
                        <?php if(maxADGroup == false){ ?>
                        <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('activeDirectoryCredentials', 'keywords')?><span class="pull-right" id="adButton" data-toggle="tooltip" data-placement="top" style="cursor: not-allowed";><a class="btn btn-success btn-small adButton" href="" data-toggle="modal" data-target="#addad"><?=Language::show('addAd', 'keywords');?></a></span></h4>
                        <?php } else {?>
                        <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('activeDirectoryCredentials', 'keywords')?><span class="pull-right"><a class="btn btn-success btn-small" href="" data-toggle="modal" data-target="#addad"><?=Language::show('addAd', 'keywords');?></a></span></h4>
                        <?php } ?>
                    </div>

                   <div class="row" id="noActive" style="display:none;">
                        <div class="col-lg-12">
                            <h2 align="center">No Active Directory Credentials found</h2>
                        </div>
                    </div>
                    
                    <div class="panel-body table-responsive" ng-if="adcS.length > 0">
                        <div class="row col-lg-12">
                            <table id="example" class="table table-bordered table-striped adtableList">
                            <thead>
                            <tr>
                                <th class="text-left"><?=Language::show('userDomainName', 'keywords')?></th>
                                <th class="text-left"><?=Language::show('activeDirectoryProductType', 'keywords')?></th>
                                <th class="text-left"><?=Language::show('activeDirectoryCommonName', 'keywords')?></th>
                                <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody ng-cloak>
                            <tr ng-repeat="value in adcS track by $index">
                                <td > {{ value.userDn }}</td>
                                <?php if(BLUDRIVE_MODE == false){?>
                                    <td ng-if="value.adProductType=='sync'">BluSync</td>
                                <?php } else { ?>
                                    <td ng-if="value.adProductType=='sync'">BluDrive</td>
                                <?php } ?>
                                <td ng-if="value.adProductType=='backup'">BluVault</td>
                                <td ng-if="value.adProductType=='O365'">Office365</td>
                                <td>{{ value.adCn }}</td>
                                <td>
                                   <a style="margin-top: 5px;" class="btn btn-success btn-small" ng-click="getAdCredentials($index)">Edit</a>
                                    <a style="margin-top: 5px;" class="btn btn-danger btn-small removeCredentialsBtn{{$index}}" ng-click="removeAdCredentials($index)">Delete</a> 
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        </div>
                        <div ng-repeat="value in adcS track by $index" class="d-none col-lg-6 ng-scope block-ui block-ui-anim-fade" block-ui="myBlockUI" aria-busy="false">
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-language"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <span class="d-none" ng-if="value.userDn.length > 0">
                                        <a>Id: </a><a class="pull-right">{{ value.id }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.userDn.length > 0">
                                        <a>User Domain Name: </a><a ng-cloak class="pull-right">{{ value.userDn }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adPassword.length > 0">
                                        <a>Active Directory Password: </a><a ng-cloak class="pull-right">**********</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adUrl.length > 0">
                                        <a>Active Directory URL: </a><a ng-cloak class="pull-right">{{ value.adUrl }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adBase.length > 0">
                                        <a>Active Directory Base: </a><a ng-cloak class="pull-right">{{ value.adBase }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adGroupName.length > 0">
                                        <a>Active Directory Group Name: </a><a ng-cloak class="pull-right">{{ value.adGroupName }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adProductType.length > 0">
                                        <a>Active Directory Product Type: </a>
<?php if(DISABLE_BLUSYNC == false){ ?>
					<a ng-cloak ng-if="value.adProductType=='sync'" class="pull-right"> BluSync</a>
<?php } ?>
<?php if(DISABLE_BLUVAULT == false){ ?>
                                        <a ng-cloak ng-if="value.adProductType=='backup'" class="pull-right"> BluVault</a>
<?php } ?>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adBase.length > 0">
                                        <a>Active Directory Common Name: </a><a ng-cloak class="pull-right">{{ value.adCn }}</a>
                                        <br/>
                                    </span>
                                </div>
                                <div class="panel-footer">
                                    <a style="margin-top: 5px;" class="btn btn-primary btn-small" ng-click="getAdCredentials($index)">Edit</a>
                                    <a style="margin-top: 5px;" class="btn btn-danger btn-small removeCredentialsBtn{{$index}}" ng-click="removeAdCredentials($index)">Delete</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

<!-- kjdbvjdkbvjbf start -->
<div class="modal fade" id="addad" tabindex="-1" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?= Form::open(array(
                            'ng-submit' => 'saveAdCredentials("createAdCredentials")',
                            'class' => 'createAdCredentials',
			    'id' => 'createAdCredentials',
                            'csrf' => $data['csrf_token'],
                            'data-parsley-validate' => true,
                            'autocomplete' => 'off'
                            )); ?>
                            <div class="modal-header">
				<h4 class="modal-title"><?=Language::show('addYourActiveDirectoryCredentials', 'keywords')?></h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="d-none">
                                                <label for="pubkey">Public Key</label><br/>
                            <textarea id="pubkey" rows="15" cols="65">-----BEGIN PUBLIC KEY-----
                        MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJa13jCuhhMNQfcXb6uRJEnKkQ
                        BQxpl1Dp5U8EDbo16KrSDT++OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulq
                        Ig8Tca9eg/uVjg2DHs4wIyzNJ7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+x
                        VCPksMvihMgXe2xLdwIDAQAB
                        -----END PUBLIC KEY-----</textarea><br/>
                        </div>
                                    <div class="form-group col-lg-6">
                                    <label for="userDn"><?=Language::show('userDomainName', 'keywords')?></label>
                                    <input type="text" class="form-control" name="userDn" id="userDn" value="" placeholder="Enter User Domains" required autocomplete="off" onfocusout="checkUserDn()">
                                    <span id="userDnerror" style="color: #f55753;font-size: 0.9em;"></span>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="adPassword"><?=Language::show('aDPassword', 'keywords')?></label>
                                    <input type="password" class="form-control" name="adPassword" id="adPassword" value="" placeholder="Enter Active Directory Password" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="adBase"><?=Language::show('aDBase', 'keywords')?></label>
                                    <input type="text" class="form-control" name="adBase" id="adBase" value="" placeholder="Enter Active Directory Base" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6" style="margin-bottom:25px !important;">
                                    <label for="adCn"><?=Language::show('activeDirectoryCommonName', 'keywords')?></label>
                                    <!--<input type="text" class="form-control" name="adCn" id="adCn" value="" placeholder="Enter your Active Directory Common Name" required autocomplete="off">-->
                                    <select class="form-control adCn selectpicker" name="adCn" id="adCn" title="Select Active Directory Common name" required="required" >
                                         <option value="cn"><?=Language::show('cn', 'keywords')?></option>
                                         <option value="sAMAccountName"><?=Language::show('sAMAccountName', 'keywords')?></option>
                                     </select>
                                </div>
                                <div class="form-group col-lg-6 adUrl">
                                    <label for="adUrl"><?=Language::show('aDUrl', 'keywords')?></label>
                                    <input type="text" class="form-control" name="adUrl" id="adUrl" value="" placeholder="Enter Active Directory URL" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6" style="margin-bottom:40px !important;">
                                    <label for="adPort"><?=Language::show('AD Port', 'keywords')?></label>
                                    <input type="number" class="form-control" name="adPort" id="adPort" value="" placeholder="Enter AD port number" autocomplete="off">
                                </div>
				<div class="form-group col-lg-6">
				    <label for="adProductType"><?=Language::show('Select Product Type', 'keywords')?></label>
                                    <select class="form-control adProductType selectpicker" name="adProductType" id="adProductType" title='Select Product Type' required>
                                        <?php if(Auth::checkCloudPermission('backup')){ ?>
                                        	<option value="BluVault"><?=Language::show('bluVault', 'keywords')?></option>
                                        <?php } ?>
                                        <?php if(Auth::checkCloudPermission('office365')){ ?>
                                        	<option value="O365"><?=Language::show('Office365', 'keywords')?></option>
                                        <?php } ?>
                                        <?php if(Auth::checkCloudPermission('sync')){ ?>
                                        	<?php if(BLUDRIVE_MODE == false){ ?>
                                        		<option value="BluSync"><?=Language::show('bluSync', 'keywords')?></option>
                                        	<?php } else { ?>
                                        		<option value="BluSync"><?=Language::show('BluDrive', 'keywords')?></option>
                                        	<?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="adGroupName"><?=Language::show('aDGroupName', 'keywords')?></label>
                                    <input type="text" class="form-control" name="adGroupName" id="adGroupName" value="" placeholder="Enter AD Group Name" autocomplete="off">
                                </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success createCredentialsBtn"><?=Language::show('Save', 'keywords')?></button>
                                <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>
                            </div>
                <?= Form::close(); ?>
                 </div>
        </div>
    </div>
<!-- jkdbvjdbvdbvj ends-->
                
                
    
                
          
    <div class="modal fade" id="editAdCredentialsModal" tabindex="-1" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?= Form::open(array(
                    'ng-submit' => 'editAdCredentials("editAdCredentials")',
                    'class' => 'editAdCredentials',
		    'id' => 'editAdCredentials',
                    'csrf' => $data['csrf_token'],
                    'autocomplete' => 'off',
                    'data-parsley-validate' => true
                )); ?>
                <div class="modal-header">
		    <h4 class="modal-title">Edit Active Directory Credentials</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="row">
<div class="d-none">
                            <label for="privkey">Private Key</label><br/>
                <textarea id="privkey1" rows="15" cols="65">-----BEGIN RSA PRIVATE KEY-----
            MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
            OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
            J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
            AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
            DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
            ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
            jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
            l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
            Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
            ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
            DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
            JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
            WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
            -----END RSA PRIVATE KEY-----</textarea><br/>
                <label for="pubkey">Public Key</label><br/>
                <textarea id="pubkeyedit" rows="15" cols="65">-----BEGIN PUBLIC KEY-----
            MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJa13jCuhhMNQfcXb6uRJEnKkQ
            BQxpl1Dp5U8EDbo16KrSDT++OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulq
            Ig8Tca9eg/uVjg2DHs4wIyzNJ7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+x
            VCPksMvihMgXe2xLdwIDAQAB
            -----END PUBLIC KEY-----</textarea><br/>
            </div>
                        <div class="form-group col-lg-6 d-none">
                            <label for="id">Id</label>
                            <input type="text" class="form-control" name="id" id="id" placeholder="id" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="userDn">User Domain</label>
                            <input type="text" class="form-control" name="userDn" id="editUserDn" placeholder="Enter User Domains" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adPassword">AD Password</label>
                            <input type="password" class="form-control" name="editAdPassword" id="editAdPassword" placeholder="Enter Active Directory Password" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adBase">AD Base</label>
                            <input type="text" class="form-control" name="adBase" id="editAdBase" placeholder="Enter Active Directory Base" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6" style="margin-bottom:20px !important;">
                            <label for="adCn">AD Common Name</label>
                            <!--<input type="text" class="form-control" name="adCn" id="editAdCn" placeholder="Enter your Active Directory Common Name" required autocomplete="off">-->
                            <select class="form-control editAdCn selectpicker" name="editAdCn" id="editAdCn" required="required" >
                                 <option value="cn"><?=Language::show('cn', 'keywords')?></option>
                                 <option value="sAMAccountName"><?=Language::show('sAMAccountName', 'keywords')?></option>
                             </select>
                        </div>
                        <div class="form-group col-lg-6 adUrl">
                            <label for="adUrl">AD URL</label>
                            <input type="text" class="form-control" name="adUrl" id="editAdUrl" placeholder="Enter Active Directory URL" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adPort"><?=Language::show('AD Port', 'keywords')?></label>
                            <input type="number" class="form-control" name="adPort" id="editAdPort" value="" placeholder="Enter AD port number" autocomplete="off">
                        </div>
				<div class="form-group col-lg-6">
				<label for="adProductType"><?=Language::show('Select Product Type', 'keywords')?></label>
		                    <select class="form-control adProductType selectpicker" name="adProductType" id="editAdProductType" title='Select Product Type' required>
                            	<?php if(Auth::checkCloudPermission('backup')){ ?>
                            	    <option value="BluVault"><?=Language::show('bluVault', 'keywords')?></option>
                                <?php } ?>
                                <?php if(Auth::checkCloudPermission('office365')){ ?>
                                	<option value="O365"><?=Language::show('Office365', 'keywords')?></option>
                                <?php } ?>
                                <?php if(Auth::checkCloudPermission('sync')){ ?>
                                	<?php if(BLUDRIVE_MODE == false){ ?>
                                		<option value="BluSync"><?=Language::show('bluSync', 'keywords')?></option>
                                	<?php } else { ?>
                                		<option value="BluSync"><?=Language::show('BluDrive', 'keywords')?></option>
                                	<?php } ?>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adGroupName">AD Group Name</label>
                            <input type="text" class="form-control" name="adGroupName" id="editAdGroupName" value="" placeholder="Enter AD Group Name" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success editCredentialsBtn">Save</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
</div>  </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
function checkUserDn(){
    var userDn = $('#userDn').val();
    if(userDn.startsWith(" ") || userDn.endsWith(" ")){
        $('#userDn').addClass('parsley-error');
        document.getElementById("adPassword").style.marginBottom = "40px";
        document.getElementById("userDnerror").innerHTML = "User Domain Name cannot have space in beginning or end";
    }else{
        $('#userDn').removeClass('parsley-error');
        document.getElementById("userDnerror").innerHTML = " ";
        document.getElementById("adPassword").style.marginBottom = "15px";
    }
}

</script>
