<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;
/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class User extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('User Model was called', 'info');
    }

    public function getCloudCredentials($headers){
        $url = $this->api->getUrl('getCloudCredentials');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @return array
     */
    public function getUserDetails($headers, $username){
        $url = $this->api->getUrl('userDetails');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.str_replace(' ', '%20', $username).DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log($url.DS.str_replace(' ', '%20', $username).DS, 'info');
        $this->log('headers: '.json_encode($headers), 'info');
        $this->log(json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @return array
     */
    public function getDeviceDetails($headers){
        $url = $this->api->getUrl('getDeviceDetails');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * below method Gets all the devices
     * of a particular user
     *
     * @param $headers
     * @return array
     */
    public function getUserDevices($headers){
        $url = $this->api->getUrl('myDevices');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'header' => $this->curl->response_headers,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below method Gets all the Mini Clouds
     *
     * @param $headers
     * @return array
     */
    public function getAllMiniClouds($headers){
        $url = $this->api->getUrl('allMiniClouds');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below method Gets all User Names
     *
     * @param $headers
     * @return array
     */
    public function getAllNames($headers){
        $url = $this->api->getUrl('allUserNames');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'url' => $url,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Updates the user Details
     *
     * @param $headers
     * @param $userString
     * @param $userName
     * @return array
     */
    public function updateUserDetails($headers, $userString, $userName){
        $url = $this->api->getUrl('updateUserDetails', array('userName' => $userName));
        $data = array(
                        $userString,
                        $userName                    
        );
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $userString);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function setpassword($headers){
        $url = $this->api->getUrl('setpassword');
        $data = array(
                        $userString,
                        $userName
        );
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('URL: '. $url, 'info');
        $this->log('HEADERS`: '. json_encode($headers), 'info');
        $this->curl->put($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Retrieves all the users
     *
     * @param $headers
     * @return array
     */
    public function getAllUsers($headers,$pageNumber){
//        $url = $this->api->getUrl('users');
$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/users/all?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAllUsers1($headers,$url){
$this->log("kkkkkkkkkkkkkkk","info");
//        $url = $this->api->getUrl('users');
$url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Retrieves Users according to search pattern
     *
     * @param $headers
     * @return array
     */
    public function searchForAUser($headers){
        $url = $this->api->getParacloudUrl('searchUser');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Retrieves Users according to search pattern
     *
     * @param $headers
     * @return array
     */
    public function searchUserWithDevice($headers){
        $url = $this->api->getUrl('searchUserWithDevice');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Retrieves all the users
     *
     * @param $headers
     * @return array
     */
    public function getAllUsersWithGroup($headers){
        $url = $this->api->getUrl('usersGroup');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Retrieves Users according to search pattern
     *
     * @param $headers
     * @return array
     */
    public function searchForAUserWithGroup($headers){
        $url = $this->api->getUrl('searchGroupUser');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $username
     * @return array
     */
    public function blockUser($headers, $username){
        $url = $this->api->getUrl('userBlock', array('userName' => $username));
        Model::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $username
     * @return array
     */
    public function deleteUser($headers, $username){
        $url = $this->api->getUrl('userDelete', array('userName' => $username));
        Model::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function bulkCreate($headers, $data){
        $url = $this->api->getParacloudUrl('bulkCreate');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'header' => $this->curl->response_headers,
            'body' => $this->curl->response
        );
        $this->log('Resultfffff: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function userDevicePolicyInfo($headers){
        $url = $this->api->getUrl('userDevicePolicyInfo');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('UserDetails'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $folder
     * @return array
     */
    public function addInclusionFolder($headers, $folder){
        $url = $this->api->getUrl('addInclusionFolder');
        Model::req($url,$headers,$folder);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folder);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function removeInclusionFolder($headers){
        $url = $this->api->getUrl('removeInclusionFolder');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $folder
     * @return array
     */
    public function addExclusionFolder($headers, $folder){
        $url = $this->api->getUrl('addExclusionFolder');
        Model::req($url,$headers,$folder);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folder);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function removeExclusionFolder($headers){
        $url = $this->api->getUrl('removeExclusionFolder');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @return array
     */
    public function getUserData($headers, $username){
        $url = $this->api->getUrl('userDetails');
        Model::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.$username.DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @param $xml
     * @return array
     */
    public function createNewUser($headers, $username, $xml){
        $url = $this->api->getUrl('createNewUser');
        $data = array(
                    $username,
                    $xml
        );
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url.DS.$username.DS, $xml);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below method block a list of users
     * In Header set active true to unblock
     * And set active false to block
     * @param $headers
     * @return array
     */
    public function blockMultipleUsers($headers,$data){
        $url = $this->api->getParacloudUrl('blockMultipleUsers');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function blockUsers($headers, $data){
        $url = $this->api->getParacloudUrl('blockUsers');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('URL: '. $url, 'info');
        $this->log('DATA: '. json_encode($data), 'info');
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Resultfffff: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below method delete a list of users
     *
     * @param $headers
     * @return array
     */
    public function deleteMultipleUsers($headers,$data){
        $url = $this->api->getParacloudUrl('deleteMultipleUsers');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function unblockUsers($headers, $data){
        $url = $this->api->getParacloudUrl('unblockUsers');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('URL: '. $url, 'info');
        $this->log('DATA: '. json_encode($data), 'info');
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Resultfffff: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @return array
     */
    public function getCloudLicense($headers){
        $url = $this->api->getUrl('cloudLicense');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllPolicies($headers){
        $url = $this->api->getUrl('getAllPolices');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllSyncPolicies($headers){
        $url = $this->api->getUrl('getAllSyncPolices');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of User Groups
     *
     * @param $headers
     * @return array
     */
    public function getUserGroups($headers){
        $url = $this->api->getUrl('userGroups');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('url: '. $url, 'info');
        $this->log('headers: '. json_encode($headers), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);

        return $result;
    }

    /**
     * Below method delete a user group
     *
     * @param $headers
     * @param $groupName
     * @return array
     */
    public function deleteUserGroup($headers, $groupName){
        $url = $this->api->getUrl('deleteUserGroup');
        Model::req($url,$headers,$groupName);
        $this->curl->setHeaders($headers);
        $this->curl->post($url.$groupName.'/');
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $emailProps
     * @return array
     */
    public function sendMail($headers, $emailProps){
        $url = $this->api->getUrl('sendMail');
        Model::req($url,$headers,$emailProps);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $emailProps);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Sending Mail for Block Headers and Body'. json_encode($emailProps), 'info');
        $this->log('Sending Mail for Block result'. json_encode($result), 'info');
        $this->log('Sending Mail for Block Url'. $url, 'info');
        Model::res($this->curl->raw_response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getOdbDetails($headers){
        $url = $this->api->getUrl('getOdbDetails');
        Model::req($url,$headers,$emailProps);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

     public function getAllBackupPolicyName($headers){
        $url = $this->api->getUrl('newBackup');
            Model::req($url,$headers,$data);
            $this->curl->setHeaders($headers);
            $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
            $this->log('Result: '. json_encode($result), 'info');
            Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
            return $result;
    }
    
    public function getAllSyncPolicyName($headers){
            $url = $this->api->getUrl('newSync');
            Model::req($url,$headers,$data);
            $this->curl->setHeaders($headers);
            $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
            $this->log('Result: '. json_encode($result), 'info');
            Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
            return $result;
    }
    
    public function exportUserToExcel($headers, $data){
        $url = $this->api->getParacloudUrl('exportUsersToExcel');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getCloudProperties($headers){
         $url = $this->api->getVersionUrl('getCloudProperties');
         Model::req($url,$headers,$cloudDetails);
         $this->log("URL : ".$url,"info");
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
 
     public function getSyncPolicy($headers, $syncPolicyName){
         $url = $this->api->getUrl('getSyncPolicy', array('policyName' => $syncPolicyName));
         $this->log("URL : ".$url,"info");
         $this->log("headers : ".json_encode($headers),"info");
         Model::req($url,$headers,$syncPolicyName);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'url' => $url,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
     
     public function getPolicy($headers, $policyName){
         $url = $this->api->getUrl('getPolicy', array('policyName' => $policyName));
         $this->log("URL : ".$url,"info");
         $this->log("headers : ".json_encode($headers),"info");
         Model::req($url,$headers,$policyName);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'url' => $url,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
    
    public function getAllOneDrivePolicies($headers){
        $url = $this->api->getUrl('getAllOneDrivePolices');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAdCredentials($headers){
        $url = $this->api->getUrl('getAdCredentials');
        Model::req($url,$headers,$cloudDetails);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getUserAssignedDevices($headers){
        $url = $this->api->getParacloudUrl('myAssignedDevices');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'header' => $this->curl->response_headers,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function muxedUsersList($headers){
        $url = $this->api->getParacloudUrl('muxedUsersList');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function startMuxing($headers){
        $url = $this->api->getParacloudUrl('startMuxing');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getDeviceAll($headers, $username){
        $url = $this->api->getParacloudUrl('getDeviceAll', array('userName' => $username));
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getOneDriveDetails($headers){
        $url = $this->api->getUrl('getOneDriveDetails');
        Model::req($url,$headers,$googleDetails);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAadDetails($headers){
        $url = $this->api->getParacloudUrl('getAadDetails');
        $this->log("URL : ".$url,"info");
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getSoftDeleteUsers($headers,$pageNumber){
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/softBlock/users/all?pageNumber=".$pageNumber;
        $this->log("URL : ".$url,"info");
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function recaptcha($data){
        $response = $data;
        $secretKey = "6LdjbN0UAAAAAFvUUJK0CEIRfQtVYaTdFil_at6_";
        $headers = array(
            'Accept'      => 'application/json',
            'Content-Type' => 'application/json',
        );
        $url = 'https://www.google.com/recaptcha/api/siteverify?secret='.$secretKey.'&response='.$response;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('ResultRECAPTCHA: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        $this->log('ResultRECAPTCHA---->: '. json_encode($result['body']), 'info');
        return $result;
    }


}
