/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;

public class RebackupFromDeviceVersion {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase mainPB001DB = client.getDatabase(uri.getDatabase());
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> reBkpCollection = mainPB001DB.getCollection("RE_BACKUP");
        MongoCollection<Document> deviceReBkpTmpColl = db.getCollection("DEVICE_RE_BACKUP_TEMP");
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deleted", false));
        whereQuery.add(new BasicDBObject("blocked", false));
        andQuery.put("$and", whereQuery);
        FindIterable<Document> devices = deviceColl.find(andQuery);
        FindIterable<Document> completedDevices = deviceReBkpTmpColl.find();
        System.out.println(deviceColl.count(andQuery));
        ArrayList<Document> filteredDevice = new ArrayList<Document>();
        for (Document dev2 : devices) {
            try {
                for (Document completedDevice : completedDevices) {
                    if (completedDevice == null || StringUtils.isEmpty(dev2.getString("deviceUUID")) || !completedDevice.getString("deviceUUID").equals(dev2.getString("deviceUUID"))) continue;
                    System.out.println(String.valueOf(dev2.getString("deviceUUID")) + " already completed so skip");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (dev2 == null || StringUtils.isEmpty(dev2.getString("clientVersion")) || RebackupFromDeviceVersion.isInstalledversionLatest("2.5.2.10", dev2.getString("clientVersion"))) continue;
            filteredDevice.add(dev2);
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " filter device count : " + filteredDevice.size());
        filteredDevice.parallelStream().forEach(dev -> {
            FindIterable<Document> folders;
            BasicDBObject folderQuery = new BasicDBObject();
            ArrayList<BasicDBObject> folderWhereQuery = new ArrayList<BasicDBObject>();
            folderWhereQuery.add(new BasicDBObject("deviceUUID", dev.getString("deviceUUID")));
            folderWhereQuery.add(new BasicDBObject("folder", true));
            folderWhereQuery.add(new BasicDBObject("present", true));
            folderQuery.put("$and", folderWhereQuery);
            MongoCollection<Document> bkpColl = db.getCollection(dev.getString("destCollection"));
            ArrayList<Document> allFoldersList = new ArrayList<Document>();
            int skip = 0;
            while ((folders = bkpColl.find(folderQuery).skip(skip * 500).limit(500)).first() != null) {
                for (Document document : folders) {
                    allFoldersList.add(document);
                }
                ++skip;
            }
            System.out.println(String.valueOf(Thread.currentThread().getName()) + " folder is done deviceUUID :" + dev.getString("deviceUUID") + " folders size :" + allFoldersList.size());
            HashMap filesSet = new HashMap();
            try {
                allFoldersList.parallelStream().forEach(devicePath -> {
                    FindIterable files;
                    BasicDBObject filesQuery = new BasicDBObject();
                    String folderName = "";
                    folderName = StringUtils.isEmpty(devicePath.getString("devicePath")) ? devicePath.getString("fileName") : String.valueOf(devicePath.getString("devicePath")) + "/" + devicePath.getString("fileName");
                    ArrayList<BasicDBObject> filesWhereQuery = new ArrayList<BasicDBObject>();
                    filesWhereQuery.add(new BasicDBObject("deviceUUID", dev.getString("deviceUUID")));
                    filesWhereQuery.add(new BasicDBObject("folder", false));
                    filesWhereQuery.add(new BasicDBObject("present", true));
                    filesWhereQuery.add(new BasicDBObject("devicePath", folderName));
                    Pattern pattern = Pattern.compile(String.valueOf(Pattern.quote("pst")) + "$", 2);
                    filesWhereQuery.add(new BasicDBObject("fileName", pattern));
                    filesQuery.put("$and", filesWhereQuery);
                    int fileSkip = 0;
                    while ((files = bkpColl.find(filesQuery).skip(fileSkip * 500).limit(500)).first() != null) {
                        for (Document document2 : files) {
                            filesSet.put(document2.getString("fileName"), document2.getObjectId("_id").toString());
                        }
                        ++fileSkip;
                    }
                    filesSet.size();
                    for (Map.Entry entry : filesSet.entrySet()) {
                        try {
                            Document rebkpFile = new Document();
                            Document bkpFile = (Document)bkpColl.find(new BasicDBObject("_id", new ObjectId((String)entry.getValue()))).first();
                            if (bkpFile == null) continue;
                            String folderPath = "";
                            folderPath = StringUtils.isEmpty(devicePath.getString("devicePath")) ? devicePath.getString("fileName") : String.valueOf(devicePath.getString("devicePath")) + "/" + devicePath.getString("fileName");
                            rebkpFile.put("_id", (Object)new ObjectId((String)entry.getValue()));
                            rebkpFile.put("userName", (Object)bkpFile.getString("userName"));
                            rebkpFile.put("fileName", (Object)bkpFile.getString("fileName"));
                            rebkpFile.put("devicePath", (Object)folderPath);
                            rebkpFile.put("deviceId", (Object)dev.getObjectId("_id").toString());
                            reBkpCollection.insertOne(rebkpFile);
                            System.out.println("inserted");
                        }
                        catch (Exception e) {
                            System.out.println("Exception:" + e.getLocalizedMessage());
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Document deviceReBkpTmp = new Document();
                deviceReBkpTmp.put("deviceUUID", (Object)dev.getString("deviceUUID"));
                deviceReBkpTmpColl.insertOne(deviceReBkpTmp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    public static int VersionCompare(String versionFromServer, String installedVersion) {
        int v2Len;
        int v1Len = StringUtils.countMatches(versionFromServer, ".");
        if (v1Len != (v2Len = StringUtils.countMatches(installedVersion, "."))) {
            int i;
            int count = Math.abs(v1Len - v2Len);
            if (v1Len > v2Len) {
                i = 1;
                while (i <= count) {
                    installedVersion = String.valueOf(installedVersion) + ".0";
                    ++i;
                }
            } else {
                i = 1;
                while (i <= count) {
                    versionFromServer = String.valueOf(versionFromServer) + ".0";
                    ++i;
                }
            }
        }
        if (versionFromServer.equals(installedVersion)) {
            return 0;
        }
        String[] v1Str = StringUtils.split(versionFromServer, ".");
        String[] v2Str = StringUtils.split(installedVersion, ".");
        int i = 0;
        while (i < v1Str.length) {
            int num2;
            int num1 = Integer.parseInt(v1Str[i]);
            if (num1 != (num2 = Integer.parseInt(v2Str[i]))) {
                if (num1 > num2) {
                    return 1;
                }
                return 2;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isInstalledversionLatest(String versionFromServer, String installedVersion) {
        boolean result = false;
        int resu = RebackupFromDeviceVersion.VersionCompare(versionFromServer, installedVersion);
        if (resu == 1) {
            result = false;
        } else if (resu == 2) {
            result = true;
        }
        return result;
    }
}

