/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.artifact;

import java.io.File;
import java.util.Map;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.AbstractArtifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubArtifact
extends AbstractArtifact {
    private final Artifact mainArtifact;
    private final String classifier;
    private final String extension;
    private final File file;

    public SubArtifact(Artifact mainArtifact, String classifier, String extension) {
        this(mainArtifact, classifier, extension, null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, File file) {
        if (mainArtifact == null) {
            throw new IllegalArgumentException("no artifact specified");
        }
        this.mainArtifact = mainArtifact;
        this.classifier = classifier;
        this.extension = extension;
        this.file = file;
    }

    @Override
    public String getGroupId() {
        return this.mainArtifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.mainArtifact.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.mainArtifact.getVersion();
    }

    @Override
    public Artifact setVersion(String version) {
        return new DefaultArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), version, this.getFile(), this.getProperties());
    }

    @Override
    public String getBaseVersion() {
        return this.mainArtifact.getBaseVersion();
    }

    @Override
    public boolean isSnapshot() {
        return this.mainArtifact.isSnapshot();
    }

    @Override
    public String getClassifier() {
        return SubArtifact.expand(this.classifier, this.mainArtifact.getClassifier());
    }

    @Override
    public String getExtension() {
        return SubArtifact.expand(this.extension, this.mainArtifact.getExtension());
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Artifact setFile(File file) {
        if (this.file == null ? file == null : this.file.equals(file)) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, file);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.mainArtifact.getProperty(key, defaultValue);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mainArtifact.getProperties();
    }

    private static String expand(String pattern, String replacement) {
        String result = "";
        if (pattern != null) {
            result = pattern.replace("*", replacement);
            if (replacement.length() <= 0) {
                char c;
                int i;
                if (pattern.startsWith("*")) {
                    for (i = 0; i < result.length() && ((c = result.charAt(i)) == '-' || c == '.'); ++i) {
                    }
                    result = result.substring(i);
                }
                if (pattern.endsWith("*")) {
                    for (i = result.length() - 1; i >= 0 && ((c = result.charAt(i)) == '-' || c == '.'); --i) {
                    }
                    result = result.substring(0, i + 1);
                }
            }
        }
        return result;
    }
}

