/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.utility.EmailProps;
import com.utility.EmailRecipent;
import com.utility.HttpClientUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.configuration.ConfigurationException;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class CheckBackupSize {
    static String mongoIP = "";
    static String mongoPort = "";
    static long maxPercentage = 0L;
    static String paramailURL = "";

    public static void main(String[] args) throws ConfigurationException {
        if (args.length != 4) {
            System.out.println(" mongoIP/ mongoPort/ maxPercentage/ paramailURL/");
            System.exit(400);
        }
        mongoIP = args[0];
        mongoPort = args[1];
        maxPercentage = Long.parseLong(args[2]);
        paramailURL = args[3];
        if (!paramailURL.endsWith("/")) {
            paramailURL = String.valueOf(String.valueOf(paramailURL)) + "/";
        }
        MongoDatabase db = null;
        long percent = 0L;
        try {
            long storageLimitInKb;
            MongoClientURI parabluURI = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu");
            MongoClient parabluClient = new MongoClient(parabluURI);
            MongoDatabase parabluDB = parabluClient.getDatabase(parabluURI.getDatabase());
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            MongoClient client = new MongoClient(uri);
            db = client.getDatabase(uri.getDatabase());
            MongoCollection collection = parabluDB.getCollection("CLOUD_PROPERTIES");
            Iterator cloudProperties = (Document)collection.find().first();
            if (cloudProperties == null || cloudProperties.get("storageLimitInKb") == null) {
                System.out.println("In cloud property storageLimitInKb is empty...");
                System.exit(1);
            }
            if ((storageLimitInKb = cloudProperties.getLong("storageLimitInKb").longValue()) <= 0L) {
                System.out.println("In cloud property storageLimitInKb is empty...");
                System.exit(1);
            }
            System.out.println("storageLimitInKb in cloud properties..." + storageLimitInKb);
            MongoCollection deviceBkpOverview = db.getCollection("DEVICE_BACKUP_OVERVIEW");
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("isDeviceDeleted", (Object)false));
            whereQuery.add(new BasicDBObject("isUserDeleted", (Object)false));
            andQuery.put((Object)"$and", whereQuery);
            FindIterable overviews = deviceBkpOverview.find((Bson)andQuery);
            long storageUtilized = 0L;
            for (Document overview : overviews) {
                if (overview == null) continue;
                long size = overview.getLong((Object)"storageUtilized");
                storageUtilized += size;
            }
            System.out.println("storageUtilized in backupOverview tables..." + storageUtilized);
            percent = storageUtilized * 100L / storageLimitInKb;
            System.out.println("percent=" + percent);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (percent > maxPercentage) {
            try {
                if (percent > 100L) {
                    percent = 100L;
                }
                MongoCollection usersDB = db.getCollection("USER");
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("admin", (Object)true));
                whereQuery.add(new BasicDBObject("active", (Object)true));
                andQuery.put((Object)"$and", whereQuery);
                FindIterable users = usersDB.find((Bson)andQuery);
                ArrayList<EmailRecipent> recipents = new ArrayList<EmailRecipent>();
                for (Document user : users) {
                    EmailRecipent emailRecipent = new EmailRecipent();
                    emailRecipent.setUserName(user.getString((Object)"userName"));
                    emailRecipent.setEmail(user.getString((Object)"emailId"));
                    recipents.add(emailRecipent);
                }
                HttpComponentsClientHttpRequestFactory requestFactory = HttpClientUtil.getHttpRequestFactory();
                RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
                ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
                messageConverters.add(new MappingJackson2HttpMessageConverter());
                restTemplate.setMessageConverters(messageConverters);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                EmailProps emailProps = new EmailProps();
                emailProps.setRecipents(recipents);
                HttpEntity entity = new HttpEntity((Object)emailProps, (MultiValueMap)headers);
                emailProps.setAction("overall-backup-limit-reached");
                emailProps.setFileName(String.valueOf(percent));
                emailProps.setToUser(true);
                String url = String.valueOf(String.valueOf(paramailURL)) + "paramail/send/mail/";
                restTemplate.put(url, (Object)entity, new Object[0]);
            }
            catch (RestClientException e2) {
                e2.printStackTrace();
                System.exit(0);
            }
        }
        System.exit(0);
    }
}

