/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import org.jclouds.rest.internal.BaseHttpApiMetadata;
import org.jclouds.sqs.SQSApi;
import org.jclouds.sqs.config.SQSHttpApiModule;

public class SQSApiMetadata
extends BaseHttpApiMetadata {
    public Builder<?> toBuilder() {
        return (Builder)new ConcreteBuilder().fromApiMetadata(this);
    }

    public SQSApiMetadata() {
        this(new ConcreteBuilder());
    }

    protected SQSApiMetadata(Builder<?> builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.sqs.create-queue.max-retries", "60");
        properties.setProperty("jclouds.sqs.create-queue.retry-interval", "1000");
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        return properties;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseHttpApiMetadata.Builder<SQSApi, T> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("sqs")).name("Amazon Simple Queue Service API")).identityName("Access Key ID")).credentialName("Secret Access Key")).version("2011-10-01")).defaultProperties(SQSApiMetadata.defaultProperties())).defaultEndpoint("https://sqs.us-east-1.amazonaws.com")).documentation(URI.create("http://docs.amazonwebservices.com/AWSSimpleQueueService/latest/APIReference"))).defaultModules(ImmutableSet.of(SQSHttpApiModule.class));
        }

        @Override
        public SQSApiMetadata build() {
            return new SQSApiMetadata(this);
        }
    }
}

