/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.base.Function;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.collect.PagedIterable;
import org.jclouds.collect.PagedIterables;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.options.ListBucketOptions;

public class S3 {
    public static PagedIterable<ObjectMetadata> listBucket(final S3Client s3Client, final String bucket, final ListBucketOptions options) {
        return PagedIterables.advance(ToIterableWithMarker.INSTANCE.apply(s3Client.listBucket(bucket, options)), new Function<Object, IterableWithMarker<ObjectMetadata>>(){

            @Override
            public IterableWithMarker<ObjectMetadata> apply(Object input) {
                return ToIterableWithMarker.INSTANCE.apply(s3Client.listBucket(bucket, options.clone().afterMarker(input.toString())));
            }

            public String toString() {
                return "listBucket(" + options + ")";
            }
        });
    }

    private static enum ToIterableWithMarker implements Function<ListBucketResponse, IterableWithMarker<ObjectMetadata>>
    {
        INSTANCE;


        @Override
        public IterableWithMarker<ObjectMetadata> apply(ListBucketResponse in) {
            return IterableWithMarkers.from(in, in.getNextMarker());
        }
    }
}

