/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancerUsage;

public final class LoadBalancerInfo {
    private final int loadBalancerId;
    private final String loadBalancerName;
    private final Iterable<LoadBalancerUsage> loadBalancerUsageRecords;

    @ConstructorProperties(value={"loadBalancerId", "loadBalancerName", "loadBalancerUsageRecords"})
    protected LoadBalancerInfo(int id, String name, Iterable<LoadBalancerUsage> loadBalancerUsageRecords) {
        this.loadBalancerId = id;
        this.loadBalancerName = Preconditions.checkNotNull(name, "name");
        this.loadBalancerUsageRecords = Preconditions.checkNotNull(loadBalancerUsageRecords, "loadBalancerUsageRecords");
    }

    public int getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public Iterable<LoadBalancerUsage> getLoadBalancerUsage() {
        return this.loadBalancerUsageRecords;
    }

    public int hashCode() {
        return Objects.hashCode(this.loadBalancerId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerInfo that = (LoadBalancerInfo)LoadBalancerInfo.class.cast(obj);
        return Objects.equal(this.loadBalancerId, that.loadBalancerId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("loadBalancerId", this.loadBalancerId).add("loadBalancerName", this.loadBalancerName).add("loadBalancerUsage", this.loadBalancerUsageRecords).toString();
    }
}

