/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.packet.domain.OperatingSystem;

@Singleton
public class OperatingSystemToImage
implements Function<OperatingSystem, Image> {
    private static final Map<String, OsFamily> OTHER_OS_MAP = ImmutableMap.builder().put("nixos", OsFamily.LINUX).put("rancher", OsFamily.LINUX).put("vmware", OsFamily.ESX).build();

    @Override
    public Image apply(OperatingSystem input) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(input.slug());
        builder.name(input.name());
        builder.description(input.name());
        builder.status(Image.Status.AVAILABLE);
        OsFamily family = OperatingSystemToImage.findInStandardFamilies(input.distribution()).or(OperatingSystemToImage.findInOtherOSMap(input.distribution())).or(OsFamily.UNRECOGNIZED);
        builder.operatingSystem(org.jclouds.compute.domain.OperatingSystem.builder().name(input.name()).family(family).description(input.name()).version(input.version()).is64Bit(true).build());
        return builder.build();
    }

    private static Optional<OsFamily> findInStandardFamilies(final String label) {
        return Iterables.tryFind(Arrays.asList(OsFamily.values()), new Predicate<OsFamily>(){

            @Override
            public boolean apply(OsFamily input) {
                return label.contains(input.value());
            }
        });
    }

    private static Optional<OsFamily> findInOtherOSMap(final String label) {
        return Iterables.tryFind(OTHER_OS_MAP.keySet(), new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return label.contains(input);
            }
        }).transform(new Function<String, OsFamily>(){

            @Override
            public OsFamily apply(String input) {
                return (OsFamily)((Object)OTHER_OS_MAP.get(input));
            }
        });
    }
}

