/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.VolumeAttachment;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="compute", namespace="http://docs.openstack.org/compute/ext/os-volume-attachment-update/api/v2", name="VolumeAttachmentUpdate", alias="os-volumes")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/servers")
public interface VolumeAttachmentApi {
    @Named(value="volumeAttachment:list")
    @GET
    @Path(value="/{serverId}/os-volume_attachments")
    @SelectJson(value={"volumeAttachments"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<VolumeAttachment> listAttachmentsOnServer(@PathParam(value="serverId") String var1);

    @Named(value="volumeAttachment:get")
    @GET
    @Path(value="/{serverId}/os-volume_attachments/{id}")
    @SelectJson(value={"volumeAttachment"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public VolumeAttachment getAttachmentForVolumeOnServer(@PathParam(value="id") String var1, @PathParam(value="serverId") String var2);

    @Named(value="volumeAttachment:attach")
    @POST
    @Path(value="/{serverId}/os-volume_attachments")
    @SelectJson(value={"volumeAttachment"})
    @Produces(value={"application/json"})
    @WrapWith(value="volumeAttachment")
    public VolumeAttachment attachVolumeToServerAsDevice(@PayloadParam(value="volumeId") String var1, @PathParam(value="serverId") String var2, @PayloadParam(value="device") String var3);

    @Named(value="volumeAttachment:detach")
    @DELETE
    @Path(value="/{serverId}/os-volume_attachments/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean detachVolumeFromServer(@PathParam(value="id") String var1, @PathParam(value="serverId") String var2);
}

