/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.location.Region;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;

public class NovaSecurityGroupExtension
implements SecurityGroupExtension {
    protected final NovaApi api;
    protected final ListeningExecutorService userExecutor;
    protected final Supplier<Set<String>> regionIds;
    protected final Function<SecurityGroupInRegion, SecurityGroup> groupConverter;
    protected final LoadingCache<RegionAndName, SecurityGroup> groupCreator;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    public NovaSecurityGroupExtension(NovaApi api, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, @Region Supplier<Set<String>> regionIds, Function<SecurityGroupInRegion, SecurityGroup> groupConverter, LoadingCache<RegionAndName, SecurityGroup> groupCreator, GroupNamingConvention.Factory namingConvention) {
        this.api = Preconditions.checkNotNull(api, "api");
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecutor");
        this.regionIds = Preconditions.checkNotNull(regionIds, "regionIds");
        this.groupConverter = Preconditions.checkNotNull(groupConverter, "groupConverter");
        this.groupCreator = Preconditions.checkNotNull(groupCreator, "groupCreator");
        this.namingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention");
    }

    @Override
    public Set<SecurityGroup> listSecurityGroups() {
        Iterable<? extends SecurityGroupInRegion> rawGroups = this.pollSecurityGroups();
        Iterable<SecurityGroup> groups = Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf(groups);
    }

    @Override
    public Set<SecurityGroup> listSecurityGroupsInLocation(Location location) {
        String region = location.getId();
        if (region == null) {
            return ImmutableSet.of();
        }
        return this.listSecurityGroupsInLocation(region);
    }

    public Set<SecurityGroup> listSecurityGroupsInLocation(String region) {
        Iterable<? extends SecurityGroupInRegion> rawGroups = this.pollSecurityGroupsByRegion(region);
        Iterable<SecurityGroup> groups = Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf(groups);
    }

    @Override
    public Set<SecurityGroup> listSecurityGroupsForNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(Preconditions.checkNotNull(id, "id"));
        String region = regionAndId.getRegion();
        Set<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups = this.api.getServerApi(region).listSecurityGroupForServer(regionAndId.getId());
        ImmutableSet<SecurityGroupInRegion> rawGroups = FluentIterable.from(allGroups).transform(this.groupToGroupInRegion(allGroups, region)).toSet();
        return ImmutableSet.copyOf(Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter));
    }

    @Override
    public SecurityGroup getSecurityGroupById(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(Preconditions.checkNotNull(id, "id"));
        String region = regionAndId.getRegion();
        String groupId = regionAndId.getId();
        Optional<SecurityGroupApi> sgApi = this.api.getSecurityGroupApi(region);
        if (!sgApi.isPresent()) {
            return null;
        }
        FluentIterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups = sgApi.get().list();
        SecurityGroupInRegion rawGroup = new SecurityGroupInRegion(sgApi.get().get(groupId), region, allGroups);
        return this.groupConverter.apply(rawGroup);
    }

    @Override
    public SecurityGroup createSecurityGroup(String name, Location location) {
        String region = location.getId();
        if (region == null) {
            return null;
        }
        return this.createSecurityGroup(name, region);
    }

    public SecurityGroup createSecurityGroup(String name, String region) {
        String markerGroup = this.namingConvention.create().sharedNameForGroup(name);
        RegionSecurityGroupNameAndPorts regionAndName = new RegionSecurityGroupNameAndPorts(region, markerGroup, ImmutableSet.of());
        SecurityGroup rawGroup = this.groupCreator.getUnchecked(regionAndName);
        return rawGroup;
    }

    @Override
    public boolean removeSecurityGroup(String id) {
        Preconditions.checkNotNull(id, "id");
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        String region = regionAndId.getRegion();
        String groupId = regionAndId.getId();
        Optional<SecurityGroupApi> sgApi = this.api.getSecurityGroupApi(region);
        if (!sgApi.isPresent()) {
            return false;
        }
        boolean deleted = sgApi.get().delete(groupId);
        for (SecurityGroup cachedSg : this.groupCreator.asMap().values()) {
            if (!id.equals(cachedSg.getId())) continue;
            String groupName = cachedSg.getName();
            this.groupCreator.invalidate(new RegionSecurityGroupNameAndPorts(region, groupName, ImmutableSet.of()));
            break;
        }
        return deleted;
    }

    @Override
    public SecurityGroup addIpPermission(IpPermission ipPermission, SecurityGroup group) {
        String region = group.getLocation().getId();
        RegionAndId groupRegionAndId = RegionAndId.fromSlashEncoded(group.getId());
        String id = groupRegionAndId.getId();
        Optional<SecurityGroupApi> sgApi = this.api.getSecurityGroupApi(region);
        if (!sgApi.isPresent()) {
            return null;
        }
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (String cidr : ipPermission.getCidrBlocks()) {
                sgApi.get().createRuleAllowingCidrBlock(id, ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(ipPermission.getIpProtocol())).fromPort(ipPermission.getFromPort())).toPort(ipPermission.getToPort())).build(), cidr);
            }
        }
        if (!ipPermission.getGroupIds().isEmpty()) {
            for (String regionAndGroupRaw : ipPermission.getGroupIds()) {
                RegionAndId regionAndId = RegionAndId.fromSlashEncoded(regionAndGroupRaw);
                String groupId = regionAndId.getId();
                sgApi.get().createRuleAllowingSecurityGroupId(id, ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(ipPermission.getIpProtocol())).fromPort(ipPermission.getFromPort())).toPort(ipPermission.getToPort())).build(), groupId);
            }
        }
        return this.getSecurityGroupById(RegionAndId.fromRegionAndId(region, id).slashEncode());
    }

    @Override
    public SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.addIpPermission(permBuilder.build(), group);
    }

    @Override
    public SecurityGroup removeIpPermission(IpPermission ipPermission, SecurityGroup group) {
        String region = group.getLocation().getId();
        RegionAndId groupRegionAndId = RegionAndId.fromSlashEncoded(group.getId());
        String id = groupRegionAndId.getId();
        Optional<SecurityGroupApi> sgApi = this.api.getSecurityGroupApi(region);
        if (!sgApi.isPresent()) {
            return null;
        }
        org.jclouds.openstack.nova.v2_0.domain.SecurityGroup securityGroup = sgApi.get().get(id);
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (String cidr : ipPermission.getCidrBlocks()) {
                for (SecurityGroupRule rule : Iterables.filter(securityGroup.getRules(), Predicates.and(SecurityGroupPredicates.ruleCidr(cidr), SecurityGroupPredicates.ruleProtocol(ipPermission.getIpProtocol()), SecurityGroupPredicates.ruleStartPort(ipPermission.getFromPort()), SecurityGroupPredicates.ruleEndPort(ipPermission.getToPort())))) {
                    sgApi.get().deleteRule(rule.getId());
                }
            }
        }
        if (!ipPermission.getGroupIds().isEmpty()) {
            for (String groupId : ipPermission.getGroupIds()) {
                for (SecurityGroupRule rule : Iterables.filter(securityGroup.getRules(), Predicates.and(SecurityGroupPredicates.ruleGroup(groupId), SecurityGroupPredicates.ruleProtocol(ipPermission.getIpProtocol()), SecurityGroupPredicates.ruleStartPort(ipPermission.getFromPort()), SecurityGroupPredicates.ruleEndPort(ipPermission.getToPort())))) {
                    sgApi.get().deleteRule(rule.getId());
                }
            }
        }
        return this.getSecurityGroupById(RegionAndId.fromRegionAndId(region, id).slashEncode());
    }

    @Override
    public SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.removeIpPermission(permBuilder.build(), group);
    }

    @Override
    public boolean supportsTenantIdGroupNamePairs() {
        return false;
    }

    @Override
    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    @Override
    public boolean supportsGroupIds() {
        return true;
    }

    @Override
    public boolean supportsPortRangesForGroups() {
        return false;
    }

    @Override
    public boolean supportsExclusionCidrBlocks() {
        return false;
    }

    protected Iterable<? extends SecurityGroupInRegion> pollSecurityGroups() {
        Iterable<Set<? extends SecurityGroupInRegion>> groups = Iterables.transform((Iterable)this.regionIds.get(), this.allSecurityGroupsInRegion());
        return Iterables.concat(groups);
    }

    protected Iterable<? extends SecurityGroupInRegion> pollSecurityGroupsByRegion(String region) {
        return this.allSecurityGroupsInRegion().apply(region);
    }

    protected Function<String, Set<? extends SecurityGroupInRegion>> allSecurityGroupsInRegion() {
        return new Function<String, Set<? extends SecurityGroupInRegion>>(){

            @Override
            public Set<? extends SecurityGroupInRegion> apply(String from) {
                Optional<SecurityGroupApi> sgApi = NovaSecurityGroupExtension.this.api.getSecurityGroupApi(from);
                if (!sgApi.isPresent()) {
                    return ImmutableSet.of();
                }
                FluentIterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups = sgApi.get().list();
                return allGroups.transform(NovaSecurityGroupExtension.this.groupToGroupInRegion(allGroups, from)).toSet();
            }
        };
    }

    protected Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroupInRegion> groupToGroupInRegion(final Iterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups, final String region) {
        return new Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroupInRegion>(){

            @Override
            public SecurityGroupInRegion apply(org.jclouds.openstack.nova.v2_0.domain.SecurityGroup group) {
                return new SecurityGroupInRegion(group, region, allGroups);
            }
        };
    }
}

