/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.DiskType;
import org.jclouds.googlecomputeengine.internal.BaseCallerArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/diskTypes")
@Consumes(value={"application/json"})
public interface DiskTypeApi {
    @Named(value="DiskTypes:get")
    @GET
    @Path(value="/{diskType}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public DiskType get(@PathParam(value="diskType") String var1);

    @Named(value="DiskTypes:list")
    @GET
    public ListPage<DiskType> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="DiskTypes:list")
    @GET
    @Transform(value=DiskTypePages.class)
    public Iterator<ListPage<DiskType>> list();

    @Named(value="DiskTypes:list")
    @GET
    @Transform(value=DiskTypePages.class)
    public Iterator<ListPage<DiskType>> list(ListOptions var1);

    public static final class DiskTypePages
    extends BaseCallerArg0ToIteratorOfListPage<DiskType, DiskTypePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        DiskTypePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<DiskType>> fetchNextPage(final String zoneName, final ListOptions options) {
            return new Function<String, ListPage<DiskType>>(){

                @Override
                public ListPage<DiskType> apply(String pageToken) {
                    return DiskTypePages.this.api.diskTypesInZone(zoneName).listPage(pageToken, options);
                }
            };
        }
    }
}

