/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;

@Singleton
public class RegionToLocation
implements Function<Region, Location> {
    private final JustProvider justProvider;

    @Inject
    RegionToLocation(JustProvider justProvider) {
        this.justProvider = Preconditions.checkNotNull(justProvider, "justProvider cannot be null");
    }

    @Override
    public Location apply(Region input) {
        LocationBuilder builder = new LocationBuilder();
        builder.id(input.slug());
        builder.description(input.name());
        builder.scope(LocationScope.REGION);
        builder.parent((Location)Iterables.getOnlyElement(this.justProvider.get()));
        builder.iso3166Codes(ImmutableSet.of());
        builder.metadata(ImmutableMap.of("available", input.available(), "features", input.features()));
        return builder.build();
    }
}

