/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.handlers;

import com.google.common.annotations.Beta;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.xml.ErrorHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rest.InsufficientResourcesException;

@Singleton
@Beta
public class CloudWatchErrorHandler
implements HttpErrorHandler {
    private final ParseSax.Factory factory;
    private final Provider<ErrorHandler> handlers;

    @Inject
    CloudWatchErrorHandler(ParseSax.Factory factory, Provider<ErrorHandler> handlers) {
        this.factory = factory;
        this.handlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        Exception exception = new HttpResponseException(command, response);
        try {
            if (response.getPayload() != null) {
                AWSError error = (AWSError)this.factory.create(this.handlers.get()).parse(new String(HttpUtils.closeClientButKeepContentStream(response)));
                exception = this.refineException(new AWSResponseException(command, response, error));
            }
        }
        finally {
            HttpUtils.releasePayload(response);
            command.setException(exception);
        }
    }

    private Exception refineException(AWSResponseException in) {
        int statusCode = in.getResponse().getStatusCode();
        String errorCode = in.getError().getCode();
        String message = in.getError().getMessage();
        if (statusCode == 400) {
            if ("LimitExceeded".equals(errorCode)) {
                return new InsufficientResourcesException(message, in);
            }
            if ("InvalidFormat".equals(errorCode)) {
                return new IllegalArgumentException(message, in);
            }
        }
        return in;
    }
}

