/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.base.Preconditions;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class CreateVpcOptions
extends BaseEC2RequestOptions {
    public static final CreateVpcOptions NONE = new CreateVpcOptions();

    public CreateVpcOptions withInstanceTenancy(String instanceTenancy) {
        this.formParameters.put("InstanceTenancy", Preconditions.checkNotNull(instanceTenancy, "instanceTenancy"));
        return this;
    }

    public String getInstanceTenancy() {
        return this.getFirstFormOrNull("InstanceTenancy");
    }

    public CreateVpcOptions dryRun() {
        this.formParameters.put("DryRun", "true");
        return this;
    }

    public boolean isDryRun() {
        return this.getFirstFormOrNull("DryRun") != null;
    }

    public static class Builder {
        public static CreateVpcOptions withInstanceTenancy(String instanceTenancy) {
            CreateVpcOptions options = new CreateVpcOptions();
            return options.withInstanceTenancy(instanceTenancy);
        }

        public static CreateVpcOptions dryRun() {
            CreateVpcOptions options = new CreateVpcOptions();
            return options.dryRun();
        }
    }
}

