/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public class B2JsonLongHandler
implements B2JsonTypeHandler<Long> {
    private final boolean isPrimitive;

    public B2JsonLongHandler(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Type getHandledType() {
        return Long.class;
    }

    @Override
    public void serialize(Long obj, B2JsonOptions options, B2JsonWriter out) throws IOException {
        out.writeText(obj.toString());
    }

    @Override
    public Long deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readNumberAsString();
        return this.deserializeUrlParam(str);
    }

    @Override
    public Long deserializeUrlParam(String value) throws B2JsonException {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new B2JsonException("bad long: " + value);
        }
    }

    @Override
    public Long defaultValueForOptional() {
        if (this.isPrimitive) {
            return 0L;
        }
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

