/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.utility.BackUpImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class RebackupFromDeviceVersion {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase mainPB001DB = client.getDatabase(uri.getDatabase());
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection deviceColl = db.getCollection("DEVICE");
        MongoCollection reBkpCollection = mainPB001DB.getCollection("RE_BACKUP");
        MongoCollection deviceReBkpTmpColl = db.getCollection("DEVICE_RE_BACKUP_TEMP");
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deleted", (Object)false));
        whereQuery.add(new BasicDBObject("blocked", (Object)false));
        andQuery.put((Object)"$and", whereQuery);
        FindIterable devices = deviceColl.find((Bson)andQuery);
        FindIterable completedDevices = deviceReBkpTmpColl.find();
        System.out.println(deviceColl.count((Bson)andQuery));
        ArrayList<Document> filteredDevice = new ArrayList<Document>();
        HashSet<String> completedUUIDS = new HashSet<String>();
        try {
            for (Document completedDevice : completedDevices) {
                if (completedDevice == null || StringUtils.isEmpty((String)completedDevice.getString((Object)"deviceUUID"))) continue;
                completedUUIDS.add(completedDevice.getString((Object)"deviceUUID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(completedUUIDS.size());
        for (Document dev2 : devices) {
            if (dev2 == null || StringUtils.isEmpty((String)dev2.getString((Object)"clientVersion"))) continue;
            if (!completedUUIDS.contains(dev2.getString((Object)"deviceUUID"))) {
                System.out.println(dev2.getString((Object)"clientVersion"));
                if (RebackupFromDeviceVersion.isInstalledversionLatest("2.5.2.13", dev2.getString((Object)"clientVersion"))) {
                    filteredDevice.add(dev2);
                    continue;
                }
                System.out.println(".......");
                continue;
            }
            System.out.println(String.valueOf(dev2.getString((Object)"clientVersion")) + " already done so continue");
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " filter device count : " + filteredDevice.size());
        filteredDevice.parallelStream().forEach(dev -> {
            FindIterable folders;
            BasicDBObject folderQuery = new BasicDBObject();
            ArrayList<BasicDBObject> folderWhereQuery = new ArrayList<BasicDBObject>();
            folderWhereQuery.add(new BasicDBObject("deviceUUID", (Object)dev.getString((Object)"deviceUUID")));
            folderWhereQuery.add(new BasicDBObject("folder", (Object)true));
            folderWhereQuery.add(new BasicDBObject("present", (Object)true));
            folderQuery.put((Object)"$and", folderWhereQuery);
            MongoCollection bkpColl = db.getCollection(dev.getString((Object)"destCollection"));
            ArrayList<Document> allFoldersList = new ArrayList<Document>();
            int skip = 0;
            while ((folders = bkpColl.find((Bson)folderQuery).skip(skip * 500).limit(500)).first() != null) {
                for (Document document : folders) {
                    allFoldersList.add(document);
                }
                ++skip;
            }
            System.out.println(String.valueOf(Thread.currentThread().getName()) + " folder is done deviceUUID :" + dev.getString((Object)"deviceUUID") + " folders size :" + allFoldersList.size());
            HashMap filesSet = new HashMap();
            try {
                allFoldersList.parallelStream().forEach(devicePath -> {
                    BasicDBObject filesQuery = new BasicDBObject();
                    String folderName = "";
                    folderName = StringUtils.isEmpty((String)devicePath.getString((Object)"devicePath")) ? devicePath.getString((Object)"fileName") : String.valueOf(devicePath.getString((Object)"devicePath")) + "/" + devicePath.getString((Object)"fileName");
                    System.out.println(folderName);
                    ArrayList<BasicDBObject> filesWhereQuery = new ArrayList<BasicDBObject>();
                    filesWhereQuery.add(new BasicDBObject("deviceUUID", (Object)dev.getString((Object)"deviceUUID")));
                    filesWhereQuery.add(new BasicDBObject("folder", (Object)false));
                    filesWhereQuery.add(new BasicDBObject("present", (Object)true));
                    filesWhereQuery.add(new BasicDBObject("devicePath", (Object)folderName));
                    Pattern pattern = Pattern.compile(String.valueOf(Pattern.quote("pst")) + "$", 2);
                    filesWhereQuery.add(new BasicDBObject("fileName", (Object)pattern));
                    filesQuery.put((Object)"$and", filesWhereQuery);
                    int fileSkip = 0;
                    while (true) {
                        FindIterable files;
                        if ((files = bkpColl.find((Bson)filesQuery).skip(fileSkip * 500).limit(500)).first() == null) break;
                        for (Document document2 : files) {
                            filesSet.put(document2.getString((Object)"fileName"), document2.getObjectId((Object)"_id").toString());
                        }
                        ++fileSkip;
                    }
                    System.out.println("........");
                    filesSet.size();
                    for (Map.Entry entry : filesSet.entrySet()) {
                        try {
                            Document rebkpFile = new Document();
                            Document bkpFile = (Document)bkpColl.find((Bson)new BasicDBObject("_id", (Object)new ObjectId((String)entry.getValue()))).first();
                            if (bkpFile == null) continue;
                            String folderPath = "";
                            folderPath = StringUtils.isEmpty((String)devicePath.getString((Object)"devicePath")) ? devicePath.getString((Object)"fileName") : String.valueOf(devicePath.getString((Object)"devicePath")) + "/" + devicePath.getString((Object)"fileName");
                            rebkpFile.put("_id", (Object)new ObjectId((String)entry.getValue()));
                            rebkpFile.put("userName", (Object)bkpFile.getString((Object)"userName"));
                            rebkpFile.put("fileName", (Object)bkpFile.getString((Object)"fileName"));
                            rebkpFile.put("devicePath", (Object)bkpFile.getString((Object)"devicePath"));
                            rebkpFile.put("deviceId", (Object)dev.getObjectId((Object)"_id").toString());
                            reBkpCollection.insertOne((Object)rebkpFile);
                            System.out.println("inserted");
                        }
                        catch (Exception e) {
                            System.out.println("Exception:" + e.getLocalizedMessage());
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Document deviceReBkpTmp = new Document();
                deviceReBkpTmp.put("deviceUUID", (Object)dev.getString((Object)"deviceUUID"));
                deviceReBkpTmpColl.insertOne((Object)deviceReBkpTmp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    public static int VersionCompare(String versionFromServer, String installedVersion) {
        int v2Len;
        int v1Len = StringUtils.countMatches((String)versionFromServer, (String)".");
        if (v1Len != (v2Len = StringUtils.countMatches((String)installedVersion, (String)"."))) {
            int i;
            int count = Math.abs(v1Len - v2Len);
            if (v1Len > v2Len) {
                i = 1;
                while (i <= count) {
                    installedVersion = String.valueOf(installedVersion) + ".0";
                    ++i;
                }
            } else {
                i = 1;
                while (i <= count) {
                    versionFromServer = String.valueOf(versionFromServer) + ".0";
                    ++i;
                }
            }
        }
        if (versionFromServer.equals(installedVersion)) {
            return 0;
        }
        String[] v1Str = StringUtils.split((String)versionFromServer, (String)".");
        String[] v2Str = StringUtils.split((String)installedVersion, (String)".");
        int i = 0;
        while (i < v1Str.length) {
            int num2;
            int num1 = Integer.parseInt(v1Str[i]);
            if (num1 != (num2 = Integer.parseInt(v2Str[i]))) {
                if (num1 > num2) {
                    return 1;
                }
                return 2;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isInstalledversionLatest(String versionFromServer, String installedVersion) {
        boolean result = false;
        int resu = RebackupFromDeviceVersion.VersionCompare(versionFromServer, installedVersion);
        if (resu == 1) {
            result = false;
        } else if (resu == 2) {
            result = true;
        }
        return result;
    }
}

