/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class RegionListHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Multimap<IdAndName, String>> {
    private final ImmutableMultimap.Builder<IdAndName, String> regions = ImmutableMultimap.builder();

    @Override
    public Multimap<IdAndName, String> getResult() {
        return this.regions.build();
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix(qName, "Region")) {
            Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
            IdAndName region = IdAndName.create(attributes.get("RegionID"), attributes.get("RegionName"));
            this.regions.putAll(region, Splitter.on(';').split(attributes.get("TerritoryName")));
        }
    }
}

