/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.handlers;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSError;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.UltraDNSWSResponseException;
import org.jclouds.ultradns.ws.xml.UltraWSExceptionHandler;

@Singleton
public class UltraDNSWSErrorHandler
implements HttpErrorHandler {
    private final ParseSax.Factory factory;
    private final Provider<UltraWSExceptionHandler> handlers;

    @Inject
    UltraDNSWSErrorHandler(ParseSax.Factory factory, Provider<UltraWSExceptionHandler> handlers) {
        this.factory = factory;
        this.handlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        Exception exception = new HttpResponseException(command, response);
        try {
            String message;
            byte[] data = HttpUtils.closeClientButKeepContentStream(response);
            String string = message = data != null ? new String(data) : null;
            if (message != null) {
                UltraDNSWSError error;
                exception = new HttpResponseException(command, response, message);
                String contentType = response.getPayload().getContentMetadata().getContentType();
                if (contentType != null && (contentType.indexOf("xml") != -1 || contentType.indexOf("unknown") != -1) && (error = (UltraDNSWSError)this.factory.create(this.handlers.get()).parse(message)) != null) {
                    exception = this.refineException(new UltraDNSWSResponseException(command, response, error));
                }
            } else {
                exception = new HttpResponseException(command, response);
            }
        }
        finally {
            HttpUtils.releasePayload(response);
            command.setException(exception);
        }
    }

    private Exception refineException(UltraDNSWSResponseException exception) {
        String message = exception.getError().getDescription().or(exception.getMessage());
        switch (exception.getError().getCode()) {
            case 0: {
                if (!exception.getError().getDescription().isPresent()) {
                    return exception;
                }
                if (exception.getError().getDescription().get().indexOf("Cannot find") == -1) {
                    return exception;
                }
                return new ResourceNotFoundException(message, exception);
            }
            case 1801: 
            case 2103: 
            case 2142: 
            case 2401: 
            case 2705: 
            case 2911: 
            case 3101: 
            case 4003: {
                return new ResourceNotFoundException(message, exception);
            }
            case 1802: 
            case 2111: 
            case 2912: 
            case 4009: {
                return new UltraDNSWSExceptions.ResourceAlreadyExistsException(message, exception);
            }
            case 7021: {
                return new UltraDNSWSExceptions.DirectionalGroupOverlapException(message, exception);
            }
        }
        return exception;
    }

    static final class ErrorCodes {
        static final int UNKNOWN = 0;
        static final int ZONE_NOT_FOUND = 1801;
        static final int ZONE_ALREADY_EXISTS = 1802;
        static final int RESOURCE_RECORD_NOT_FOUND = 2103;
        static final int RESOURCE_RECORD_ALREADY_EXISTS = 2111;
        static final int DIRECTIONALPOOL_NOT_FOUND = 2142;
        static final int ACCOUNT_NOT_FOUND = 2401;
        static final int DIRECTIONALPOOL_RECORD_NOT_FOUND = 2705;
        static final int POOL_NOT_FOUND = 2911;
        static final int POOL_ALREADY_EXISTS = 2912;
        static final int POOL_RECORD_NOT_FOUND = 3101;
        static final int GROUP_NOT_FOUND = 4003;
        static final int POOL_RECORD_ALREADY_EXISTS = 4009;
        static final int DIRECTIONALPOOL_OVERLAP = 7021;

        ErrorCodes() {
        }
    }
}

