/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.loadbalancer.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.domain.LoadBalancerType;
import org.jclouds.loadbalancer.domain.internal.LoadBalancerMetadataImpl;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIPWithId;

@Singleton
public class LoadBalancerToLoadBalancerMetadata
implements Function<LoadBalancer, LoadBalancerMetadata> {
    protected final Supplier<Set<? extends Location>> locations;
    protected final Supplier<Location> defaultLocationSupplier;

    @Inject
    public LoadBalancerToLoadBalancerMetadata(Supplier<Location> defaultLocationSupplier, @Memoized Supplier<Set<? extends Location>> locations) {
        this.locations = locations;
        this.defaultLocationSupplier = defaultLocationSupplier;
    }

    @Override
    public LoadBalancerMetadata apply(LoadBalancer input) {
        Location location = Iterables.find((Iterable)this.locations.get(), LocationPredicates.idEquals(input.getRegion()));
        String id = input.getRegion() + "/" + input.getId();
        return new LoadBalancerMetadataImpl(LoadBalancerType.LB, String.valueOf(input.getId()), input.getName(), id, location, null, ImmutableMap.of(), Iterables.transform(input.getVirtualIPs(), new Function<VirtualIPWithId, String>(){

            @Override
            public String apply(VirtualIPWithId arg0) {
                return arg0.getAddress();
            }
        }));
    }
}

