/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.utils;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.trove.v1.TroveApi;
import org.jclouds.openstack.trove.v1.domain.Instance;
import org.jclouds.openstack.trove.v1.features.InstanceApi;
import org.jclouds.openstack.trove.v1.predicates.InstancePredicates;

public class TroveUtils {
    private final TroveApi api;
    @Resource
    protected Logger logger = Logger.NULL;

    public TroveUtils(TroveApi api) {
        this.api = api;
    }

    public Instance getWorkingInstance(String region, String name, String flavorId, int size) {
        InstanceApi instanceApi = this.api.getInstanceApi(region);
        for (int retries = 0; retries < 10; ++retries) {
            Instance instance = null;
            try {
                instance = instanceApi.create(flavorId, size, name);
            }
            catch (Exception e) {
                Uninterruptibles.sleepUninterruptibly(15L, TimeUnit.SECONDS);
                this.logger.error(Arrays.toString(e.getStackTrace()), new Object[0]);
                continue;
            }
            Instance updatedInstance = this.awaitAvailable(instance, instanceApi);
            if (updatedInstance != null) {
                return updatedInstance;
            }
            instanceApi.delete(instance.getId());
            InstancePredicates.awaitDeleted(instanceApi).apply(instance);
        }
        return null;
    }

    public Instance getWorkingInstance(String region) {
        return this.getWorkingInstance(region, UUID.randomUUID().toString(), "1", 1);
    }

    private Instance awaitAvailable(Instance instance, InstanceApi iapi) {
        for (int n = 0; n < 100; ++n) {
            Instance updatedInstance = iapi.get(instance.getId());
            if (updatedInstance.getStatus() == Instance.Status.ACTIVE) {
                return updatedInstance;
            }
            if (updatedInstance.getStatus() == Instance.Status.UNRECOGNIZED) {
                return null;
            }
            Uninterruptibles.sleepUninterruptibly(15L, TimeUnit.SECONDS);
        }
        return null;
    }
}

