/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jclouds.util.Closeables2;

@Beta
public class ByteStreams2 {
    private static final int INPUT_STREAM_READ_END_OF_STREAM_INDICATOR = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashCode hashAndClose(InputStream input, HashFunction hashFunction) throws IOException {
        Preconditions.checkNotNull(input, "input");
        Preconditions.checkNotNull(hashFunction, "hashFunction");
        try {
            HashingInputStream his = new HashingInputStream(hashFunction, input);
            ByteStreams.copy(his, ByteStreams.nullOutputStream());
            HashCode hashCode = his.hash();
            return hashCode;
        }
        finally {
            Closeables2.closeQuietly(input);
        }
    }

    public static byte[] toByteArrayAndClose(InputStream input) throws IOException {
        Preconditions.checkNotNull(input, "input");
        try {
            byte[] byArray = ByteStreams.toByteArray(input);
            return byArray;
        }
        finally {
            Closeables2.closeQuietly(input);
        }
    }

    public static long copy(InputStream from, OutputStream to, int bufferSize) throws IOException {
        Preconditions.checkNotNull(from, "from");
        Preconditions.checkNotNull(to, "to");
        Preconditions.checkArgument(bufferSize >= 1, "bufferSize must be >= 1");
        byte[] buf = new byte[bufferSize];
        long total = 0L;
        int len;
        while ((len = from.read(buf)) != -1) {
            to.write(buf, 0, len);
            total += (long)len;
        }
        return total;
    }
}

