/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import javax.inject.Inject;
import org.jclouds.dynect.v3.domain.CreateRecord;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.json.Json;
import org.jclouds.rest.Binder;

public class CreateRecordBinder
implements Binder {
    private final Json json;

    @Inject
    CreateRecordBinder(Json json) {
        this.json = Preconditions.checkNotNull(json, "json");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object arg) {
        CreateRecord in = (CreateRecord)CreateRecord.class.cast(Preconditions.checkNotNull(arg, "record to create"));
        URI path = Uris.uriBuilder(request.getEndpoint()).build(ImmutableMap.builder().put("type", in.getType()).put("fqdn", in.getFQDN()).build());
        return (R)((HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(path)).payload(this.json.toJson(ImmutableMap.of("rdata", in.getRData(), "ttl", in.getTTL())))).build();
    }
}

