/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.util;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.Ints;
import java.net.URI;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeMetadataIncludingStatus;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class ComputeServiceUtils {
    public static final Pattern DELIMITED_BY_HYPHEN_ENDING_IN_HYPHEN_HEX = Pattern.compile("(.+)-[0-9a-f]+");

    public static String formatStatus(ComputeMetadataIncludingStatus<?> resource) {
        if (resource.getBackendStatus() == null) {
            return ((Enum)resource.getStatus()).toString();
        }
        return String.format("%s[%s]", resource.getStatus(), resource.getBackendStatus());
    }

    public static Statement execHttpResponse(HttpRequest request) {
        return Statements.pipeHttpResponseToBash(request.getMethod(), request.getEndpoint(), request.getHeaders());
    }

    public static Statement execHttpResponse(URI location) {
        return ComputeServiceUtils.execHttpResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET")).endpoint(location)).build());
    }

    public static Statement extractTargzIntoDirectory(HttpRequest targz, String directory) {
        return Statements.extractTargzIntoDirectory(targz.getMethod(), targz.getEndpoint(), targz.getHeaders(), directory);
    }

    public static Statement extractTargzIntoDirectory(URI targz, String directory) {
        return ComputeServiceUtils.extractTargzIntoDirectory(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET")).endpoint(targz)).build(), directory);
    }

    public static Statement extractZipIntoDirectory(HttpRequest zip, String directory) {
        return Statements.extractZipIntoDirectory(zip.getMethod(), zip.getEndpoint(), zip.getHeaders(), directory);
    }

    public static Statement extractZipIntoDirectory(URI zip, String directory) {
        return ComputeServiceUtils.extractZipIntoDirectory(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET")).endpoint(zip)).build(), directory);
    }

    public static double getCores(Hardware input) {
        double cores = 0.0;
        for (Processor processor : input.getProcessors()) {
            cores += processor.getCores();
        }
        return cores;
    }

    public static double getCoresAndSpeed(Hardware input) {
        double total = 0.0;
        for (Processor processor : input.getProcessors()) {
            total += processor.getCores() * processor.getSpeed();
        }
        return total;
    }

    public static double getSpace(Hardware input) {
        double total = 0.0;
        for (Volume volume : input.getVolumes()) {
            Float size = volume.getSize();
            if (size == null) continue;
            total += (double)size.floatValue();
        }
        return total;
    }

    public static OsFamily parseOsFamilyOrUnrecognized(String in) {
        OsFamily myOs = null;
        for (OsFamily os : OsFamily.proritisedValues()) {
            if (in.toLowerCase().replaceAll("\\s", "").indexOf(os.toString()) == -1) continue;
            myOs = os;
        }
        if (myOs != null) {
            return myOs;
        }
        for (OsFamily os : OsFamily.nonProritisedValues()) {
            if (in.toLowerCase().replaceAll("\\s", "").indexOf(os.toString()) == -1) continue;
            myOs = os;
        }
        return myOs != null ? myOs : OsFamily.UNRECOGNIZED;
    }

    public static String createExecutionErrorMessage(Map<?, Exception> executionExceptions) {
        Formatter fmt = new Formatter().format("Execution failures:%n%n", new Object[0]);
        int index = 1;
        for (Map.Entry<?, Exception> errorMessage : executionExceptions.entrySet()) {
            fmt.format("%s) %s on %s:%n%s%n%n", index++, errorMessage.getValue().getClass().getSimpleName(), errorMessage.getKey(), Throwables.getStackTraceAsString(errorMessage.getValue()));
        }
        return fmt.format("%s error[s]", executionExceptions.size()).toString();
    }

    public static String createNodeErrorMessage(Map<? extends NodeMetadata, ? extends Throwable> failedNodes) {
        Formatter fmt = new Formatter().format("Node failures:%n%n", new Object[0]);
        int index = 1;
        for (Map.Entry<? extends NodeMetadata, ? extends Throwable> errorMessage : failedNodes.entrySet()) {
            fmt.format("%s) %s on node %s:%n%s%n%n", index++, errorMessage.getValue().getClass().getSimpleName(), errorMessage.getKey().getId(), Throwables.getStackTraceAsString(errorMessage.getValue()));
        }
        return fmt.format("%s error[s]", failedNodes.size()).toString();
    }

    public static Iterable<? extends ComputeMetadata> filterByName(Iterable<? extends ComputeMetadata> nodes, final String name) {
        return Iterables.filter(nodes, new Predicate<ComputeMetadata>(){

            @Override
            public boolean apply(ComputeMetadata input) {
                return input.getName().equalsIgnoreCase(name);
            }
        });
    }

    public static Map<String, String> metadataAndTagsAsValuesOfEmptyString(TemplateOptions options) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.putAll(options.getUserMetadata());
        for (String tag : options.getTags()) {
            builder.put(tag, "");
        }
        return builder.build();
    }

    public static NodeMetadataBuilder addMetadataAndParseTagsFromValuesOfEmptyString(NodeMetadataBuilder builder, Map<String, String> map) {
        return ((NodeMetadataBuilder)builder.tags(Maps.filterValues(map, Predicates.equalTo("")).keySet())).userMetadata((Map)Maps.filterValues(map, Predicates.not(Predicates.equalTo(""))));
    }

    public static Map<String, String> metadataAndTagsAsCommaDelimitedValue(TemplateOptions options) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.putAll(options.getUserMetadata());
        if (!options.getTags().isEmpty()) {
            builder.put("jclouds_tags", Joiner.on(',').join(options.getTags()));
        }
        return builder.build();
    }

    public static NodeMetadataBuilder addMetadataAndParseTagsFromCommaDelimitedValue(NodeMetadataBuilder builder, Map<String, String> map) {
        String tagString = map.get("jclouds_tags");
        if (tagString != null) {
            builder.tags((Iterable)Splitter.on(',').split(tagString));
        }
        builder.userMetadata((Map)Maps.filterKeys(map, Predicates.not(Predicates.equalTo("jclouds_tags"))));
        return builder;
    }

    public static String parseVersionOrReturnEmptyString(OsFamily family, String in, Map<OsFamily, Map<String, String>> osVersionMap) {
        if (osVersionMap.containsKey((Object)family)) {
            if (osVersionMap.get((Object)family).containsKey(in)) {
                return osVersionMap.get((Object)family).get(in);
            }
            if (osVersionMap.get((Object)family).containsValue(in)) {
                return in;
            }
            ContainsSubstring contains = new ContainsSubstring(in.replace('-', '.'));
            try {
                String key = Iterables.find(osVersionMap.get((Object)family).keySet(), contains);
                return osVersionMap.get((Object)family).get(key);
            }
            catch (NoSuchElementException e) {
                try {
                    return Iterables.find(osVersionMap.get((Object)family).values(), contains);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    public static Map<Integer, Integer> getPortRangesFromList(int ... ports) {
        ImmutableSortedSet<Integer> sortedPorts = ImmutableSortedSet.copyOf(Ints.asList(ports));
        TreeRangeSet<Integer> ranges = TreeRangeSet.create();
        for (Integer port : sortedPorts) {
            ranges.add(Range.closedOpen(port, port + 1));
        }
        HashMap<Integer, Integer> portRanges = Maps.newHashMap();
        for (Range r : ranges.asRanges()) {
            portRanges.put((Integer)r.lowerEndpoint(), (Integer)r.upperEndpoint() - 1);
        }
        return portRanges;
    }

    public static String groupFromMapOrName(Map<String, String> metadataMap, String nodeName, GroupNamingConvention namingConvention) {
        if (metadataMap.get("jclouds-group") != null) {
            return metadataMap.get("jclouds-group");
        }
        return namingConvention.groupInUniqueNameOrNull(nodeName);
    }

    static final class ContainsSubstring
    implements Predicate<String> {
        private final String in;

        ContainsSubstring(String in) {
            this.in = in;
        }

        @Override
        public boolean apply(String input) {
            if ("".equals(input)) {
                return false;
            }
            return this.in.indexOf(input) != -1;
        }

        public String toString() {
            return String.format("containsSubString(%s)", this.in);
        }
    }
}

