/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.cloudwatch.domain.ComparisonOperator;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.http.options.BaseHttpRequestOptions;

@Beta
public class SaveAlarmOptions
extends BaseHttpRequestOptions {
    int alarmActionIndex = 1;
    int dimensionIndex = 1;
    int insufficientDataActionsIndex = 1;
    int okActionsIndex = 1;

    public SaveAlarmOptions actionsEnabled(boolean actionsEnabled) {
        this.formParameters.put("ActionsEnabled", String.valueOf(actionsEnabled));
        return this;
    }

    public SaveAlarmOptions alarmActions(Set<String> alarmActions) {
        for (String alarmAction : Preconditions.checkNotNull(alarmActions, "alarmActions")) {
            this.alarmAction(alarmAction);
        }
        return this;
    }

    public SaveAlarmOptions alarmAction(String alarmAction) {
        Preconditions.checkArgument(this.alarmActionIndex <= 5, "maximum number of alarm actions is 5");
        this.formParameters.put("AlarmActions.member." + this.alarmActionIndex, Preconditions.checkNotNull(alarmAction, "alarmAction"));
        ++this.alarmActionIndex;
        return this;
    }

    public SaveAlarmOptions alarmDescription(String alarmDescription) {
        this.formParameters.put("AlarmDescription", Preconditions.checkNotNull(alarmDescription, "alarmDescription"));
        return this;
    }

    public SaveAlarmOptions alarmName(String alarmName) {
        this.formParameters.put("AlarmName", Preconditions.checkNotNull(alarmName, "alarmName"));
        return this;
    }

    public SaveAlarmOptions comparisonOperator(ComparisonOperator comparisonOperator) {
        Preconditions.checkNotNull(comparisonOperator, "comparisonOperator");
        Preconditions.checkArgument(comparisonOperator != ComparisonOperator.UNRECOGNIZED, "comparisonOperator unrecognized");
        this.formParameters.put("ComparisonOperator", comparisonOperator.toString());
        return this;
    }

    public SaveAlarmOptions dimensions(Set<Dimension> dimensions) {
        for (Dimension dimension : Preconditions.checkNotNull(dimensions, "dimensions")) {
            this.dimension(dimension);
        }
        return this;
    }

    public SaveAlarmOptions dimension(Dimension dimension) {
        Preconditions.checkNotNull(dimension, "dimension");
        Preconditions.checkArgument(this.dimensionIndex <= 10, "maximum number of dimensions is 10");
        this.formParameters.put("Dimensions.member." + this.dimensionIndex + ".Name", dimension.getName());
        this.formParameters.put("Dimensions.member." + this.dimensionIndex + ".Value", dimension.getValue());
        ++this.dimensionIndex;
        return this;
    }

    public SaveAlarmOptions evaluationPeriods(int evaluationPeriods) {
        this.formParameters.put("EvaluationPeriods", String.valueOf(evaluationPeriods));
        return this;
    }

    public SaveAlarmOptions insufficientDataActions(Set<String> insufficientDataActions) {
        for (String insufficientDataAction : Preconditions.checkNotNull(insufficientDataActions)) {
            this.insufficientDataAction(insufficientDataAction);
        }
        return this;
    }

    public SaveAlarmOptions insufficientDataAction(String insufficientDataAction) {
        Preconditions.checkNotNull(insufficientDataAction, "insufficientDataAction");
        Preconditions.checkArgument(this.insufficientDataActionsIndex <= 5, "maximum number of insufficient data actions is 5");
        this.formParameters.put("InsufficientDataActions.member." + this.insufficientDataActionsIndex, insufficientDataAction);
        ++this.insufficientDataActionsIndex;
        return this;
    }

    public SaveAlarmOptions metricName(String metricName) {
        this.formParameters.put("MetricName", Preconditions.checkNotNull(metricName, "metricName"));
        return this;
    }

    public SaveAlarmOptions namespace(String namespace) {
        this.formParameters.put("Namespace", Preconditions.checkNotNull(namespace));
        return this;
    }

    public SaveAlarmOptions okActions(Set<String> okActions) {
        for (String okAction : Preconditions.checkNotNull(okActions, "okActions")) {
            this.okAction(okAction);
        }
        return this;
    }

    public SaveAlarmOptions okAction(String okAction) {
        Preconditions.checkNotNull(okAction, "okAction");
        Preconditions.checkArgument(this.okActionsIndex <= 5, "maximum number of ok actions is 5");
        this.formParameters.put("OKActions.member." + this.okActionsIndex, okAction);
        ++this.okActionsIndex;
        return this;
    }

    public SaveAlarmOptions period(int period) {
        this.formParameters.put("Period", String.valueOf(period));
        return this;
    }

    public SaveAlarmOptions statistic(Statistics statistic) {
        Preconditions.checkNotNull(statistic, "statistic");
        Preconditions.checkArgument(statistic != Statistics.UNRECOGNIZED, "statistic unrecognized");
        this.formParameters.put("Statistic", statistic.toString());
        return this;
    }

    public SaveAlarmOptions threshold(double threshold) {
        this.formParameters.put("Threshold", String.valueOf(threshold));
        return this;
    }

    public SaveAlarmOptions unit(Unit unit) {
        Preconditions.checkNotNull(unit, "unit");
        Preconditions.checkArgument(unit != Unit.UNRECOGNIZED, "unit unrecognized");
        this.formParameters.put("Unit", unit.toString());
        return this;
    }
}

