/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.handlers;

import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;

public class ChefApiErrorRetryHandler
implements HttpRetryHandler {
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    private int retryCountLimit = 5;
    @Resource
    protected Logger logger = Logger.NULL;
    private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;

    @Inject
    ChefApiErrorRetryHandler(BackoffLimitedRetryHandler backoffLimitedRetryHandler) {
        this.backoffLimitedRetryHandler = backoffLimitedRetryHandler;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        String error;
        if (command.getFailureCount() > this.retryCountLimit) {
            return false;
        }
        if (response.getStatusCode() == 400 && command.getCurrentRequest().getMethod().equals("PUT") && command.getCurrentRequest().getEndpoint().getPath().indexOf("sandboxes") != -1 && response.getPayload() != null && (error = new String(HttpUtils.closeClientButKeepContentStream(response))) != null && error.indexOf("was not uploaded") != -1) {
            return this.backoffLimitedRetryHandler.shouldRetryRequest(command, response);
        }
        return false;
    }
}

