/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.jclouds.blobstore.options.AutoValue_CopyOptions;
import org.jclouds.io.ContentMetadata;
import org.jclouds.javax.annotation.Nullable;

@Beta
public abstract class CopyOptions {
    public static final CopyOptions NONE = CopyOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_CopyOptions.Builder();
    }

    @Nullable
    public abstract ContentMetadata contentMetadata();

    @Nullable
    public abstract Map<String, String> userMetadata();

    @Nullable
    public abstract Date ifModifiedSince();

    @Nullable
    public abstract Date ifUnmodifiedSince();

    @Nullable
    public abstract String ifMatch();

    @Nullable
    public abstract String ifNoneMatch();

    public static abstract class Builder {
        public abstract Builder contentMetadata(ContentMetadata var1);

        public abstract Builder userMetadata(Map<String, String> var1);

        public abstract Builder ifModifiedSince(Date var1);

        public abstract Builder ifUnmodifiedSince(Date var1);

        public abstract Builder ifMatch(String var1);

        public abstract Builder ifNoneMatch(String var1);

        abstract Map<String, String> userMetadata();

        abstract CopyOptions autoBuild();

        public CopyOptions build() {
            Map<String, String> userMetadata = this.userMetadata();
            if (userMetadata != null) {
                this.userMetadata(ImmutableMap.copyOf(userMetadata));
            }
            return this.autoBuild();
        }
    }
}

