/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import java.io.IOException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.Payload;

public class AWSEC2IOExceptionRetryHandler
extends BackoffLimitedRetryHandler {
    private static final String DESCRIBE_ACTION = "Action=Describe";

    @Override
    public boolean shouldRetryRequest(HttpCommand command, IOException error) {
        Payload payload;
        HttpRequest request = command.getCurrentRequest();
        if ("POST".equals(request.getMethod()) && !(payload = request.getPayload()).getRawContent().toString().contains(DESCRIBE_ACTION)) {
            this.logger.error("Command not considered safe to retry because request method is POST and action may not be idempotent: %1$s", command);
            return false;
        }
        return super.shouldRetryRequest(command, error);
    }
}

